# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2011, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: opendocument text generation

=end
module SiSU_ODF
  require "#{SiSU_lib}/particulars"                        # particulars.rb
    include SiSU_Particulars
  require "#{SiSU_lib}/dal"                                # dal.rb
  require "#{SiSU_lib}/sysenv"                             # sysenv.rb
    include SiSU_Env
  include SiSU_Viz
  require "#{SiSU_lib}/odf_format"                         # odf_format.rb
    include SiSU_ODF_format
  require "#{SiSU_lib}/shared_metadata"                    # shared_metadata.rb
  require "#{SiSU_lib}/shared_txt"                         # shared_txt.rb
  @@alt_id_count,@@alt_id_count,@@tablehead,@@number_of_cols=0,0,0,0
  class Source
    require 'zlib'
    require 'find'
    require 'fileutils'
    include FileUtils
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
      @@endnotes_para=[]
    end
    def read
      begin
        @env,@md,@dal_array=@particulars.env,@particulars.md,@particulars.dal_array
        opendoc=@md.fn[:odf]
        path=@env.path.output_tell
        unless @opt.cmd =~/q/
          tool=(@opt.cmd =~/[MVv]/) \
          ? "#{@env.program.odf_viewer} #{path}/#{@md.fnb}/#{opendoc}" \
          : @opt.fns
          @opt.cmd=~/[MVvz]/ \
          ? SiSU_Screen::Ansi.new(@opt.cmd,'Opendocument (ODF:ODT)',tool).green_hi_blue \
          : SiSU_Screen::Ansi.new(@opt.cmd,'Opendocument (ODF:ODT)',tool).green_title_hi
          SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output_tell}/#{@md.fnb}/#{opendoc}").flow if @opt.cmd =~/[MV]/
        end
        my_make=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns)
        SiSU_ODF::Source::Scroll.new(@particulars).songsheet
        SiSU_Env::Info_skin.new(@md).select
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Scroll <Source
      require "#{SiSU_lib}/defaults"                       # defaults.rb
      require "#{SiSU_lib}/shared_txt"                     # shared_txt.rb
      @@img_count=0
      @@odf={ :body=>[],:open=>[],:close=>[],:head=>[],:metadata=>[],:tail=>[],:endnotes=>[] }
      @@docstart=true
      @@fns=nil
      def initialize(particulars)
        @env,@md,@dal_array=particulars.env,particulars.md,particulars.dal_array
        @vz=SiSU_Env::Get_init.instance.skin
        @tab="\t"
        @brace_url=SiSU_Viz::Skin.new.url_decoration
        @br=(@md.cmd =~/M/) ? '' : ''
        #@br=(@md.cmd =~/M/) ? "\n" : ''
      end
      def songsheet
        pre
        @data=markup(@dal_array)
        post
        publish
      end
      # Used for extraction of endnotes from paragraphs
      def extract_endnotes(dob='')
        notes=dob.obj.scan(/#{Mx[:en_a_o]}(\d+\s+.+?)#{Mx[:en_a_c]}/)[1] #FIX
        @n=[]
        notes.each do |n| #high cost to deal with <br> appropriately within odf, consider
          n=n.dup.to_s
          if n =~/#{Mx[:br_line]}/
            fix=n.split(/#{Mx[:br_line]}/) #watch #added
            fix.each do |x|
              if x =~/\S+/; @n << x
              end
            end
          else              @n << n
          end
        end
      end
      def odf_metadata
        @@odf[:metadata]=Metadata::Summary.new(@md).odf.metadata
      end
      def odf_tail
        generator="Generated by: #{@md.sisu_version[:project]} #{@md.sisu_version[:version]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"  if @md.sisu_version[:version]
        lastdone="Last Generated on: #{Time.now}"
        rubyv="Ruby version: #{@md.ruby_version}"
        sc=if @md.sc_info
          "Source file:    #{@md.sc_filename}\nVersion number: #{@md.sc_number}\nVersion date:   #{@md.sc_date}\n"
        else ''
        end
        url=@md.fnb
        fn=@md.fn[:manifest]
        manifest="#{@env.url.root}/#{@md.fnb}/#{@md.fn[:manifest]}"
        @@odf[:tail] << %{<text:p text:style-name="P1">Available document outputs: <br /> &lt;<text:a xlink:type="simple" xlink:href="#{manifest}">#{manifest}</text:a>&gt;</text:p>}
        @@odf[:tail] << %{\n<text:p text:style-name="P1">SiSU: &lt;<text:a xlink:type="simple" xlink:href="http://www.jus.uio.no/lm">www.jus.uio.no/sisu</text:a>&gt; and &lt;<text:a xlink:type="simple" xlink:href="http://www.sisudoc.org">www.sisudoc.org</text:a>&gt;</text:p>}
        @@odf[:tail] << "\n</office:text></office:body></office:document-content>"
      end
      def heading(dob)
        dob.obj.gsub!(/#{Mx[:tag_o]}\S+?#{Mx[:tag_c]}/,'') #check
        m=/#{$1}/
        breakpage=''
        if @md.fns \
        and @md.fns != '' \
        and @md.fns !=@@fns
          @@docstart=true
          @@fns=@md.fns
        end
        unless @@docstart
          breakpage=if (@md.pagenew or @md.pagebreak) \
          and (@md.pagenew =~ m or @md.pagebreak =~m)
            '<text:p text:style-name="P9"> </text:p>'
          else ''
          end
        end
        @@docstart=false
        dob.obj=%{#{breakpage}<text:h text:style-name="Heading_20_#{dob.ln}" text:outline-level="#{dob.ln}">#{dob.obj}</text:h>}
        dob
      end
      def image_src(i)
        image_source=if @md.fns =~/\.ss[tm]$/ \
        and FileTest.file?("#{@env.path.image_source_local_tex}/#{i}") #review
          @env.path.image_source_local_tex
        elsif @md.fns =~/\.-ss[tm]$/ \
        and FileTest.file?("#{@env.path.image_source_remote_tex}/#{i}")
          @env.path.image_source_remote_tex
        elsif FileTest.file?("#{@env.path.image_source_tex}/#{i}")
          @env.path.image_source_tex
        else
          SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:",%{"#{i}" missing},"search locations: #{@env.path.image_source_local_tex},#{@env.path.image_source_remote_tex} and #{@env.path.image_source_tex}").error2 unless @md.cmd =~/q/
          nil
        end
      end
      def image_odf(img)
        # copy image to od image directory (unless exists)
        # divide pixel dimension by 37.79485 and retain 3 decimal places
        m,u=img[1],img[2]
        i=/^(\S+?\.(?:png|jpg|gif))/.match(m).captures.join if m =~/^(\S+?\.(?:png|jpg|gif))/
        c=/^\S+?\.(?:png|jpg|gif)\s+.+?"(.*?)"/.match(m).captures.join if m =~/^\S+?\.(?:png|jpg|gif)\s+.+?"(.*?)"/
        w,h=/\s(\d+)x(\d+)/.match(m).captures if m =~/\s\d+x\d+/
        w=(w.to_i/37.79485).to_s
        h=(h.to_i/37.79485).to_s
        h=/([0-9]+\.\d{0,3})/.match(h).captures.join
        w=/([0-9]+\.\d{0,3})/.match(w).captures.join
        image_source=image_src(i)
        pwd=Dir.pwd
        cp("#{image_source}/#{i}","#{@env.path.odf}/Pictures/#{i}") if image_source
        img=if i.to_s =~/jpg|png|gif/ \
        and h.to_s =~/\d/ \
        and w.to_s =~/\d/
          @@img_count +=1
          %{<draw:frame draw:style-name="fr1" draw:name="graphics#{@@img_count}" text:anchor-type="as-char" svg:width="#{w}cm" svg:height="#{h}cm" draw:z-index="2"><draw:image xlink:href="Pictures/#{i}" xlink:type="simple" xlink:show="embed" xlink:actuate="onLoad"/></draw:frame>#{c}} #anchor-type: as-char or paragraph or char or ...
        else %{<text:p text:style-name="P1">[image omitted]</text:p>}
        end
      end
      def image(dob)
        m=if dob.obj =~/#{Mx[:lnk_o]}[ ]*(.+?)[ ]*#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
          dob.obj.scan(/(#{Mx[:lnk_o]}[ ]*(.+?)[ ]*#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]})/)
        elsif dob.obj =~/#{Mx[:lnk_o]}[ ]*(.+?)[ ]*#{Mx[:lnk_c]}image/
          dob.obj.scan(/(#{Mx[:lnk_o]}[ ]*(.+?)[ ]*#{Mx[:lnk_c]}(image))/)
        else nil
        end
        if m; m.each do |i|
            cont,url=i[1],i[2]
            cont.gsub!(/([)(\]\[])/,"\\\\\\1")
            cont.gsub!(/([+?])/,"\\\\\\1") # incorrect handling of +
            url.gsub!(/([+?])/,"\\\\\\1")
            dob.obj.sub!(/#{Mx[:lnk_o]}[ ]*#{cont}[ ]*#{Mx[:lnk_c]}image/m,image_odf(i))
            dob.obj.sub!(/#{Mx[:lnk_o]}[ ]*#{cont}[ ]*#{Mx[:lnk_c]}#{Mx[:url_o]}#{url}#{Mx[:url_c]}/m,image_odf(i))
            dob.obj.gsub!(/\\([)(\]\[?])/,'\1') #clumsy fix
          end
          m=nil
        end
        dob
      end
      def text_link_odf(txt,url,trail)
        txt.gsub!(/(\\\+)/,'+') #this is convoluted, and risky :-(
        url.gsub!(/(\\\+)/,'+') #this is convoluted, and risky :-(
        map_nametags=SiSU_Particulars::Combined_singleton.instance.get_map_nametags(@md).nametags_map
        t=case url
        when /^https?:/
          %{<text:a xlink:type="simple" xlink:href="#{url}">#{txt.strip}</text:a>#{trail}}
        when /^:/                 # site same document collection html link
          url.gsub!(/^:/,"#{@env.url.root}/")
          %{<text:a xlink:type="simple" xlink:href="#{url}">#{txt.strip}</text:a>#{trail}}
        when /^\.\.\//                 # site same document collection html link
          url.gsub!(/^\.\.\//,"#{@env.url.root}/")
          %{<text:a xlink:type="simple" xlink:href="#{url}">#{txt.strip}</text:a>#{trail}}
        else                           # document internal link
          if map_nametags[url] \
          and map_nametags[url][:segname]
          else p "NOT FOUND name_tags: #{url}"
          end
          t=map_nametags[url] \
          && map_nametags[url][:segname] \
          ? %{<text:a xlink:type="simple" xlink:href="#{@env.url.root}/#{@md.fnb}/#{map_nametags[url][:segname]}#{Sfx[:html]}##{url}">#{txt.strip}</text:a>#{trail}} \
          : %{#{txt.strip}#{trail}}
        end
        t
      end
      def text_link(dob)
        m=dob.obj.scan(/(#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:url_o]}(\S+?)#{Mx[:url_c]})/) #sort
        if m
          m.each do |i|
            txt,url,trail=i[1],i[2]
            txt.gsub!(/([)(\]\[])/,"\\\\\\1")
            txt.gsub!(/([+?*])/,"\\\\\\1") # problems with +
            url.gsub!(/([+?])/,"\\\\\\1") # problems with +
            dob.obj.gsub!(/#{Mx[:lnk_o]}[ ]*#{txt}#{Mx[:lnk_c]}#{Mx[:url_o]}#{url}#{Mx[:url_c]}/m,text_link_odf(txt,url,trail)) #make sure trailing ']' are not caught in url
            dob.obj.gsub!(/\\([)(\]\[?])/,'\1') #clumsy fix
          end
          m=nil
        end
        dob
      end
      def text_link_relative(dob)
        m=dob.obj.scan(/(#{Mx[:lnk_o]}(.+?)#{Mx[:lnk_c]}#{Mx[:rel_o]}(\S+?)#{Mx[:rel_c]})/) #sort
        if m
          m.each do |i|
            txt,url,trail=i[1],i[2]
            txt.gsub!(/([)(\]\[])/,"\\\\\\1")
            txt.gsub!(/([+?*])/,"\\\\\\1") # problems with +
            url.gsub!(/([+?])/,"\\\\\\1") # problems with +
            dob.obj.gsub!(/#{Mx[:lnk_o]}[ ]*#{txt}#{Mx[:lnk_c]}#{Mx[:rel_o]}#{url}#{Mx[:rel_c]}/m,text_link_odf(txt,url,trail)) #make sure trailing ']' are not caught in url
            dob.obj.gsub!(/\\([)(\]\[?])/,'\1') #clumsy fix
          end
          m=nil
        end
        dob
      end
      def normal(dob)                                                           #P1 - P3
        dob.obj.gsub!(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,
          '<text:a xlink:type="simple" xlink:href="\1">\1</text:a>') #http ftp matches escaped, no decoration
        dob.obj.gsub!(/#{Mx[:url_o]}([a-zA-Z0-9._-]+\@\S+?\.[a-zA-Z0-9._-]+)#{Mx[:url_c]}/,
          %{#{@brace_url.xml_open}<text:a xlink:type="simple" xlink:href="mailto:\\1">\\1</text:a>#{@brace_url.xml_close}})
        dob.obj.gsub!(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,
          %{#{@brace_url.xml_open}<text:a xlink:type="simple" xlink:href="\\1">\\1</text:a>#{@brace_url.xml_close}}) #http ftp matches with decoration
        dob.obj= if dob.is=='para' and dob.indent.to_s =~/[0-9]/ # and t_o.bullet_==true
          %{<text:p text:style-name="P1#{dob.indent}">#{dob.obj}</text:p>}
        else %{<text:p text:style-name="P1">#{dob.obj}</text:p>}
        end
        dob
      end
      def fontface(dob)
      end
      def footnote_urls(str)
        str.gsub!(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,
          %{#{@brace_url.xml_open}<text:a xlink:type="simple" xlink:href="\\1">\\1</text:a>#{@brace_url.xml_close}})
        str=text_link(str) if str =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
        str=text_link_relative(str) if str =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}/
        str
      end
      def footnote(t_o)
        str=if defined? t_o.obj; t_o.obj
        elsif t_o.class==String; t_o
        end
        if str
          @astx||=10000
          @astxs||=20000
          if str =~/#{Mx[:en_a_o]}\d+\s+/
            str.gsub!(/#{Mx[:en_a_o]}(\d+)\s+(.+?)#{Mx[:en_a_c]}/,'<text:note text:id="ftn\1" text:note-class="footnote"><text:note-citation>\1</text:note-citation><text:note-body><text:p text:style-name="Footnote"> \2</text:p><text:p text:style-name="Footnote"/></text:note-body></text:note>')
          end
          if str =~/#{Mx[:en_a_o]}([*]+)\s+/
            a=$1.gsub(/([*])/,"\\\\\\1")
              str.gsub!(/#{Mx[:en_a_o]}([*]+)\s+(.+?)#{Mx[:en_a_c]}/,%{<text:note text:id="ftn#{@astx.to_s}" text:note-class="footnote"><text:note-citation text:label="\\1">\\1</text:note-citation><text:note-body><text:p text:style-name="Footnote"> \\2</text:p><text:p text:style-name="Footnote"/></text:note-body></text:note>})
              @astxs+=1
          end
          if str=~/#{Mx[:en_a_o]}[*+]+\s/
            asterisk=str.scan(/#{Mx[:en_a_o]}([*+]+)\s+(.+?)#{Mx[:en_a_c]}/)
            asterisk.each do |x|
              a=x[0].gsub(/([*+])/,"\\\\\\1")
              str=group_clean(str)
              str=footnote_urls(str)
              str.gsub!(/#{Mx[:en_a_o]}(#{a})\s+(.+?)#{Mx[:en_a_c]}/,%{<text:note text:id="ftn#{@astx.to_s}" text:note-class="footnote"><text:note-citation text:label="\\1">\\1</text:note-citation><text:note-body><text:p text:style-name="Footnote"> \\2</text:p><text:p text:style-name="Footnote"/></text:note-body></text:note>})
              @astx+=1
            end
          end
          if str=~/#{Mx[:en_b_o]}[*+]\d+\s/
            asterisk=str.scan(/#{Mx[:en_b_o]}([*+]\d+)\s+(.+?)#{Mx[:en_b_c]}/)
            asterisk.each do |x|
              a=x[0].gsub(/([*+])/,"\\\\\\1")
              str=group_clean(str)
              str=footnote_urls(str)
              str.gsub!(/#{Mx[:en_b_o]}(#{a})\s+(.+?)#{Mx[:en_b_c]}/,%{<text:note text:id="ftn#{@astx.to_s}" text:note-class="footnote"><text:note-citation text:label="\\1">\\1</text:note-citation><text:note-body><text:p text:style-name="Footnote"> \\2</text:p><text:p text:style-name="Footnote"/></text:note-body></text:note>})
              @astx+=1
            end
          end
        end
        if defined? t_o.obj; t_o.obj=str
        elsif t_o.class==String; t_o=str
        end
        t_o
      end
      def group_clean(str)
        str.gsub!(/&amp;nbsp;|&nbsp;|#{Mx[:nbsp]}/,'&#160;')
        str.gsub!(/</,'&lt;'); str.gsub!(/>/,'&gt;')
        str.gsub!(/&lt;(text:span text:style-name="T[1-5]"|\/text:span)&gt;/,'<\1>') #works, not ideal
        str.gsub!(/#{Mx[:br_line]}/,'<br />')
        str.gsub!(/&lt;br(?:\s+\/)?&gt;/,'<br />')
        str
      end
      def poem(dob)                                                             #P4 #same as group
        parray=[]
        dob.obj.split(/#{Mx[:br_line]}|#{Mx[:br_nl]}/).each do |parablock|
          parablock=group_clean(parablock)
          parray << %{<text:p text:style-name="P4">#{parablock}</text:p>} if parablock =~/\S+/
        end
        dob.obj=parray.join + '<text:p text:style-name="Standard"/>'
        dob
      end
      def group(dob)                                                            #P4 #same as verse
        parray=[]
        dob.obj.gsub!(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,
          '<text:a xlink:type="simple" xlink:href="\1">\1</text:a>') #http ftp matches escaped, no decoration
        dob.obj.gsub!(/#{Mx[:url_o]}([a-zA-Z0-9._-]+\@\S+?\.[a-zA-Z0-9._-]+)#{Mx[:url_c]}/,
          %{#{@brace_url.xml_open}<text:a xlink:type="simple" xlink:href="mailto:\\1">\\1</text:a>#{@brace_url.xml_close}})
        dob.obj.gsub!(/#{Mx[:url_o]}(\S+?)#{Mx[:url_c]}/,
          %{#{@brace_url.xml_open}<text:a xlink:type="simple" xlink:href="\\1">\\1</text:a>#{@brace_url.xml_close}}) #http ftp matches with decoration
        dob.obj.split(/#{Mx[:br_line]}|#{Mx[:br_nl]}/).each do |parablock|
          parablock=group_clean(parablock)
          parablock.gsub!(/&lt;text:a xlink:type="simple" xlink:href="(.+?)"&gt;/m,'<text:a xlink:type="simple" xlink:href="\1">')
          parablock.gsub!(/&lt;(\/text:a)&gt;/,'<\1>')
          parablock.gsub!(/&lt;(text:note text:id=.+?)&gt;/,'<\1>')
          parablock.gsub!(/&lt;(text:p text:style-name="Footnote")&gt;/,'<\1>')
          parablock.gsub!(/&lt;(\/?text:(?:note-citation|note-body|note|p))&gt;/,'<\1>')
          parablock=footnote(parablock)
          parray << %{<text:p text:style-name="P4">#{parablock}</text:p>} if parablock =~/\S+/
        end
        dob.obj=parray.join + '<text:p text:style-name="Standard"/>'
        dob
      end
      def code(dob)                                                             #P5
        if dob.is=='code'
          dob.obj.gsub!(/\s\s/,'&#160;&#160;')
          parray=[]
          dob.obj.split(/#{Mx[:br_line]}|#{Mx[:br_nl]}/).each do |parablock|
            parablock=group_clean(parablock)
            parablock.gsub!(/^\s*$/,'<br />')
            parablock.gsub!(/#{Mx[:url_o]}_(\S+?)#{Mx[:url_c]}/,
              '<text:a xlink:type="simple" xlink:href="\1">\1</text:a>') #http ftp matches escaped, no decoration
            parray << %{<text:p text:style-name="P20">#{parablock}</text:p>} if parablock =~/\S+/
          end
          dob.obj=parray.join + '<text:p text:style-name="Standard"/>'
        end
        dob
      end
      def table(dob)                                                            #
        if dob.is =='table'
          table=SiSU_ODF_format::Table.new(@md,dob)
          dob=table.table
        end
        dob
      end
      def obj_break(dob)
        if dob.is =='break'
          br=SiSU_ODF_format::Format_obj_break.new(@md,dob)
          if dob.obj==Mx[:br_page] \
          or dob.obj==Mx[:br_page_new]
            dob=br.br_page
          elsif dob.obj==Mx[:obj_ln_sep]
            dob=br.obj_sep
          end
        end
        dob
      end
      def odf_structure(md,dob)
        @md,@dob=md,dob
        dob=if dob.is !='code'
          dob=image(dob) if dob.obj =~/#{Mx[:lnk_o]}[ ]*\S+?\.(?:png|jpg|gif)\s.+?#{Mx[:lnk_c]}(?:#{Mx[:url_o]}\S+?#{Mx[:url_c]}|image)/
          dob=text_link(dob) if dob.obj =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:url_o]}\S+?#{Mx[:url_c]}/
          dob=text_link_relative(dob) if dob.obj =~/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}\S+?#{Mx[:rel_c]}/
          dob
        else dob
        end
        dob=footnote(dob)
        if dob.is=='heading'
          @@odf[:body] << heading(dob).obj << @br*2
        elsif dob.is =='verse'
          @@odf[:body] << poem(dob).obj << @br*2
        elsif dob.is=='group'
          @@odf[:body] << group(dob).obj << @br*2
        elsif dob.is=='code'
          @@odf[:body] << code(dob).obj << @br*2
        elsif dob.is=='table' #elsif dob.obj =~ /<!Th?¡/u
          @@odf[:body] << table(dob).obj << @br*2
        elsif dob.is=='break'
          @@odf[:body] << obj_break(dob).obj << @br*2
        else
          @@odf[:body] << normal(dob).obj << @br*2 # main text, contents, body KEEP
        end
        @@endnotes_para=[]
      end
      def tidywords(wordlist)
        wordlist
      end
      def markup(data)                                                                 # Used for major markup instructions
        safe_characters=/[^a-zA-Z0-9}{\/?,."';:)(><\-_&!@%~#\]\[*=$| \n+`#{Mx[:tc_p]}]/u
        dir=SiSU_Env::Info_env.new(@md.fns)
        dir.path.odf_bld
        @data_mod,@endnotes,@level,@cont,@copen,@odf_contents_close=Array.new(6){[]}
        @rcdc=false
        (0..6).each { |x| @cont[x]=@level[x]=false }
        (4..6).each { |x| @odf_contents_close[x]='' }
        odf_tail #($1,$2)
        fix=[]
        bullet=image_src('bullet_09.png')
        cp("#{bullet}/bullet_09.png","#{@env.path.odf}/Pictures/.") #if image_src('bullet_09.png')
        odf_metadata
        data.each do |dob|
          #p dob.obj if dob.obj =~safe_characters and @md.cmd =~/V/ #KEEP
          dob.obj='' if dob.obj =~/#{Mx[:lv_o]}\d+:.*?#{Mx[:lv_c]}.+?#{Mx[:pa_non_object_dummy_heading]}/ #fix Mx[:lv_o]
          para_array=[]
          dob.obj.gsub!(/</,'&lt;'); dob.obj.gsub!(/>/,'&gt;')
          word=dob.obj.scan(/\S+|\n/)
          if word
            word.each do |w| # _ - / # | : ! ^ ~
              unless dob =~/^(?:#{Rx[:meta]}|%+ )/m
                w.gsub!(/&#(?:126|152);/,'~') #126 usual
                w.gsub!(/&nbsp;/,'&#160;')
                if w !~/&\S{2,7}?;/
                  w.gsub!(/&/,'&amp;')
                end
                w.gsub!(/(&\S{1,7};)+&/,'\1&amp;') #could break things
              end
              para_array << w
            end
            dob.obj=para_array.join(' ')
            dob.obj=dob.obj.strip
          end
          if dob.is=='code' #{Mx[:gr_o]}code#{Mx[:gr_c]}/ #fix #code-block: angle brackets special characters #fix
            dob.obj.gsub!(/(^|[^}])_(?:<|&lt;)/m,'\1&lt;'); dob.obj.gsub!(/(^|[^}])_(?:>|&gt;)/m,'\1&gt;')
            dob.obj.gsub!(/(^|[^}])_(?:<|&lt;)/m,'\1&lt;'); dob.obj.gsub!(/(^|[^}])_(?:>|&gt;)/m,'\1&gt;')
          end
          if dob.of=='group'
            dob.obj.gsub!(/#{Mx[:gl_bullet]}/,'● ')
          end
          dob.obj.gsub!(/#{Mx[:fa_strike_o]}(.+?)#{Mx[:fa_strike_c]}/,'<del>\1</del>')
          dob.obj.gsub!(/#{Mx[:fa_insert_o]}(.+?)#{Mx[:fa_insert_c]}/,'<ins>\1</ins>')
          dob.obj.gsub!(/#{Mx[:fa_cite_o]}(.+?)#{Mx[:fa_cite_c]}/,'<cite>\1</cite>')
          dob.obj.gsub!(/#{Mx[:tag_o]}\S+?#{Mx[:tag_c]}/,'') #check
          dob.obj.gsub!(/#{Mx[:mk_o]}#([a-zA-Z]+)#{Mx[:mk_c]}/,'&\1;')
          dob.obj.gsub!(/#{Mx[:mk_o]}(#[0-9]+)#{Mx[:mk_c]}/,'&\1;')
          dob.obj.gsub!(/#{Mx[:mk_o]}[~-]##{Mx[:mk_c]}/,'')
          if dob.is=='para' \
          and dob.bullet_
            dob.obj='<draw:frame draw:style-name="gr1" text:anchor-type="as-char" svg:width="0.22cm" svg:height="0.22cm" draw:z-index="2"><draw:image xlink:href="Pictures/bullet_09.png" xlink:type="simple" xlink:show="embed" xlink:actuate="onLoad"/></draw:frame> ' +
              dob.obj
          end
          dob.obj.gsub!(/#{Mx[:br_line]}/,'<br />')
          dob.obj.gsub!(/&#169;/,'©') #too arbitrary
          dob.obj.gsub!(/.+?<-#>/,'')                                           # remove dummy headings (used by html) #check
          dob.obj.gsub!(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,
            '<text:span text:style-name="T1">\1</text:span>')
          dob.obj.gsub!(/#{Mx[:fa_italics_o]}(.+?)#{Mx[:fa_italics_c]}/,
            '<text:span text:style-name="T2">\1</text:span>')
          dob.obj.gsub!(/#{Mx[:fa_underscore_o]}(.+?)#{Mx[:fa_underscore_c]}/,
            '<text:span text:style-name="T3">\1</text:span>')
          dob.obj.gsub!(/#{Mx[:fa_superscript_o]}(.+?)#{Mx[:fa_superscript_c]}/,
            '<text:span text:style-name="T4">\1</text:span>')
          dob.obj.gsub!(/#{Mx[:fa_subscript_o]}(.+?)#{Mx[:fa_subscript_c]}/,
            '<text:span text:style-name="T5">\1</text:span>')
          dob.obj.gsub!(/#{Mx[:fa_monospace_o]}(.+?)#{Mx[:fa_monospace_c]}/,
            '<text:span text:style-name="T7">\1</text:span>')
          dob.obj.gsub!(/­/u,'-')
          dob.obj.gsub!(/ /u, ' ')       # space identify
          dob.obj.gsub!(/ /u, ' ')       # space identify
          dob.obj.gsub!(/·/u,'*')
          dob.obj.gsub!(/[­–—]/u,'-')   #— – chk
          dob.obj.gsub!(/ < /i,'&#060;')
          dob.obj.gsub!(/\\copy(?:right)?\b/,'&#169;')
          dob.obj.gsub!(/\\trademark\b|\\tm\b/,'&#174;')
          dob.obj.gsub!(/\44/,'&#36;') #$ watch
          dob.obj.gsub!(/<a href=".+?">(.+?)<\/a>/,'\1')
          dob.obj.gsub!(/#{Mx[:mk_o]}name#\S+?#{Mx[:mk_c]}/,'')                                       # remove name links
          wordlist=dob.obj.scan(/\S+/)
          dob.obj=tidywords(wordlist).join(' ').strip
          @rcdc=true if @rcdc==false \
          and (dob.obj =~/~metadata/ or dob =~/#{Mx[:lv_o]}1:meta#{Mx[:lv_x]}\s*Document Information/) #fix Mx[:lv_o]
          if dob.is !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
            if defined? dob.ocn and dob.ocn =~/\d+/
              @p_num=SiSU_ODF_format::Paragraph_number.new(dob.ocn)
            end
            if dob.is=~/heading|para|group|verse|code|table|break/ # extend, include other types
              odf_structure(@md,dob)
            end
            dob.obj.gsub!(/<!.+!>/,' ') if dob.obj ## Clean Prepared Text
            dob.obj.gsub!(/#{Mx[:tc_o]}.+?#{Mx[:tc_c]}/,' ') if dob.obj ## CHECK Clean Prepared Text
            dob.obj.gsub!(/<:\S+>/,' ') if dob.obj ## Clean Prepared Text
          end
        end
      end
      def pre
        table=if @md.flag_tables
          x=<<WOK
  <style:style style:name="Table1" style:family="table"><style:table-properties style:width="16.999cm" table:align="margins"/></style:style>
  <style:style style:name="Table1.A" style:family="table-column"><style:table-column-properties style:column-width="16.999cm" style:rel-column-width="65535*"/></style:style>
  <style:style style:name="Table1.B" style:family="table-column"><style:table-column-properties style:column-width="8.499cm" style:rel-column-width="32767*"/></style:style>
  <style:style style:name="Table1.C" style:family="table-column"><style:table-column-properties style:column-width="5.666cm" style:rel-column-width="21845*"/></style:style>
  <style:style style:name="Table1.D" style:family="table-column"><style:table-column-properties style:column-width="4.349cm" style:rel-column-width="16383*"/></style:style>
  <style:style style:name="Table1.E" style:family="table-column"><style:table-column-properties style:column-width="3.399cm" style:rel-column-width="13107*"/></style:style>
  <style:style style:name="Table1.F" style:family="table-column"><style:table-column-properties style:column-width="2.833cm" style:rel-column-width="10922*"/></style:style>
  <style:style style:name="Table1.G" style:family="table-column"><style:table-column-properties style:column-width="2.428cm" style:rel-column-width="9362*"/></style:style>
  <style:style style:name="Table1.H" style:family="table-column"><style:table-column-properties style:column-width="2.124cm" style:rel-column-width="8191*"/></style:style>
  <style:style style:name="Table2" style:family="table"><style:table-properties style:width="16.999cm" table:align="margins"/></style:style>
  <style:style style:name="Table2.A" style:family="table-column"><style:table-column-properties style:column-width="16.999cm" style:rel-column-width="65535*"/></style:style>
  <style:style style:name="Table2.B" style:family="table-column"><style:table-column-properties style:column-width="8.499cm" style:rel-column-width="32767*"/></style:style>
  <style:style style:name="Table2.C" style:family="table-column"><style:table-column-properties style:column-width="5.666cm" style:rel-column-width="21845*"/></style:style>
  <style:style style:name="Table2.D" style:family="table-column"><style:table-column-properties style:column-width="4.349cm" style:rel-column-width="16383*"/></style:style>
  <style:style style:name="Table2.E" style:family="table-column"><style:table-column-properties style:column-width="3.999cm" style:rel-column-width="13107*"/></style:style>
  <style:style style:name="Table2.F" style:family="table-column"><style:table-column-properties style:column-width="2.833cm" style:rel-column-width="10922*"/></style:style>
  <style:style style:name="Table2.G" style:family="table-column"><style:table-column-properties style:column-width="2.428cm" style:rel-column-width="9362*"/></style:style>
  <style:style style:name="Table2.H" style:family="table-column"><style:table-column-properties style:column-width="2.124cm" style:rel-column-width="8191*"/></style:style>
  <style:style style:name="Table2.I" style:family="table-column"><style:table-column-properties style:column-width="1.8887cm" style:rel-column-width="7281*"/></style:style>
  <style:style style:name="Table2.J" style:family="table-column"><style:table-column-properties style:column-width="1.6999cm" style:rel-column-width="6553*"/></style:style>
  <style:style style:name="Table2.K" style:family="table-column"><style:table-column-properties style:column-width="1.5453cm" style:rel-column-width="5957*"/></style:style>
  <style:style style:name="Table2.L" style:family="table-column"><style:table-column-properties style:column-width="1.416cm" style:rel-column-width="5461*"/></style:style>
  <style:style style:name="Table2.M" style:family="table-column"><style:table-column-properties style:column-width="1.307" style:rel-column-width="5041*"/></style:style>
  <style:style style:name="Table2.N" style:family="table-column"><style:table-column-properties style:column-width="1.214cm" style:rel-column-width="4681*"/></style:style>
WOK
          x.strip!
          x.gsub!(/\n+/m,'') unless @md.opt.cmd=~/M/
          x
        else ''
        end
        breakpage=if @md.pagenew \
        or @md.pagebreak
          ' fo:break-before="page"'
        else ''
        end
        x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<office:document-content xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0" xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:ooow="http://openoffice.org/2004/writer" xmlns:oooc="http://openoffice.org/2004/calc" xmlns:dom="http://www.w3.org/2001/xml-events" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" office:version="1.0"><office:scripts/>
<office:font-face-decls><style:font-face style:name="DejaVu Sans Mono" svg:font-family="'DejaVu Sans Mono'" style:font-adornments="Book" style:font-family-generic="modern" style:font-pitch="fixed"/><style:font-face style:name="Inconsolata" svg:font-family="Inconsolata" style:font-adornments="Regular" style:font-pitch="fixed"/><style:font-face style:name="Liberation Mono" svg:font-family="'Liberation Mono'" style:font-adornments="Regular" style:font-family-generic="modern" style:font-pitch="fixed"/><style:font-face style:name="DejaVu Sans" svg:font-family="'DejaVu Sans'" style:font-adornments="ExtraLight" style:font-family-generic="swiss" style:font-pitch="variable"/><style:font-face style:name="Nimbus Sans L" svg:font-family="&apos;Nimbus Sans L&apos;" style:font-pitch="variable"/><style:font-face style:name="Tahoma" svg:font-family="Tahoma, Lucidasans, &apos;Lucida Sans&apos;, &apos;Arial Unicode MS&apos;" style:font-pitch="variable"/><style:font-face style:name="DejaVu Serif" svg:font-family="'DejaVu Sans'" style:font-adornments="ExtraLight" style:font-family-generic="swiss" style:font-pitch="variable"/><style:font-face style:name="Nimbus Roman No9 L" svg:font-family="&apos;Nimbus Roman No9 L&apos;" style:font-family-generic="roman" style:font-pitch="variable"/><style:font-face style:name="Bitstream Vera Sans" svg:font-family="&apos;Bitstream Vera Sans&apos;" style:font-family-generic="swiss" style:font-pitch="variable"/></office:font-face-decls>
<office:automatic-styles>
#{table}
  <style:style style:name="P1" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:text-align="justify" style:justify-single-word="false"/></style:style>
  <style:style style:name="P2" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:text-align="justify" style:justify-single-word="false"/></style:style>
  <style:style style:name="P3" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:text-align="justify" style:justify-single-word="false"/></style:style>
  <style:style style:name="P4" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:margin-top="0cm" fo:margin-bottom="0cm" fo:line-height="100%" fo:text-align="justify" style:justify-single-word="false"/></style:style>
  <style:style style:name="P5" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:margin-top="0cm" fo:margin-bottom="0cm" fo:line-height="100%" fo:text-align="start" style:justify-single-word="false"/></style:style>
  <style:style style:name="P6" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:break-before="page"/></style:style>
  <style:style style:name="P7" style:family="paragraph" style:parent-style-name="Table_20_Contents"><style:paragraph-properties fo:text-align="justify" style:justify-single-word="false"/></style:style>
  <style:style style:name="P8" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:break-before="page"/></style:style>
  <style:style style:name="P9" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:break-after="page"/></style:style>
  <style:style style:name="P10" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:text-align="justify" style:justify-single-word="false"/></style:style>
  <style:style style:name="P11" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="1cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P12" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="2cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P13" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="3cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P14" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="4cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P15" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="5cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P16" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="6cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P17" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="7cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P18" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="8cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P19" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="8cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
  <style:style style:name="P20" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:margin-top="0cm" fo:margin-bottom="0cm" fo:line-height="100%" fo:text-align="start" style:justify-single-word="false"/><style:text-properties style:font-name="DejaVu Sans Mono" fo:font-size="9pt" fo:font-weight="normal" fo:background-color="#e6e6e6"/></style:style>
  <style:style style:name="T1" style:family="text"><style:text-properties fo:font-weight="bold" style:font-weight-asian="bold" style:font-weight-complex="bold"/></style:style>
  <style:style style:name="T2" style:family="text"><style:text-properties fo:font-style="italic" style:font-style-asian="italic" style:font-style-complex="italic"/></style:style>
  <style:style style:name="T3" style:family="text"><style:text-properties style:text-underline-style="solid" style:text-underline-width="auto" style:text-underline-color="font-color"/></style:style>
  <style:style style:name="T4" style:family="text"><style:text-properties style:text-position="super 58%"/></style:style>
  <style:style style:name="T5" style:family="text"><style:text-properties style:text-position="sub 58%"/></style:style>
  <style:style style:name="T6" style:family="text"><style:text-properties style:font-name="Courier 10 Pitch" fo:font-size="12pt"/></style:style>
  <style:style style:name="T7" style:family="text"><style:text-properties style:font-name="DejaVu Sans Mono" fo:font-size="10pt" fo:font-weight="normal" fo:background-color="#e6e6e6"/></style:style>
  <style:style style:name="fr1" style:family="graphic" style:parent-style-name="Graphics"><style:graphic-properties style:wrap="none" style:horizontal-pos="left" style:horizontal-rel="paragraph" style:mirror="none" fo:clip="rect(0cm 0cm 0cm 0cm)" draw:luminance="0%" draw:contrast="0%" draw:red="0%" draw:green="0%" draw:blue="0%" draw:gamma="100%" draw:color-inversion="false" draw:image-opacity="100%" draw:color-mode="standard"/></style:style>
  <style:style style:name="gr1" style:family="graphic"><style:graphic-properties draw:stroke="none" draw:fill="none" draw:textarea-horizontal-align="center" draw:textarea-vertical-align="middle" draw:color-mode="standard" draw:luminance="0%" draw:contrast="0%" draw:gamma="100%" draw:red="0%" draw:green="0%" draw:blue="0%" fo:clip="rect(0cm 0cm 0cm 0cm)" draw:image-opacity="100%" style:mirror="none" style:run-through="background" style:wrap="none" style:vertical-pos="top" style:vertical-rel="baseline" style:horizontal-pos="left" style:horizontal-rel="paragraph" draw:wrap-influence-on-position="once-concurrent" style:flow-with-text="false"/></style:style>
  <style:style style:name="gr2" style:family="graphic"><style:graphic-properties draw:stroke="none" draw:fill="none" draw:textarea-horizontal-align="center" draw:textarea-vertical-align="middle" draw:color-mode="standard" draw:luminance="0%" draw:contrast="0%" draw:gamma="100%" draw:red="0%" draw:green="0%" draw:blue="0%" fo:clip="rect(0cm 0cm 0cm 0cm)" draw:image-opacity="100%" style:mirror="none" style:run-through="background" style:wrap="none" style:vertical-pos="middle" style:vertical-rel="baseline" style:horizontal-pos="left" style:horizontal-rel="paragraph" draw:wrap-influence-on-position="once-concurrent" style:flow-with-text="false"/></style:style>
</office:automatic-styles>
<office:body>
  <office:text><office:forms form:automatic-focus="false" form:apply-design-mode="false"/>
    <text:sequence-decls><text:sequence-decl text:display-outline-level="0" text:name="Illustration"/><text:sequence-decl text:display-outline-level="0" text:name="Table"/><text:sequence-decl text:display-outline-level="0" text:name="Text"/><text:sequence-decl text:display-outline-level="0" text:name="Drawing"/></text:sequence-decls>
WOK
        x.strip!
        x.gsub!(/\n+/m,'') unless @md.opt.cmd=~/M/
        @@odf[:head] << x
      end
      def post
      end
      def publish
        divider='='
        content=[]
        data=@data
        content << @@odf[:open]
        content << @@odf[:head]
        content << @@odf[:body]
        content << @@odf[:metadata]
        content << @@odf[:tail]
        Output.new(content,@md,@env).odf
        @@odf[:head],@@odf[:body],@@odf[:tail],@@odf[:metadata]=[],[],[],[]
      end
    end
    class Output <Source
      def initialize(content,md,env)
        @content,@md,@env=content,md,env
      end
      def odf                                                           #%odf output
        SiSU_Env::SiSU_file.new(@md).mkdir
        header=SiSU_ODF_format::ODT_head.new(@md)
        filename="#{@env.path.odf}/META-INF/manifest.xml"
        od=File.new(filename,'w+')
        od << header.meta_inf_manifest_xml
        od.close
        filename="#{@env.path.odf}/meta.xml"
        od=File.new(filename,'w+')
        od << header.meta_xml
        od.close
        filename="#{@env.path.odf}/settings.xml"
        od=File.new(filename,'w+')
        od << header.settings_xml
        od.close
        filename="#{@env.path.odf}/styles.xml"
        od=File.new(filename,'w+')
        od << header.styles_xml
        od.close
        filename="#{@env.path.odf}/mimetype"
        od=File.new(filename,'w+')
        od << header.mimetype
        od.close
        filename="#{@env.path.odf}/content.xml"
        od=File.new(filename,'w+')
        @content.each do |para|                                                # this is a hack
          od.puts para unless para =~/\A\s*\Z/
        end
        od.close
        opendoc=@md.fn[:odf]
        system("
          cd #{@env.path.odf}
          zip -qr #{opendoc} *
          mv #{opendoc} #{@env.path.output}/#{@md.fnb}/.
          cd #{Dir.pwd}
        ")
      end
    end
  end
end
__END__
todo:
* table of contents
* page header/footer?

done:
headings                              *
footnotes                             *
bold underscore italics strikethrough *
superscript subscript                 *
extended ascii set                    *
indents                               *
  [autonomy_markup0.sst]              *
groups
  poem                                *
  code                                *
  tables
images
bullet
line break
page break

notes?? [you could add a note number for every object/paragraph!]

        cd(@env.path.odf)
        structure=[]
        Find.find(@env.path.odf) do |f|
          structure << puts f
        end
        open(opendoc,'wb') do |f|
          zip=Zlib::ZipWriter.new(f)
          structure.each |z| do
            zip << z
          end
          zip.close
        end
        #zip -qr #{opendoc} *
        mv(opendoc,"#{@env.path.output}/#{@md.fnb}/.")
        cd(Dir.pwd)
●
<text:span text:style-name="T6">●</text:span>     #bullet
dob.obj.gsub!(/^(#{Mx[:pa_o]}:i[1-9]#{Mx[:pa_c]})\s*#{Mx[:gl_bullet]}/,'\1 <text:span text:style-name="T6">·</text:span> ') #bullet
dob.obj.gsub!(/^#{Mx[:gl_bullet]}/,'<text:span text:style-name="T6">·</text:span> ') #bullet
