# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: opendocument formatting, default opendocument template

=end
module SiSU_ODF_format
  require "#{SiSU_lib}/param"                              # param.rb
    include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(paranum)
      @paranum=/(\d+)/m.match(paranum)[1]
    end
    def display
      @paranum.gsub(/(\d+)/,'<font size="1" color="#777777">&nbsp;&nbsp;\1</font>')
    end
    def name
      @paranum.gsub(/(\d+)/,'<a name="\1"></a>')
    end
    def goto
      @paranum.gsub(/(\d+)/,'<a href="#\1">')
    end
  end
  class Format_text_object
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class==Hash
        @txt =t_o[:txt]            || nil
      else
        p t_o.class
        p caller
      end
      rgx=/#{Mx[:en_a_o]}\d+\s+(.+?)#{Mx[:en_a_c]}/
      @txt.gsub!(rgx,'\1') if @txt =~rgx
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def scr_endnote_body
      "<endnote>#{@txt}</endnote> "
    end
    def heading_body1
    end
    def heading_body2
    end
    def heading_body3
    end
    def heading_body4
    end
    def heading_body5
    end
    def heading_body6
    end
  end
  class Table
    @@tablehead,@@table_counter=0,0 #reinitialise on new file
    @@tablefoot=[] #watch
    @@fns=''
    def initialize(md,dob)
      @md,@dob,@txt,@vz=md,dob,dob.obj,SiSU_Env::Get_init.instance.skin
      if @md.fns != @@fns
        @@table_counter=0
        @@fns=@md.fns
      end
    end
    def table_head_open(count)
      type=if @dob.head_; 1
      else       2
      end
      alpha=case @dob.cols
      when  1; 'A'
      when  2; 'B'
      when  3; 'C'
      when  4; 'D'
      when  5; 'E'
      when  6; 'F'
      when  7; 'G'
      when  8; 'H'
      when  9; 'I'
      when 10; 'J'
      when 11; 'K'
      when 12; 'L'
      when 13; 'M'
      when 14; 'N'
      else     'D'
      end
      %{<table:table table:name="Table#{count}" table:style-name="Table#{type}">#{@br}} +
      %{<table:table-column table:style-name="Table#{type}.#{alpha}" table:number-columns-repeated="#{@dob.cols}"/>#{@br}}
    end
    def table_close(tablefoot='')
      '</table:table>'
    end
    def table_tag_cell(str,i)
      txt_name_cell=if i==0 \
      and @dob.head_
        'Table_20_Heading'
      else 'P7'
      end
      str.gsub!(/^~$/,'') # tilde / empty cell
      %{<table:table-cell office:value-type="string">#{@br}} +
      %{<text:p text:style-name="#{txt_name_cell}">#{@br}} +
      %{#{str}} +
      %{</text:p>#{@br}} +
      %{</table:table-cell>#{@br}}
    end
    def table_tag_row(str,i)
      %{<table:table-row>#{@br}} +
      %{#{str}} +
      %{</table:table-row>#{@br}}
    end
    def table_tag_row_dump(str,i)
      txt_name_row=if i==0 \
      and @dob.head_
        'Table_20_Heading'
      else 'P7'
      end
      %{<table:table-row>#{@br}} +
      %{<table:table-cell office:value-type="string">#{@br}} +
      %{<text:p text:style-name="#{txt_name_row}">#{@br}}
      %{#{str}} +
      %{</text:p>#{@br}} +
      %{</table:table-cell>#{@br}} +
      %{</table:table-row>#{@br}}
    end
    def table_row(row,i)
      row='' if row =~/^<!$/
      m=row[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      row.gsub!(/<!f.+?!>/,'')
      @cells=[]
      row.split(/\s*#{Mx[:tc_p]}/).each do |cell|
        @cells << table_tag_cell(cell,i)
      end
      row=@cells.join
      row=table_tag_row(row,i)
      row
    end
    def table
      @@table_counter+=1
      table_head_open(@@table_counter)
      @table=[]
      @dob.obj.split(/\s*#{Mx[:tc_c]}/).each_with_index do |r,i|
        @table << table_row(r,i)
      end
      @dob.obj= table_head_open(@@table_counter) + @table.join + table_close
      @dob
    end
  end
  class ODT_head
    def initialize(md)
      @md=md
      @generator="#{@md.sisu_version[:project]} #{@md.sisu_version[:version]} #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"
    end
    def meta_inf_manifest_xml
      x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE manifest:manifest PUBLIC "-//OpenOffice.org//DTD Manifest 1.0//EN" "Manifest.dtd">
<manifest:manifest xmlns:manifest="urn:oasis:names:tc:opendocument:xmlns:manifest:1.0">
  <manifest:file-entry manifest:media-type="application/vnd.oasis.opendocument.text" manifest:full-path="/"/>
  <manifest:file-entry manifest:media-type="application/vnd.sun.xml.ui.configuration" manifest:full-path="Configurations2/"/>
  <manifest:file-entry manifest:media-type="" manifest:full-path="Pictures/"/>
  <manifest:file-entry manifest:media-type="text/xml" manifest:full-path="content.xml"/>
  <manifest:file-entry manifest:media-type="text/xml" manifest:full-path="styles.xml"/>
  <manifest:file-entry manifest:media-type="text/xml" manifest:full-path="meta.xml"/>
  <manifest:file-entry manifest:media-type="" manifest:full-path="Thumbnails/thumbnail.png"/>
  <manifest:file-entry manifest:media-type="" manifest:full-path="Thumbnails/"/>
  <manifest:file-entry manifest:media-type="text/xml" manifest:full-path="settings.xml"/>
</manifest:manifest>
WOK
      x.strip!
      x.gsub!(/\n+/m,'') unless @md.opt.cmd=~/M/
      x
    end
    def meta_xml
      x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<office:document-meta xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:ooo="http://openoffice.org/2004/office" office:version="1.0">
  <office:meta>
    <meta:generator>#{@generator}</meta:generator>
    <meta:creation-date>#{@md.generated}</meta:creation-date>
    <dc:date>#{@md.generated}</dc:date>
    <dc:language>en-US</dc:language>
    <meta:editing-cycles>4</meta:editing-cycles>
  </office:meta>
</office:document-meta>
WOK
      x.strip!
      x.gsub!(/\n+/m,'') unless @md.opt.cmd=~/M/
      x
    end
    def settings_xml
      x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<office:document-settings xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:config="urn:oasis:names:tc:opendocument:xmlns:config:1.0" xmlns:ooo="http://openoffice.org/2004/office" office:version="1.0">
  <office:settings>
    <config:config-item-set config:name="ooo:view-settings">
      <config:config-item config:name="ViewAreaTop" config:type="int">0</config:config-item>
      <config:config-item config:name="ViewAreaLeft" config:type="int">0</config:config-item>
      <config:config-item config:name="ViewAreaWidth" config:type="int">21459</config:config-item>
      <config:config-item config:name="ViewAreaHeight" config:type="int">22068</config:config-item>
      <config:config-item config:name="ShowRedlineChanges" config:type="boolean">true</config:config-item>
      <config:config-item config:name="InBrowseMode" config:type="boolean">false</config:config-item>
      <config:config-item-map-indexed config:name="Views">
        <config:config-item-map-entry>
          <config:config-item config:name="ViewId" config:type="string">view2</config:config-item>
          <config:config-item config:name="ViewLeft" config:type="int">3002</config:config-item>
          <config:config-item config:name="ViewTop" config:type="int">11008</config:config-item>
          <config:config-item config:name="VisibleLeft" config:type="int">0</config:config-item>
          <config:config-item config:name="VisibleTop" config:type="int">0</config:config-item>
          <config:config-item config:name="VisibleRight" config:type="int">21458</config:config-item>
          <config:config-item config:name="VisibleBottom" config:type="int">22066</config:config-item>
          <config:config-item config:name="ZoomType" config:type="short">0</config:config-item>
          <config:config-item config:name="ZoomFactor" config:type="short">100</config:config-item>
          <config:config-item config:name="IsSelectedFrame" config:type="boolean">false</config:config-item>
        </config:config-item-map-entry>
      </config:config-item-map-indexed>
    </config:config-item-set>
    <config:config-item-set config:name="ooo:configuration-settings">
      <config:config-item config:name="AddParaTableSpacing" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintReversed" config:type="boolean">false</config:config-item>
      <config:config-item config:name="LinkUpdateMode" config:type="short">1</config:config-item>
      <config:config-item config:name="IgnoreFirstLineIndentInNumbering" config:type="boolean">false</config:config-item>
      <config:config-item config:name="CharacterCompressionType" config:type="short">0</config:config-item>
      <config:config-item config:name="PrintSingleJobs" config:type="boolean">false</config:config-item>
      <config:config-item config:name="UpdateFromTemplate" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintPaperFromSetup" config:type="boolean">false</config:config-item>
      <config:config-item config:name="AddFrameOffsets" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintLeftPages" config:type="boolean">true</config:config-item>
      <config:config-item config:name="RedlineProtectionKey" config:type="base64Binary"/>
      <config:config-item config:name="PrintTables" config:type="boolean">true</config:config-item>
      <config:config-item config:name="ChartAutoUpdate" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintControls" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrinterSetup" config:type="base64Binary"/>
      <config:config-item config:name="PrintAnnotationMode" config:type="short">0</config:config-item>
      <config:config-item config:name="LoadReadonly" config:type="boolean">false</config:config-item>
      <config:config-item config:name="AddParaSpacingToTableCells" config:type="boolean">true</config:config-item>
      <config:config-item config:name="AddExternalLeading" config:type="boolean">true</config:config-item>
      <config:config-item config:name="ApplyUserData" config:type="boolean">true</config:config-item>
      <config:config-item config:name="FieldAutoUpdate" config:type="boolean">true</config:config-item>
      <config:config-item config:name="SaveVersionOnClose" config:type="boolean">false</config:config-item>
      <config:config-item config:name="SaveGlobalDocumentLinks" config:type="boolean">false</config:config-item>
      <config:config-item config:name="IsKernAsianPunctuation" config:type="boolean">false</config:config-item>
      <config:config-item config:name="AlignTabStopPosition" config:type="boolean">true</config:config-item>
      <config:config-item config:name="CurrentDatabaseDataSource" config:type="string"/>
      <config:config-item config:name="PrinterName" config:type="string"/>
      <config:config-item config:name="PrintFaxName" config:type="string"/>
      <config:config-item config:name="ConsiderTextWrapOnObjPos" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintRightPages" config:type="boolean">true</config:config-item>
      <config:config-item config:name="IsLabelDocument" config:type="boolean">false</config:config-item>
      <config:config-item config:name="UseFormerLineSpacing" config:type="boolean">false</config:config-item>
      <config:config-item config:name="AddParaTableSpacingAtStart" config:type="boolean">true</config:config-item>
      <config:config-item config:name="UseFormerTextWrapping" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintProspect" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintGraphics" config:type="boolean">true</config:config-item>
      <config:config-item config:name="AllowPrintJobCancel" config:type="boolean">true</config:config-item>
      <config:config-item config:name="CurrentDatabaseCommandType" config:type="int">0</config:config-item>
      <config:config-item config:name="DoNotJustifyLinesWithManualBreak" config:type="boolean">false</config:config-item>
      <config:config-item config:name="UseFormerObjectPositioning" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrinterIndependentLayout" config:type="string">high-resolution</config:config-item>
      <config:config-item config:name="UseOldNumbering" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintPageBackground" config:type="boolean">true</config:config-item>
      <config:config-item config:name="CurrentDatabaseCommand" config:type="string"/>
      <config:config-item config:name="PrintDrawings" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintBlackFonts" config:type="boolean">false</config:config-item>
    </config:config-item-set>
  </office:settings>
</office:document-settings>
WOK
      x.strip!
      x.gsub!(/\n+/m,'') unless @md.opt.cmd=~/M/
      x
    end
    def styles_xml
      x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<office:document-styles xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0" xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:ooow="http://openoffice.org/2004/writer" xmlns:oooc="http://openoffice.org/2004/calc" xmlns:dom="http://www.w3.org/2001/xml-events" office:version="1.0">
  <office:font-face-decls>
    <style:font-face style:name="HG Mincho Light J" svg:font-family="'HG Mincho Light J', 'MS Mincho', 'HG Mincho J', 'HG Mincho L', 'HG Mincho', Mincho, 'MS PMincho', 'HG Mincho Light J', 'MS Gothic', 'HG Gothic J', 'HG Gothic B', 'HG Gothic', Gothic, 'MS PGothic', 'Andale Sans UI', 'Arial Unicode MS', 'Lucida Sans Unicode', Tahoma" style:font-pitch="variable"/>
    <style:font-face style:name="Nimbus Sans L" svg:font-family="'Nimbus Sans L'" style:font-pitch="variable"/>
    <style:font-face style:name="Tahoma" svg:font-family="Tahoma, Lucidasans, 'Lucida Sans', 'Arial Unicode MS'" style:font-pitch="variable"/>
    <style:font-face style:name="Nimbus Roman No9 L" svg:font-family="'Nimbus Roman No9 L'" style:font-family-generic="roman" style:font-pitch="variable"/>
    <style:font-face style:name="Bitstream Vera Sans" svg:font-family="'Bitstream Vera Sans'" style:font-family-generic="swiss" style:font-pitch="variable"/>
  </office:font-face-decls>
  <office:styles>
    <style:default-style style:family="graphic">
      <style:graphic-properties draw:shadow-offset-x="0.3cm" draw:shadow-offset-y="0.3cm" draw:start-line-spacing-horizontal="0.283cm" draw:start-line-spacing-vertical="0.283cm" draw:end-line-spacing-horizontal="0.283cm" draw:end-line-spacing-vertical="0.283cm" style:flow-with-text="false"/>
      <style:paragraph-properties style:text-autospace="ideograph-alpha" style:line-break="strict" style:writing-mode="lr-tb" style:font-independent-line-spacing="false">
        <style:tab-stops/>
      </style:paragraph-properties>
      <style:text-properties style:use-window-font-color="true" fo:font-size="12pt" fo:language="en" fo:country="US" style:font-size-asian="12pt" style:language-asian="none" style:country-asian="none" style:font-size-complex="12pt" style:language-complex="none" style:country-complex="none"/>
    </style:default-style>
    <style:default-style style:family="paragraph">
      <style:paragraph-properties fo:hyphenation-ladder-count="no-limit" style:text-autospace="ideograph-alpha" style:punctuation-wrap="hanging" style:line-break="strict" style:tab-stop-distance="1.251cm" style:writing-mode="page"/>
      <style:text-properties style:use-window-font-color="true" style:font-name="Nimbus Roman No9 L" fo:font-size="12pt" fo:language="en" fo:country="US" style:font-name-asian="Nimbus Sans L" style:font-size-asian="12pt" style:language-asian="none" style:country-asian="none" style:font-name-complex="Nimbus Sans L" style:font-size-complex="12pt" style:language-complex="none" style:country-complex="none" fo:hyphenate="false" fo:hyphenation-remain-char-count="2" fo:hyphenation-push-char-count="2"/>
    </style:default-style>
    <style:default-style style:family="table">
      <style:table-properties table:border-model="collapsing"/>
    </style:default-style>
    <style:default-style style:family="table-row">
      <style:table-row-properties fo:keep-together="auto"/>
    </style:default-style>
    <style:style style:name="Standard" style:family="paragraph" style:class="text"/>
    <style:style style:name="Text_20_body" style:display-name="Text body" style:family="paragraph" style:parent-style-name="Standard" style:class="text">
      <style:paragraph-properties fo:margin-top="0cm" fo:margin-bottom="0.212cm"/>
    </style:style>
    <style:style style:name="Heading" style:family="paragraph" style:parent-style-name="Standard" style:next-style-name="Text_20_body" style:class="text">
      <style:paragraph-properties fo:margin-top="0.423cm" fo:margin-bottom="0.212cm" fo:keep-with-next="always"/>
      <style:text-properties style:font-name="Bitstream Vera Sans" fo:font-size="14pt" style:font-name-asian="HG Mincho Light J" style:font-size-asian="14pt" style:font-name-complex="Tahoma" style:font-size-complex="14pt"/>
    </style:style>
    <style:style style:name="Heading_20_1" style:display-name="Heading 1" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:class="text" style:default-outline-level="1">
      <style:text-properties fo:font-size="120%" fo:font-weight="bold" style:font-size-asian="120%" style:font-weight-asian="bold" style:font-size-complex="115%" style:font-weight-complex="bold"/>
    </style:style>
    <style:style style:name="Heading_20_2" style:display-name="Heading 2" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:class="text" style:default-outline-level="2">
      <style:text-properties fo:font-size="115%" fo:font-weight="bold" style:font-size-asian="115%" style:font-weight-asian="bold" style:font-size-complex="115%" style:font-weight-complex="bold"/>
    </style:style>
    <style:style style:name="Heading_20_3" style:display-name="Heading 3" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:class="text" style:default-outline-level="3">
      <style:text-properties fo:font-size="110%" fo:font-weight="bold" style:font-size-asian="110%" style:font-weight-asian="bold" style:font-size-complex="115%" style:font-weight-complex="bold"/>
    </style:style>
    <style:style style:name="Heading_20_4" style:display-name="Heading 4" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:class="text" style:default-outline-level="4">
      <style:text-properties fo:font-size="100%" fo:font-style="italic" fo:font-weight="bold" style:font-size-asian="100%" style:font-style-asian="italic" style:font-weight-asian="bold" style:font-size-complex="100%" style:font-style-complex="italic" style:font-weight-complex="bold"/>
    </style:style>
    <style:style style:name="Heading_20_5" style:display-name="Heading 5" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:class="text" style:default-outline-level="5">
      <style:text-properties fo:font-size="90%" fo:font-style="italic" fo:font-weight="bold" style:font-size-asian="90%" style:font-style-asian="italic" style:font-weight-asian="bold" style:font-size-complex="90%" style:font-style-complex="italic" style:font-weight-complex="bold"/>
    </style:style>
    <style:style style:name="Heading_20_6" style:display-name="Heading 6" style:family="paragraph" style:parent-style-name="Heading" style:next-style-name="Text_20_body" style:class="text" style:default-outline-level="6">
      <style:text-properties fo:font-size="80%" fo:font-style="italic" fo:font-weight="bold" style:font-size-asian="80%" style:font-style-asian="italic" style:font-weight-asian="bold" style:font-size-complex="80%" style:font-style-complex="italic" style:font-weight-complex="bold"/>
    </style:style>
    <style:style style:name="Footnote" style:family="paragraph" style:parent-style-name="Standard" style:class="extra">
      <style:paragraph-properties fo:margin-left="0.499cm" fo:margin-right="0cm" fo:text-indent="-0.499cm" style:auto-text-indent="false" text:number-lines="false" text:line-number="0"/>
      <style:text-properties fo:font-size="10pt" style:font-size-asian="10pt" style:font-size-complex="10pt"/>
    </style:style>
    <style:style style:name="Footnote_20_Symbol" style:display-name="Footnote Symbol" style:family="text"/>
    <style:style style:name="Footnote_20_anchor" style:display-name="Footnote anchor" style:family="text">
      <style:text-properties style:text-position="super 58%"/>
    </style:style>
    <style:style style:name="Graphics" style:family="graphic">
      <style:graphic-properties text:anchor-type="paragraph" svg:x="0cm" svg:y="0cm" style:wrap="dynamic" style:number-wrapped-paragraphs="no-limit" style:wrap-contour="false" style:vertical-pos="top" style:vertical-rel="paragraph" style:horizontal-pos="center" style:horizontal-rel="paragraph"/>
    </style:style>
    <text:outline-style>
      <text:outline-level-style text:level="1" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="2" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="3" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="4" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="5" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="6" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="7" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="8" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="9" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
      <text:outline-level-style text:level="10" style:num-format="">
        <style:list-level-properties text:min-label-distance="0.381cm"/>
      </text:outline-level-style>
    </text:outline-style>
    <text:notes-configuration text:note-class="footnote" text:citation-style-name="Footnote_20_Symbol" text:citation-body-style-name="Footnote_20_anchor" style:num-format="1" text:start-value="0" text:footnotes-position="page" text:start-numbering-at="document"/>
    <text:notes-configuration text:note-class="endnote" style:num-format="i" text:start-value="0"/>
    <text:linenumbering-configuration text:number-lines="false" text:offset="0.499cm" style:num-format="1" text:number-position="left" text:increment="5"/>
  </office:styles>
  <office:automatic-styles>
    <style:page-layout style:name="pm1">
      <style:page-layout-properties fo:page-width="20.999cm" fo:page-height="29.699cm" style:num-format="1" style:print-orientation="portrait" fo:margin-top="2cm" fo:margin-bottom="2cm" fo:margin-left="2cm" fo:margin-right="2cm" style:writing-mode="lr-tb" style:footnote-max-height="0cm">
        <style:footnote-sep style:width="0.018cm" style:distance-before-sep="0.101cm" style:distance-after-sep="0.101cm" style:adjustment="left" style:rel-width="25%" style:color="#000000"/>
      </style:page-layout-properties>
      <style:header-style/>
      <style:footer-style/>
    </style:page-layout>
  </office:automatic-styles>
  <office:master-styles>
    <style:master-page style:name="Standard" style:page-layout-name="pm1"/>
  </office:master-styles>
</office:document-styles>
WOK
      x.strip!
      x.gsub!(/\n+/m,'') unless @md.opt.cmd=~/M/
      x
    end
    def mimetype
      x=<<WOK
application/vnd.oasis.opendocument.text
WOK
      x.strip!
    end
  end
  class Format_obj_break
    def initialize(md,t_o)
      @md,@t_o=md,t_o
    end
    def br_page
      @t_o.obj='<text:p text:style-name="P8"> </text:p>'
      @t_o
    end
    def obj_sep #center later
      sep='--- '
      @t_o.obj=%{<text:p text:style-name="P1">#{sep*20}</text:p>}
      @t_o
    end
  end
  class XML
  end
end
__END__
