# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/dal_doc_endnotes.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_DAL_Endnotes
  class Endnotes
    def initialize(md,data,endnote_array=nil)
      @md,@data,@endnote_array=md,data,endnote_array
      @endnote_counter,@endnote_counter_asterisk,@endnote_counter_dag=1,1,1
    end
    def endnotes
      data=@data
      @tuned_file=[]
      endnote_ref=1
      data.each do |dob|
                                                                               # manually numbered endnotes <!e(\d)!> <!e_(\d)!> -->
        if @md.opt.mod.inspect =~/--no-asterisk|--no-annotate/
          dob.obj=dob.obj.gsub(/#{Mx[:en_b_o]}\s.+?#{Mx[:en_b_c]}/,'')
        end
        if @md.opt.mod.inspect =~/--no-dagger|--no-annotate/
          dob.obj=dob.obj.gsub(/#{Mx[:en_b_o]}[+]\s.+?#{Mx[:en_b_c]}/,'')
        end
        if (defined? dob.obj) \
        && (defined? dob.is) \
        && dob.is !=:code
          case dob.obj                                                         # auto-numbered endnotes <!e!> <!e_!> -->
          when /#{Mx[:en_a_o]}.+?#{Mx[:en_a_c]}|#{Mx[:en_b_o]}[*+]\s+.+?#{Mx[:en_b_c]}/
            dob.obj=dob.obj.gsub(/\s*(#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/,' \1')          # required 2003w31
            word_mode=dob.obj.scan(/\S+/m)
            word_mode=endnote_call_number(word_mode)
            dob.obj=word_mode.join(' ')
            endnote_ref+=1
          when /~\^(?:\s|$)|<:e>/                                              #%note inserts endnotes previously gathered from /^(<!e[:_]!>|[-~]\{{3})/ (in earlier loop)
            word_mode=dob.obj.scan(/\S+/m)
            word_mode=endnote_call_number(word_mode)
            dob.obj=word_mode.join(' ')
            endnote_ref+=1
          end
        end
        @tuned_file << dob
      end
      @endnote_counter,@endnote_counter_asterisk,@endnote_counter_dag=1,1,1
      @tuned_file=@tuned_file.flatten
    end
    def endnote_call_number(words)
      words.each do |word|
        case word
        when /#{Mx[:en_a_o]}/
          unless word =~/#{Mx[:en_a_o]}[*+]+/
            word.gsub!(/#{Mx[:en_a_o]}/,"#{Mx[:en_a_o]}#{@endnote_counter} ")
            @endnote_counter+=1
          end
        when /#{Mx[:en_b_o]}/
          if word =~/#{Mx[:en_b_o]}[+]/
            word.gsub!(/#{Mx[:en_b_o]}[+]/,"#{Mx[:en_b_o]}\+#{@endnote_counter_dag} ")
            @endnote_counter_dag+=1
          else
            word.gsub!(/#{Mx[:en_b_o]}[*]?/,"#{Mx[:en_b_o]}\*#{@endnote_counter_asterisk} ")
            @endnote_counter_asterisk+=1
          end
        when /~\^|<:e>/
          if @endnote_array
            word.gsub!(/~\^|<:e>/,"#{@endnote_array[@endnote_counter-1]}")
            @endnote_counter+=1
          end
        end
      end
    end
  end
end
__END__
