# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/sst_identify_markup.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: A conversion script for canned substitutions, a fairly generic
    simple tool that can be used to store other canned conversions, used here for
    altering SiSU markup

=end
module SiSU_Markup
  class MarkupInform
    attr_accessor :version
    def initialize(version,message,declared_markup='',declared_type='')
      @version,@message,@declared_markup,@declared_type=version,message,declared_markup,declared_type
    end
    def version
      @version
    end
    def message
      @message
    end
    def declared_version
      @declared_markup
    end
    def declared_type
      @declared_type
    end
    def history
      MarkupHistory.new(@version).query
    end
  end
  class MarkupIdentify
    def initialize(opt)
      @opt=opt
      @description='This is a script attempts to identify the version of markup used in SiSU (and provides information on changes in markup)'
    end
    def help
    print <<WOK

#{@description}

WOK
      exit
    end
    def identify
      f=@opt.fns
      if f =~/(?:\.sst|\.ssm|\.ssi|\.s[123])$/ \
      and File.exist?(f)
        file=File.open(f,'r')
        cont=file.readlines
        file.close
        links,oldlinks='',''
        markup=nil
        @declared_type,@declared_markup='[text?]',''
        if cont[0] =~ /^(?:%\s+)?SiSU\s+(text|master|insert)\s+([0-9](?:\.[0-9]+){1,2})/ \
        or cont[0] =~ /^(?:%\s+)?sisu-([0-9](?:\.[0-9]+){1,2})/
          @declared_type,@declared_markup=$1,$2
        elsif cont[0] =~ /^(?:%\s+)?SiSU\s+([0-9](?:\.[0-9]+){1,2})/ \
        or cont[0] =~ /^(?:%\s+)?sisu-([0-9](?:\.[0-9]+){1,2})/
          @declared_markup=$1
        end
        @flag_2_0,@flag_1_0,@flag_69,@flag_66,@flag_57,@flag_38=false,false,false,false,false,false
        cont.each_with_index do |y,i|
          if y =~/^(?:0\{?~links?|@links?:)\s/ \
          and f =~/(?:\.sst|\.ssm|\.ssi|\.s[123])/
            links=unless y =~/\{.+?\}\S+/; oldlinks=' (pre 0.20.4 header links)'
            else ' (post 0.20.4 header links)'
            end
          end
          if @flag_2_0 \
          or y =~/^@make:|^@classify|^\s\s?:[a-z_-]+?:\s+\S/
            version=2.0.to_f
            markup=MarkupInform.new(version,'2.0' + oldlinks,@declared_markup,@declared_type)
            @flag_2_0=true
            break
          end
          unless @flag_38
            if (y =~/^:?A~/ and f =~/(?:\.sst|\.ssm|\.ssi)/)
              version='0.38'
              markup=MarkupInform.new(version,'0.38' + oldlinks,@declared_markup,@declared_type)
              @flag_38=true
            end
          end
          if @flag_38
            if @flag_1_0 \
            or y =~/^=\{.+?\}\s*$/
              version='0.69'
              markup=MarkupInform.new(version,'0.69' + oldlinks,@declared_markup,@declared_type)
              @flag_1_0=true
              break
            end
            if @flag_66 \
            or y =~/[a-z+][:;]\{.+?\}[:;][a-z+]/
              version='0.66'
              markup=MarkupInform.new(version,'0.66' + oldlinks,@declared_markup,@declared_type)
              @flag_66=true
              break
            end
          end
        end
        unless @flag_2_0 \
        or @flag_1_0 \
        or @flag_66
          cont.each_with_index do |y,i|
            if y =~/^(?:0\{?~links?|@links?:)\s/ \
            and f =~/(?:\.sst|\.ssm|\.ssi|\.s[123])/
              links=unless y =~/\{.+?\}\S+/; oldlinks=' (pre 0.20.4 header links)'
              else ' (post 0.20.4 header links)'
              end
            end
            if @flag_57 \
            or (y =~/^:?A~\?? @title/ and f =~/(?:\.sst|\.ssm|\.ssi)/)
              version='0.57'
              markup=MarkupInform.new(version,'0.57' + oldlinks,@declared_markup,@declared_type)
              @flag_57=true
              break
            end
            if @flag_38 \
            or (y =~/^:?A~/ and f =~/(?:\.sst|\.ssm|\.ssi)/)
              version='0.38'
              markup=MarkupInform.new(version,'0.38' + oldlinks,@declared_markup,@declared_type)
              @flag_38=true
              break if i >= 200
              if y =~ /(?:~{\*+|~\[\*|~\[\+)\s/
                version='0.42'
                markup=MarkupInform.new(version,'0.42' + oldlinks,@declared_markup,@declared_type)
                break
              end
            end
            if (y =~/^1~/ and f =~/(?:\.sst|\.ssm|\.ssi)/) \
            and not @flag_38
              version='0.37'
              markup=MarkupInform.new(version,'0.37 is substantially 0.16 - 0.36 markup with new file-extension' + oldlinks,@declared_markup,@declared_type)
              break
            end
            if y =~/^1~/ \
            and f =~/\.([rs])([123])/ \
            and not @flag_38
              t,n=$1,$2
              version='0.16'
              instruct=if t =~/r/
                " (change file extension from .#{t}#{n} to .ssm)"
              else " (change file extension from .#{t}#{n} to .sst)"
              end
              markup=MarkupInform.new(version,'0.16 - 0.36' + instruct + links,@declared_markup,@declared_type)
              break
            end
            if y =~/^0\{~/ \
            and not @flag_38
              version='0.1'
              markup=MarkupInform.new(version,'0.1 - 0.15',@declared_markup,@declared_type)
              break
            end
            if y =~/^0\{{3}/ \
            and not @flag_38
              markup=MarkupInform.new('circa. 1997','old, check date',@declared_markup,@declared_type)
              break
            end
            markup='Not a recognised file type '
          end
        end
        markup
      else MarkupHistory.new(@opt).help_query
      end
    end
    def determine_markup_version
      if @opt.fns.nil? \
      or @opt.fns.empty?
        MarkupHistory.new(@opt).help_identify
      end
      if File.exist?(@opt.fns)
        if @opt.fns =~/\.(?:sst|ssm|ssi|s[123i]|r[123])/
          markup=identify #(@opt.fns)
          if defined? markup.version
            unless @opt.cmd =~/q/
              message=unless markup.declared_version.empty?
                "#{@opt.fns}\n  markup Type Declared as SiSU #{markup.declared_version} #{markup.declared_type}\n  appears to be SiSU #{markup.version}"
              else
                "Markup Type Appears to be SiSU #{markup.version}\n  in file #{@opt.fns}"
              end
              puts message
              puts %{"sisu --query-#{markup.version}" for a brief description of markup type}
            end
          end
        else puts 'file-type not recognised: ' + @opt.fns
        end
      else puts 'file not found: ' + @opt.fns
      end
      (defined? markup.version) \
      ? markup.version
      : 'markup type/version not determined'
    end
    def markup_version?
      if @opt.fns.empty?
        @opt.files.each do |fns|
          @opt.fns=fns
          determine_markup_version
        end
      else determine_markup_version
      end
    end
  end
  class MarkupHistory
    def initialize(opt)
      @opt=opt
    end
    def sisu_3_0
      <<WOK
  SiSU 3.0 same as 2.0, apart from change to headers

    see document markup samples, and sisu --help headers

WOK
    end
    def sisu_2_0
      <<WOK
  SiSU 2.0 same as 1.0, apart from the changing of headers and the addition of a monospace tag
    related headers now grouped, e.g.

    @title:
     :subtitle:

    @creator:
     :author:
     :translator:
     :illustrator:

    see document markup samples, and sisu --help headers

    the monospace tag takes the form of a has '#' \#{ this enclosed text would be monospaced }#

WOK
    end
    def sisu_1_0
      <<WOK
  SiSU 1.0 same as 0.69

WOK
    end
    def sisu_0_69
      <<WOK
  SiSU 0.69 (same as 1.0) as previous (0.57) with the addition of book index tags
    /^=\{.+?\}$/
    e.g. appended to a paragraph, on a new-line (without a blank line in between)
    logical structure produced assuming this is the first text "object"
    ={GNU/Linux community distribution:Debian+2|Fedora|Gentoo;Free Software Foundation+5}

   Free Software Foundation, 1-6
   GNU/Linux community distribution, 1
       Debian, 1-3
       Fedora, 1
       Gentoo,

WOK
    end
    def sisu_0_66
      <<WOK
  SiSU 0.66 same as previous, adds semantic tags
    /[:;]\{.+?\}[:;][a-z+]/
    e.g. :{ Ralph last;{Amissah};last }:author

WOK
    end
    def sisu_0_65
      <<WOK
  SiSU 0.65 same as previous, adds semantic tags
    /[a-z+][:;]\{.+?\}[:;][a-z+]/
    e.g. author:{ Ralph last;{Amissah};last }:author

WOK
    end
    def sisu_0_57
      <<WOK

  SiSU 0.57 (a subset of 1.0) is the same as 0.42 with the introduction of some
  a shortcut to use the headers @title and @creator in the first heading
  [expanded using the contents of the headers @title: and @author:]

  :A~ @title by @author

WOK
    end
    def sisu_0_42
      <<WOK
  SiSU 0.42 (a subset of 1.0) is the same as 0.38 with the introduction of some additional endnote types,

  Introduces some varations on endnotes, in particular the use of the asterisk
  ~{* for example for describing an author }~ and ~{** for describing a second author }~

  * for example for describing an author

  ** for describing a second author

  and ~[* my note ]~ or ~[+ another note ]~ which numerically increments an
  asterisk and plus respectively

  *1 my note
  +1 another note

WOK
    end
    def sisu_0_38
      <<WOK

  SiSU 0.38 (a subset of 1.0) introduced alternative experimental header and heading/structure markers,

  @headername: and headers :A~ :B~ :C~ 1~ 2~ 3~

  as the equivalent of (the superceded)

  0~headername and headers 1~ 2~ 3~ 4~ 5~ 6~

  The internal document markup of SiSU 0.16 remains valid and standard
  Though note that SiSU 0.37 introduced a new file naming convention

  SiSU has in effect two sets of levels to be considered, using 0.38 notation
  A-C headings/levels, pre-ordinary paragraphs /pre-substantive text, and
  1-3 headings/levels, levels which are followed by ordinary text.
    This may be conceptualised as levels A,B,C, 1,2,3, and using such letter
    number notation, in effect:
      A must exist, optional B and C may follow in sequence (not strict)
      1 must exist, optional 2 and 3 may follow in sequence
    i.e. there are two independent heading level sequences A,B,C and 1,2,3
      (using the 0.16 standard notation 1,2,3 and 4,5,6)
    on the positive side:
      * the 0.38 A,B,C,1,2,3 alternative makes explicit an aspect of structuring
        documents in SiSU that is not otherwise obvious to the newcomer (though
        it appears more complicated, is more in your face and likely to be
        understood fairly quickly)
      * the substantive text follows levels 1,2,3 and it is 'nice' to do
        most work in those levels
WOK
    end
    def sisu_0_37
      <<WOK

  SiSU 0.37 introduced the file naming convention, that remains in use in SiSU
  v1 and v2, using the file extensions .sst .ssm and .ssi
  to replace .s1 .s2 .s3 .r1 .r2 .r3  and .si

  this is captured by the following file 'rename' instruction:

  rename 's/\.s[123]$/\.sst/' *.s{1,2,3}
  rename 's/\.r[123]$/\.ssm/' *.r{1,2,3}
  rename 's/\.si$/\.ssi/' *.si

  The internal document markup remains unchanged, from SiSU 0.16
WOK
    end
    def sisu_0_16
      <<WOK

  SiSU 0.16 (0.15 development branch) introduced the use of

  the header 0~ and headings/structure 1~ 2~ 3~ 4~ 5~ 6~

  in place of the 0.1 header, heading/structure notation
WOK
    end
    def sisu_0_1
      <<WOK

  SiSU 0.1 headers and headings structure represented by
  header 0{~ and headings/structure  1{ 2{ 3{ 4{~ 5{ 6{
WOK
    end
    def help_query
      <<WOK

  sisu --query=[sisu version [0.38] or 'history]
  provides a short history of changes to SiSU markup

WOK
    end
    def help_identify
      <<WOK

  sisu --identify [filename]
  attempts to identify the SiSU markup used in a file

WOK
    end
    def query
      tell=if @opt.mod.inspect =~/--query/
        tell=case @opt.mod.inspect
        when /history/
          "#{sisu_3_0}#{sisu_2_0}#{sisu_1_0}#{sisu_0_69}#{sisu_0_66}#{sisu_0_57}#{sisu_0_42}#{sisu_0_38}\n#{sisu_0_37}\n#{sisu_0_16}\n#{sisu_0_1}"
        when /3.0/
          "#{sisu_3_0}#{sisu_2_0}#{sisu_1_0}#{sisu_0_69}#{sisu_0_66}#{sisu_0_57}#{sisu_0_42}#{sisu_0_38}#{sisu_0_16}"
        when /2.0/
          "#{sisu_2_0}#{sisu_1_0}#{sisu_0_69}#{sisu_0_66}#{sisu_0_57}#{sisu_0_42}#{sisu_0_38}#{sisu_0_16}"
        when /1.0/
          "#{sisu_1_0}#{sisu_0_69}#{sisu_0_66}#{sisu_0_57}#{sisu_0_42}#{sisu_0_38}#{sisu_0_16}"
        when /0.69/
          "#{sisu_0_69}#{sisu_0_66}#{sisu_0_57}#{sisu_0_42}#{sisu_0_38}#{sisu_0_16}"
        when /0.66/
          "#{sisu_0_66}#{sisu_0_57}#{sisu_0_42}#{sisu_0_38}#{sisu_0_16}"
        when /0.65/
          "#{sisu_0_65}#{sisu_0_57}#{sisu_0_42}#{sisu_0_38}#{sisu_0_16}"
        when /0.57/
          "#{sisu_0_57}#{sisu_0_42}#{sisu_0_38}#{sisu_0_16}"
        when /0.42/
          "#{sisu_0_42}#{sisu_0_38}#{sisu_0_16}"
        when /0.38/
          "#{sisu_0_38}#{sisu_0_16}"
        when /0.37/
          "#{sisu_0_37}\n#{sisu_0_16}"
        when /0.1[6-9]|0.2[0-9]|0.3[0-6]/
          "#{sisu_0_16}\n#{sisu_0_1}"
        when /0.[1-9]|0.1[1-4]/
          sisu_0_1
        else puts "NOT RECOGNISED: #{@opt.mod.inspect}"
          help_query
        end
        tell
      else help_query
      end
    end
  end
end
__END__
#%% to use as independent program ------------------------->
f=$*
cf=f[0].to_s
f.shift
match_and_replace=[]
unless f.length > 0; f=Dir.glob("[a-z]*.ss?")  #restricted to sisu type files, it need not be
end
puts "SiSU files:"
puts f
f.each do |x|
  SiSU_Markup::MarkupIdentify.new(x).markup_version?
end
