# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/sysenv.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
@@cX=nil
module SiSU_Env
  require_relative 'constants'                         # constants.rb
  require_relative 'utils'                             # utils.rb
  require_relative 'se_date'                           # se_date.rb
  require_relative 'se_info_system'                    # se_info_system.rb
  require_relative 'se_load'                           # se_load.rb
  require_relative 'se_get_init'                       # se_get_init.rb
  require_relative 'se_envcall'                        # se_envcall.rb
  require_relative 'se_programs'                       # se_programs.rb
  require_relative 'se_standardise_lang'               # se_standardise_lang.rb
  require_relative 'se_info_env'                       # se_info_env.rb
  require_relative 'se_processing'                     # se_processing.rb
  require_relative 'se_filemap'                        # se_filemap.rb
  require_relative 'se_file_op'                        # se_file_op.rb
  require_relative 'se_cleanoutput'                    # se_cleanoutput.rb
  require_relative 'se_remotes'                        # se_remotes.rb
  require_relative 'se_version'                        # se_version.rb
  require_relative 'se_db'                             # se_db.rb
  require_relative 'se_css'                            # se_css.rb
  require_relative 'se_clear'                          # se_clear.rb
  require_relative 'se_createsite'                     # se_createsite.rb
  require_relative 'se_info_port'                      # se_info_port.rb
  begin
    require 'singleton'
    require 'fileutils'
      include FileUtils::Verbose
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('singleton or fileutils NOT FOUND (LoadError)')
  end
  @@noyaml=false
  class InfoDate < SiSU_Info_Date::InfoDate                # se_date.rb
  end
  class InfoSystemGen < SiSU_Info_Sys_Gen::InfoSystemGen   # se_info_system.rb
  end
  class InfoSystem < SiSU_Info_Sys::InfoSystem             # se_info_system.rb
  end
  class Load < SiSU_Load::Load                             # se_load.rb
  end
  class GetInit < SiSU_Get_Init::GetInit                   # se_get_init.rb
  end
  class EnvCall < SiSU_Env_Call::EnvCall                   # se_envcall.rb
  end
  class SystemCall < SiSU_Sys_Call::SystemCall             # se_programs.rb
  end
  class StandardiseLanguage < SiSU_Standardise_Lang::StandardiseLanguage # se_standardise_lang.rb
  end
  class InfoEnv < SiSU_Info_Env::InfoEnv                   # se_info_env.rb
  end
  class InfoProcessingFlag < SiSU_Info_Processing_Flag::InfoProcessingFlag # se_processing.rb
  end
  class InfoSettings < SiSU_Info_Set::InfoSettings         # se_programs.rb
  end
  class FileMap < SiSU_File_Map::FileMap                   # se_filemap.rb
  end
  class CleanOutput < SiSU_Clean_Output::CleanOutput       # se_cleanoutput.rb
  end
  class InfoRemoteHost < SiSU_Info_Remote_Host::InfoRemoteHost # se_remotes.rb
  end
  class InfoRemote < SiSU_Info_Remote::InfoRemote          # se_remotes.rb
  end
  class InfoVersion < SiSU_Info_Version::InfoVersion       # se_version.rb
  end
  class InfoAbout < SiSU_Info_About::InfoAbout             # se_version.rb
  end
  class InfoFile < SiSU_Info_File::InfoFile                # se_file_op.rb
  end
  class ProcessingSettings < SiSU_Processing_Settings::ProcessingSettings # se_processing.rb
  end
  class InfoDb < SiSU_Info_Db::InfoDb                      # se_db.rb
  end
  class DbOp < SiSU_Db_Op::DbOp                            # se_db.rb
  end
  class FileOp < SiSU_File_Op::FileOp                      # se_file_op.rb
  end
  class FilenameLanguageCodeInsert < SiSU_Filename_Lang::FilenameLanguageCodeInsert # se_file_op.rb
  end
  class CreateFile < SiSU_Create_File::CreateFile          # se_file_op.rb
  end
  class Clear < SiSU_Clear::Clear                          # se_clear.rb
  end
  class InfoPort < SiSU_Info_Port::InfoPort                # se_info_port.rb
  end
  class InfoProgram < SiSU_Info_Program::InfoProgram       # se_programs.rb
  end
  class CSS_Default < SiSU_CSS::CSS_Default                # se_css.rb
  end
  class CSS_Select < SiSU_CSS::CSS_Select                  # se_css.rb
  end
  class CSS_Stylesheet < SiSU_CSS::CSS_Stylesheet          # se_css.rb
  end
  class CreateSite < SiSU_Create_Site::CreateSite          # se_createsite.rb
  end
end
module SiSU_Screen
  require_relative 'screen_text_color'                  # screen_text_color.rb
end
module SiSU_Errors
  require_relative 'errors'                             # errors.rb
end
__END__
