#include "sjog.h"
#include "sjog_brightness.h"

/* Timer callback that hides the brightness dialog window.
 */
int
sjog_brightness_timer_callback(gpointer * data)
{

#ifdef DEBUG
   fprintf(stdout, "sjog_brightness_timer_callback\n");
#endif

   sjog_brightness_hide();

   /* return false so that the timer won't call us back again */
   return FALSE;
}


/* Brightness window closed callback, we hide the window instead of
 * destroying it.
 */
int
sjog_brightness_signal_delete_event_callback(GtkWidget * widget,
                                             GdkEvent * event,
                                             gpointer * data)
{

#ifdef DEBUG
   fprintf(stdout, "sjog_brightness_signal_delete_event_callback\n");
#endif

   sjog_brightness_hide();

   /* return true so that the window won't be destroyed */
   return TRUE;

}
