/* Public domain. */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#undef USE_DJBALLOC
#include "alloc.h"
#include "allreadwrite.h"
#include "djbunix.h"
#include "tai.h"
#include "caltimedate.h"

int leapsecs_readf_r (char const *s, struct tai **leapsecs)
{
  struct stat st ;
  struct tai *t ;
  int n ;
  int i = 0 ;

  int fd = open_readb(s) ;
  if (fd == -1)
  {
    if (errno != ENOENT) return -1 ;
    if (*leapsecs) alloc_free((char *)*leapsecs) ;
    *leapsecs = 0 ;
    return 0 ;
  }

  if (fstat(fd, &st) == -1) { fd_close(fd) ; return -1 ; }

  t = (struct tai *)alloc(st.st_size) ;
  if (!t) { fd_close(fd) ; return -1 ; }

  n = allread(fd, (char *)t, st.st_size) ;
  fd_close(fd) ;
  if (n < (int)st.st_size) { alloc_free((char *)t) ; return -1 ; }

  n /= sizeof(struct tai) ;

  for (; i < n ; i++)
  {
    struct tai u ;
    tai_unpack((char *)&t[i], &u) ;
    t[i] = u ;
  }

  if (*leapsecs) alloc_free((char *)*leapsecs) ;

  *leapsecs = t ;
  return n ;
}
