/* Public domain. */

#include "uint16.h"
#include "bytestr.h"
#include "stralloc.h"
#include "dns_helper.h"

int dns_mx_packet (stralloc *out, char const *buf, unsigned int len)
{
  char *q = 0 ;
  unsigned int pos ;
  char header[12] ;
  char pref[2] ;
  uint16 numanswers ;
  uint16 datalen ;

  out->len = 0 ;

  pos = dns_packet_copy(buf, len, 0, header, 12) ;
  if (!pos) return -1 ;
  uint16_unpack_big(header + 6, &numanswers) ;
  pos = dns_packet_skipname(buf, len, pos) ;
  if (!pos) return -1 ;
  pos += 4 ;

  while (numanswers--)
  {
    pos = dns_packet_skipname(buf, len, pos) ;
    if (!pos) goto err ;
    pos = dns_packet_copy(buf, len, pos, header, 10) ;
    if (!pos) goto err ;
    uint16_unpack_big(header + 8, &datalen) ;
    if (byte_equal(header, 2, DNS_T_MX))
      if (byte_equal(header + 2, 2, DNS_C_IN))
      {
	if (!dns_packet_copy(buf, len, pos, pref, 2)) goto err ;
	if (!dns_packet_getname(buf, len, pos + 2, &q)) goto err ;
	if (!stralloc_catb(out, pref, 2)) goto err ;
	if (!dns_domain_todot_cat(out, q)) goto err ;
	if (!stralloc_0(out)) goto err ;
      }
    pos += datalen ;
  }
  dns_domain_free(&q) ;
  return 0 ;

err:
  dns_domain_free(&q) ;
  return -1 ;
}
