/* Public domain. */

/* MT-unsafe */

#include <stdlib.h>
#include <errno.h>
#include "sysdeps.h"
#include "bytestr.h"

#ifndef USE_DJBALLOC
#define USE_DJBALLOC
#endif
#include "alloc.h"

#define ALIGNMENT 16
typedef union { unsigned char blah[ALIGNMENT] ; double d ; } aligned ;

#define SPACE 2048 /* must be multiple of ALIGNMENT */
static aligned realspace[SPACE / ALIGNMENT] ;
#define space ((unsigned char *) realspace)
static unsigned int avail = SPACE ; /* multiple of ALIGNMENT; 0<=avail<=SPACE */

void alloc_free (void *y)
{
  unsigned char *x = (unsigned char *)y ;
  if ((x >= space) && (x < space + SPACE))
    return ; /* XXX: assuming that pointers are flat (ndSka: they are) */
  free(y) ;
}

aligned_char_ref alloc (unsigned int n)
{
  n = ALIGNMENT + n - (n & (ALIGNMENT - 1)) ; /* XXX: could overflow */
  if (n <= avail)
  {
    avail -= n ;
    return space + avail ;
  }
  return malloc(n) ;
}

int alloc_re (unsigned char **x, unsigned int m, unsigned int n)
{
  aligned_char_ref y = alloc(n) ;
  if (!y) return 0 ;
  byte_copy(y, m, *x) ;
  alloc_free(*x) ;
  *x = y ;
  return 1 ;
}

int alloc_realloc (unsigned char **x, unsigned int n)
{
  if ((*x >= space) && (*x < space + SPACE)) return 0 ;
  else
  {
    aligned_char_ref y = realloc(*x, n) ;
    if (!y) return 0 ;
    *x = y ;
    return 1 ;
  }
}
