#!/bin/sh -e

#!/bin/sh -e

sysdeps="$1"
bits="$2"
dfmt="$3"
ofmt="$4"
xfmt="$5"
bfmt="$6"

tools/gen-types-internal.sh "" "" "$bits" < src/headers/bits-header

if test "$bits" = 64 && grep -qF 'uint64t: no' "$sysdeps" ; then
  if grep -qF 'sizeofulong: 8' "$sysdeps" ; then
    cat src/headers/uint64-ulong64
  else
    cat src/headers/uint64-noulong64
  fi
else
  tools/gen-types-internal.sh "" "" "$bits" < src/headers/bits-stdint
fi

if grep -qF 'endianness: little' < "$sysdeps" ; then
  endian=l
elif grep -qF 'endianness: big' < "$sysdeps" ; then
  endian=b
else
  echo 'Error ! Unsupported endianness' 1>&2
  ./crash
fi
tools/gen-types-internal.sh "" "" "$bits" < src/headers/bits-${endian}endian
tools/gen-bits-internal.sh "$bits" "$dfmt" "$ofmt" "$xfmt" "$bfmt"
exec tools/gen-types-internal.sh "" "" "$bits" < src/headers/bits-footer
