/* # skkinput (Simple Kana-Kanji Input)
 * skkkey.h 
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef SKKKEY_H
#define SKKKEY_H

#define KEYBUFSIZE	(10)

/*
 * ǽΰʬ긺äꤹ뤫⤷ޤ
 * ä skk Ƥޤ
 */
enum {
  FUNCNO_NOFUNCTION = -1,
  FUNCNO_SELF_INSERT_CHARACTER = 0,
  FUNCNO_J_SELF_INSERT,
  FUNCNO_J_SELF_ZENKAKU_INSERT, 
  FUNCNO_J_DISPLAY_CODE_FOR_CHAR_AT_POINT,
  FUNCNO_J_SET_HENKAN_POINT,
  FUNCNO_J_SET_HENKAN_POINT_SUBR,
  FUNCNO_J_INSERT_A,
  FUNCNO_J_INSERT_E,
  FUNCNO_J_INSERT_I,
  FUNCNO_J_INSERT_O,
  FUNCNO_J_INSERT_U,
  FUNCNO_J_KANA_INPUT,
  FUNCNO_J_START_HENKAN,
  FUNCNO_J_INSERT_COMMA,
  FUNCNO_J_INSERT_PERIOD,
  FUNCNO_J_PURGE_FROM_JISYO,
  FUNCNO_J_INPUT_BY_CODE_OR_MENU,
  FUNCNO_J_MODE_OFF,
  FUNCNO_J_TOGGLE_KANA,
  FUNCNO_J_PREVIOUS_CANDIDATE,
  FUNCNO_J_KAKUTEI,
  FUNCNO_J_ABBREV_INPUT,
  FUNCNO_J_ABBREV_PERIOD,
  FUNCNO_J_ABBREV_COMMA,
  FUNCNO_J_ZENKAKU_EIJI,
  FUNCNO_J_ZENKAKU_HENKAN,
  FUNCNO_J_TODAY,
  FUNCNO_SAVE_SKKINPUT_LOCAL_JISYO,
  FUNCNO_VC_TOGGLE_OVERTHESPOT_LIKE_INPUT,
  FUNCNO_J_MODE_OFF_AND_SELF_INSERT,

  FUNCNO_J_KANAINPUT_MODE_ON,
  FUNCNO_J_NEWLINE,
  FUNCNO_J_SET_MARK_COMMAND,
  FUNCNO_J_FORWARD_CHAR,
  FUNCNO_J_BACKWARD_CHAR,
  FUNCNO_J_DELETE_CHAR,
  FUNCNO_J_DELETE_BACKWARD_CHAR,
  FUNCNO_J_TRY_COMPLETION,
  FUNCNO_J_END_OF_LINE,
  FUNCNO_J_BEGINNING_OF_LINE,
  FUNCNO_J_KILL_LINE,
  FUNCNO_J_YANK,
  FUNCNO_J_KILL_REGION,
  FUNCNO_J_KILL_RING_SAVE,
  FUNCNO_J_EXCHANGE_POINT_AND_MARK,
  FUNCNO_J_PREVIOUS_LINE,
  FUNCNO_J_NEXT_LINE,
  FUNCNO_J_TRANSPOSE_CHARS,
  FUNCNO_J_REDRAW,
  FUNCNO_J_PREFIX_CHAR,
  FUNCNO_J_SENDBACK_NEXT_KEY,
  FUNCNO_J_SENDBACK_KEY,
  FUNCNO_J_KEYBOARD_QUIT,
  FUNCNO_CLOSE_SKKINPUT,
  FUNCNO_VC_TOGGLE_CHATMODE,
  FUNCNO_NOT_MODIFIED,
  FUNCNO_J_FORWARD_WORD,
  FUNCNO_J_BACKWARD_WORD,
  FUNCNO_J_UPCASE_WORD,
  FUNCNO_J_DOWNCASE_WORD,
  FUNCNO_J_CAPITALIZE_WORD,
  FUNCNO_VC_TOGGLE_EGGNL,
  FUNCNO_INVALID_CHAR,
} ;

/*
 * ASCII ʸ(<128)ɽǤʤüʸ
 */
enum {
  CHARA_CONTROL_SPACE = 128,
  CHARA_SHIFT_SPACE,
  CHARA_HOME = 130,	CHARA_CONTROL_HOME,
  CHARA_LEFT,		CHARA_CONTROL_LEFT,
  CHARA_UP,		CHARA_CONTROL_UP,
  CHARA_RIGHT,		CHARA_CONTROL_RIGHT,
  CHARA_DOWN,		CHARA_CONTROL_DOWN,
  CHARA_PAGE_UP,	CHARA_CONTROL_PAGE_UP,
  CHARA_PAGE_DOWN,	CHARA_CONTROL_PAGE_DOWN,
  CHARA_END,		CHARA_CONTROL_END,
  CHARA_BEGIN,		CHARA_CONTROL_BEGIN,
  CHARA_INSERT,		CHARA_CONTROL_INSERT,
  CHARA_CLEAR,		CHARA_CONTROL_CLEAR,
  CHARA_HELP,		CHARA_CONTROL_HELP,
  CHARA_BREAK,		CHARA_CONTROL_BREAK,
  CHARA_HENKAN_MODE,	CHARA_CONTROL_HENKAN_MODE,
  CHARA_MUHENKAN,	CHARA_CONTROL_MUHENKAN,
  CHARA_F1,		CHARA_CONTROL_F1,
  CHARA_F2,		CHARA_CONTROL_F2,
  CHARA_F3,		CHARA_CONTROL_F3,
  CHARA_F4,		CHARA_CONTROL_F4,
  CHARA_F5,		CHARA_CONTROL_F5,
  CHARA_F6,		CHARA_CONTROL_F6,
  CHARA_F7,		CHARA_CONTROL_F7,
  CHARA_F8,		CHARA_CONTROL_F8,
  CHARA_F9,		CHARA_CONTROL_F9,
  CHARA_F10,		CHARA_CONTROL_F10,
  CHARA_F11,		CHARA_CONTROL_F11,
  CHARA_F12,		CHARA_CONTROL_F12,
  NUMBER_OF_KEYS,
} ;

/*
 * skkinput ΥХѤι¤Ρ
 */
struct skkinputKeyBind {
  int length ;
  unsigned char string[ 3 ] ;
  int function_no ;
} ;

/*
 * ޥåס
 */
struct skkinputKeyTable {
  int function[ NUMBER_OF_KEYS ] ;
  struct skkinputKeyTable *next[ NUMBER_OF_KEYS ] ;
} ;

/*
 * Хåե
 */
struct keyBuffer {
  unsigned char *buffer ;
  unsigned char internal[ KEYBUFSIZE ] ;
  int usage ;
  int size ;
} ;

/*
 * Xim  Ximp ѴϥꤹΤѤ롣
 */
struct XrLikeKey {
  KeySym	keysym ;
  unsigned long	modifiers ;
  unsigned long checkModifiers ;
} ;

#endif
