/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is part of Skrooge and defines classes SKGNamedObject.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgnamedobject.h"

SKGNamedObject::SKGNamedObject(const SKGDocument* iDocument, const QString& iTable, int iID)
                : SKGObjectBase(iDocument, iTable, iID)
{
}

SKGNamedObject::SKGNamedObject(const SKGNamedObject& iObject)
                : SKGObjectBase(iObject)
{
}

SKGNamedObject::SKGNamedObject(const SKGObjectBase& iObject)
                : SKGObjectBase(iObject)
{
}

const SKGNamedObject& SKGNamedObject::operator= (const SKGObjectBase& iObject)
{
		copyFrom(iObject);
		return *this;
}

SKGNamedObject::~SKGNamedObject()
{
}

SKGError SKGNamedObject::setName(const QString& iName)
{
        return setAttribute("t_name", iName);
}

QString SKGNamedObject::getName() const
{
        return getAttribute("t_name");
}

QString SKGNamedObject::getWhereclauseId() const
{
        //Could we use the id
        QString output = SKGObjectBase::getWhereclauseId();
        if (output.isEmpty()) {
                //No, so we use the name
                QString name = SKGServices::stringToSqlString(getName());
                if (!name.isEmpty()) {
                        output = "t_name='"+name+'\'';
                }
        }
        return output;
}

SKGError SKGNamedObject::getObjectByName(const SKGDocument* iDocument, const QString& iTable, const QString& iName, SKGObjectBase& oObject)
{
        return getObject(iDocument, iTable, "t_name='"+SKGServices::stringToSqlString(iName)+'\'', oObject);
}

#include "skgnamedobject.moc"
