/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGPRINTPLUGINWIDGET_H
#define SKGPRINTPLUGINWIDGET_H
/** @file
 * A skrooge plugin to print pages
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgprintpluginwidget_base.h"
#include "skgtabwidget.h"

/**
 * A skrooge plugin to print pages
 */
class SKGPrintPluginWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGPrintPluginWidget(SKGMainPanel* iParent, SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGPrintPluginWidget();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

public slots:
        /**
        * Refresh the content.
         */
        virtual void refresh();

private slots:


private:
        Q_DISABLE_COPY(SKGPrintPluginWidget);

        Ui::skgprintplugin_base ui;
};

#endif // SKGPRINTPLUGINWIDGET_H
