/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGUNITPLUGINWIDGET_H
#define SKGUNITPLUGINWIDGET_H
/** @file
* This file is Skrooge plugin for unit management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgunitpluginwidget_base.h"
#include "skgtabwidget.h"
#include "skgunitobject.h"

class SKGDocumentBank;
class SKGObjectModel;

/**
 * This file is Skrooge plugin for unit management
 */
class SKGUnitPluginWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * This structure defines type of units
         */
        enum UnitDownloadMode {AUTO, 		/**< automatic mode (use setting)*/
                               LAST, 		/**< last value only*/
                               LAST_MONTHLY, 	/**< one value par month since last download*/
                               LAST_WEEKLY, 	/**< one value par week since last download*/
                               LAST_DAILY, 	/**< one value par day since last download*/
                               ALL_MONTHLY, 	/**< one value par month*/
                               ALL_WEEKLY, 	/**< one value par week*/
                               ALL_DAILY 	/**< one value par day*/
                              };

        /**
         * Default Constructor
         */
        SKGUnitPluginWidget(SKGMainPanel* iParent, SKGDocumentBank* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGUnitPluginWidget();

        /**
         * Get the current selection
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Download values for a unit
         * @param iUnit unit
         * @param iParent parent widget
         * @param iMode download mode
         * @return an object managing the error
         *   @see SKGError
         */
        static SKGError downloadUnitValue(const SKGUnitObject& iUnit, QWidget* iParent, UnitDownloadMode iMode=AUTO);

public slots:
        /**
         * Refresh the content.
         */
        virtual void refresh();

private slots:
        void onSelectionChanged();
        void onSelectionValueChanged();
        void onUnitCreatorModified();
        void onAddUnit();
        void onAddCurrency();
        void onModifyUnit();
        void onAddUnitValue();
        void onDownloadUnitValue();
        void onDoubleClickUnit();

private:
        Q_DISABLE_COPY(SKGUnitPluginWidget);

        Ui::skgunitplugin_base ui;;
        SKGObjectModel* objectModel;
};

#endif // SKGDEBUGPLUGIN_H
