/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include <QFile>

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        QDate now=QDate::currentDate();
        //============================================================================
        {
                //Test bank document
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGBankObject bank(&document1);
                SKGAccountObject account;
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "BANK_T1", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
                        SKGTESTERROR("ACCOUNT:setName",account.setName("Courant steph"), true);
                        SKGTESTERROR("ACCOUNT:setClosed",account.setClosed(true), true);
                        SKGTESTERROR("ACCOUNT:save",account.save(), true);

                        //Creation operation
                        SKGOperationObject op_1;
                        SKGTESTERROR("ACCOUNT:addOperation",account.addOperation(op_1), false);
                }
        }

        //============================================================================
        {
                //Test bank document
                SKGDocumentBank document1;
                SKGTESTERROR("document1.initialize()", document1.initialize(), true);
                SKGUnitValueObject unit_euro_val1;
                SKGBankObject bank(&document1);
                SKGUnitObject unit_euro(&document1);
                SKGAccountObject account;
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "BANK_T1", err);

                        //Creation bank
                        SKGTESTERROR("BANK:setName",bank.setName("CREDIT COOP"), true);
                        SKGTESTERROR("BANK:save", bank.save(), true);

                        //Creation account
                        SKGTESTERROR("BANK:addAccount",bank.addAccount(account), true);
                        SKGTESTERROR("ACCOUNT:setName",account.setName("Courant steph"), true);
                        SKGTESTERROR("ACCOUNT:setNumber",account.setNumber("12345P"), true);
                        SKGTESTERROR("ACCOUNT:save",account.save(), true);

                        //Creation unit
                        SKGTESTERROR("UNIT:setName",unit_euro.setName("euro"), true);
                        SKGTESTERROR("UNIT:save", unit_euro.save(), true);

                        //Creation unitvalue
                        SKGTESTERROR("UNIT:addUnitValue",unit_euro.addUnitValue(unit_euro_val1), true);
                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(1), true);
                        SKGTESTERROR("UNITVALUE:setDate",unit_euro_val1.setDate(now), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                        //Creation categories
                        SKGCategoryObject cat_1(&document1);
                        SKGTESTERROR("CAT:setName",cat_1.setName("transport"), true);
                        SKGTESTERROR("CAT:save", cat_1.save(), true);

                        SKGCategoryObject cat_2;
                        SKGTESTERROR("CAT:addCategory",cat_1.addCategory(cat_2), true);
                        SKGTESTERROR("CAT:setName",cat_2.setName("train"), true);
                        SKGTESTERROR("CAT:save", cat_2.save(), true);

                        //Creation operation
                        SKGOperationObject mainOperation;
                        for (int i=1; i<=10; ++i) {
                                SKGOperationObject op_1;
                                SKGTESTERROR("ACCOUNT:addOperation",account.addOperation(op_1), true);
                                SKGTESTERROR("OPE:setNumber",op_1.setNumber(1000+i), true);
                                SKGTESTERROR("OPE:setMode",op_1.setMode("cheque"), true);
                                SKGTESTERROR("OPE:setPayee",op_1.setPayee("SNCF"), true);
                                SKGTESTERROR("OPE:setComment",op_1.setComment("10 tickets"), true);
                                SKGTESTERROR("OPE:setDate",op_1.setDate(now), true);
                                SKGTESTERROR("OPE:setUnit",op_1.setUnit(unit_euro), true);
                                SKGUnitObject u;
                                SKGTESTERROR("OPE:setUnit",op_1.getUnit(u), true);
                                SKGTESTERROR("OPE:bookmark",op_1.bookmark(i%2==0), true);
                                SKGTESTERROR("OPE:save", op_1.save(), true);
                                if (i==1) {
                                        mainOperation=op_1;
                                        SKGTESTERROR("OPE:setGroupOperation", mainOperation.setGroupOperation(mainOperation), true);
                                        SKGTESTERROR("OPE:save", mainOperation.save(), true);
                                } else {
                                        if (!op_1.isBookmarked()) {
                                                SKGTESTERROR("OPE:setGroupOperation", op_1.setGroupOperation(mainOperation), true);
                                        }
                                        SKGTESTERROR("OPE:save", op_1.save(), true);
                                }

                                //Creation suboperation
                                for (int j=1; j<=5; ++j) {
                                        SKGSubOperationObject subop_1;
                                        SKGTESTERROR("OPE:addSubOperation",op_1.addSubOperation(subop_1), true);
                                        SKGTESTERROR("SUBOPE:setCategory",subop_1.setCategory(cat_2), true);
                                        SKGTESTERROR("SUBOPE:setComment",subop_1.setComment("subop"), true);
                                        SKGTEST("SUBOPE:getComment",subop_1.getComment(), "subop");
                                        SKGTESTERROR("SUBOPE:setQuantity",subop_1.setQuantity(i*j), true);
                                        SKGTESTERROR("SUBOPE:save", subop_1.save(), true);

                                        SKGTESTERROR("SUBOPE:load", subop_1.load(), true);
                                        SKGOperationObject opget;
                                        SKGTESTERROR("SUBOPE:getParentOperation", subop_1.getParentOperation(opget), true);
                                        SKGTEST("OPE:comparison", (opget==op_1), true);
                                }

                                //Checks
                                SKGTESTERROR("OPE:load", op_1.load(), true);
                                SKGTEST("OPE:getCurrentAmount", op_1.getCurrentAmount(), i*15);
                                SKGTEST("OPE:getNbSubOperations", op_1.getNbSubOperations(), 5);
                        }

                        SKGTESTERROR("ACCOUNT:load", account.load(), true);
                        SKGTEST("ACCOUNT:getCurrentAmount", account.getCurrentAmount(), 55*15);
                        SKGTEST("ACCOUNT:getAmount", account.getAmount(QDate::currentDate()), 55*15);

                        SKGUnitObject getUnit;
                        SKGTESTERROR("ACCOUNT:getUnit", account.getUnit(getUnit), true);
                        SKGTEST("ACCOUNT:unit", (getUnit==unit_euro), true);

                        SKGTESTERROR("OPE:load", mainOperation.load(), true);
                        SKGObjectBase::SKGListSKGObjectBase oGroupedOperations;
                        SKGTESTERROR("OPE:getGroupedOperations", mainOperation.getGroupedOperations(oGroupedOperations), true);
                        SKGTEST("OPE:oGroupedOperations", oGroupedOperations.size(), 2); //Normal
                        SKGTEST("OPE:isInGroup", mainOperation.isInGroup(), true); //Normal
                        SKGOperationObject mainOpe;
                        SKGTESTERROR("OPE:getGroupedOperations", mainOperation.getGroupOperation(mainOpe), true);
                        SKGTEST("OPE:isImported", mainOperation.isImported(), false);

                        SKGAccountObject acc;
                        SKGTESTERROR("OPE:getParentAccount", mainOperation.getParentAccount(acc), true);
                        SKGTEST("OPE:account==acc", (account==acc), true);
                        SKGTEST("OPE:getImportID", mainOperation.getImportID(), "");

                        SKGObjectBase::SKGListSKGObjectBase oSubOperations;
                        SKGTESTERROR("OPE:getSubOperations", mainOperation.getSubOperations(oSubOperations), true);
                        SKGTEST("OPE:oSubOperations", oSubOperations.size(), 5);

                        SKGTESTERROR("BANK:load", bank.load(), true);
                }//A commit is done here because the scope is close

                {
                        //Scope of the transaction
                        SKGBEGINTRANSACTION(document1, "BANK_T2", err);

                        SKGTESTERROR("UNITVALUE:setQuantity",unit_euro_val1.setQuantity(2.5), true);
                        SKGTESTERROR("UNITVALUE:save", unit_euro_val1.save(), true);

                        SKGTESTERROR("ACCOUNT:load", account.load(), true);
                        SKGTEST("ACCOUNT:getCurrentAmount", account.getCurrentAmount(), 55*15*2.5);

                        SKGTESTERROR("BANK:load", bank.load(), true);
                        SKGTEST("BANK:getCurrentAmount", bank.getCurrentAmount(), 55*15*2.5);
                }

                QFile("SKGTESTOperation.skg").remove();
                SKGTESTERROR("DOC:saveAs", document1.saveAs("SKGTESTOperation.skg"), true);

                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "BANK_T3", err);

                        //Test foreign key constrain
                        SKGTESTERROR("UNIT:remove", unit_euro.remove(), false);
                }
        }

        //============================================================================
        {
                //Test bank document
                SKGDocumentBank document1;
                SKGTESTERROR("document1.load", document1.load("SKGTESTOperation.skg"), true);

                SKGAccountObject account;
                SKGTESTERROR("SKGAccountObject::getObjectByName", SKGAccountObject::getObjectByName(&document1, "v_account", "Courant steph", account), true);

                SKGTEST("ACCOUNT:getCurrentAmount", account.getCurrentAmount(), 55*15*2.5);

                SKGBankObject bank;
                SKGTESTERROR("SKGBankObject::getObjectByName", SKGBankObject::getObjectByName(&document1, "v_bank", "CREDIT COOP", bank), true);

                SKGTEST("BANK:getCurrentAmount", bank.getCurrentAmount(), 55*15*2.5);

                SKGTESTERROR("BANK:undoRedoTransaction", document1.undoRedoTransaction(), true);

                SKGTESTERROR("ACCOUNT:load", account.load(), true);
                SKGTEST("ACCOUNT:getCurrentAmount", account.getCurrentAmount(), 55*15);
                SKGTESTERROR("BANK:load", bank.load(), true);
                SKGTEST("BANK:getCurrentAmount", bank.getCurrentAmount(), 55*15);

                //delete cascade
                SKGError err;
                {
                        //Scrope of the transaction
                        SKGBEGINTRANSACTION(document1, "BANK_T2", err);

                        SKGTESTERROR("BANK:delete", bank.remove(), true);
                }
                QStringList oResult;
                SKGTESTERROR("BANK:getDistinctValues", SKGServices::getDistinctValues(&document1, "bank", "id", oResult), true);
                SKGTEST("BANK:oResult.size", oResult.size(), 0);
                SKGTESTERROR("ACCOUNT:getDistinctValues", SKGServices::getDistinctValues(&document1, "account", "id", oResult), true);
                SKGTEST("ACCOUNT:oResult.size", oResult.size(), 0);
                SKGTESTERROR("OPE:getDistinctValues", SKGServices::getDistinctValues(&document1, "operation", "id", oResult), true);
                SKGTEST("OPE:oResult.size", oResult.size(), 0);
                SKGTESTERROR("SUBOPE:getDistinctValues", SKGServices::getDistinctValues(&document1, "suboperation", "id", oResult), true);
                SKGTEST("SUBOPE:oResult.size", oResult.size(), 0);

                SKGTESTERROR("BANK:undoRedoTransaction", document1.undoRedoTransaction(), true);
                SKGTESTERROR("BANK:undoRedoTransaction(SKGDocument::REDO)", document1.undoRedoTransaction(SKGDocument::REDO), true);


                QFile("SKGTESTOperation.skg").remove();
        }

        //End test
        SKGENDTEST();
}
