/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
        Q_UNUSED(argc);
        Q_UNUSED(argv);

        //Init test
        SKGINITTEST(true);

        //Test class SKGError
        {
                SKGError err;
		SKGTEST("ERR:Default RC", err.getReturnCode(), 0);
                SKGTEST("ERR:Default RC", err.getReturnCode(), 0);
                SKGTEST("ERR:isWarning", err.isWarning(), false);
                SKGTEST("ERR:isSucceeded", err.isSucceeded(), true);
                SKGTEST("ERR:isFailed", err.isFailed(), false);
                SKGTEST("ERR:getPreviousError", err.getPreviousError(), NULL);

                SKGTEST("ERR:Default message", err.getMessage(), "");
                err.setReturnCode(10);
                err.setMessage("Invalid parameter");
                SKGTEST("ERR:getHistoricalSize", err.getHistoricalSize(), 0);
                SKGTEST("ERR:RC 10", err.getReturnCode(), 10);
                SKGTEST("ERR:MSG Invalid parameter", err.getMessage(), "Invalid parameter");
                err.addError(11, "Message 11");
                SKGTEST("ERR:isWarning", err.isWarning(), false);
                SKGTEST("ERR:isSucceeded", err.isSucceeded(), false);
                SKGTEST("ERR:isFailed", err.isFailed(), true);

                SKGTEST("ERR:getHistoricalSize", err.getHistoricalSize(), 1);
                err.addError(-12, "Message 12");
                SKGTEST("ERR:isWarning", err.isWarning(), true);
                SKGTEST("ERR:isSucceeded", err.isSucceeded(), true);
                SKGTEST("ERR:isFailed", err.isFailed(), false);
                SKGTEST("ERR:getHistoricalSize", err.getHistoricalSize(), 2);
                SKGTEST("ERR:getFullMessageWithHistorical", err.getFullMessageWithHistorical(), "[WAR--12]: Message 12\n[ERR-11]: Message 11\n[ERR-10]: Invalid parameter");
        }

        //SKGServices
        {
                SKGTEST("CONV:intToString", SKGServices::intToString(10), "10");
                SKGTEST("CONV:intToString", SKGServices::intToString((int) 3.5), "3");
                SKGTEST("CONV:stringToInt", SKGServices::stringToInt("56"), 56);
                SKGTEST("CONV:stringToInt", SKGServices::stringToInt("HELLO"), 0);
                SKGTEST("CONV:stringToInt", SKGServices::stringToInt("5HELLO"), 0);
                SKGTEST("CONV:doubleToString", SKGServices::doubleToString(10), "10");
                SKGTEST("CONV:doubleToString", SKGServices::doubleToString(5.3), "5.3");
                SKGTEST("CONV:doubleToString", SKGServices::doubleToString(11111115.33), "11111115.33");
                SKGTEST("CONV:doubleToString", SKGServices::doubleToString(119999.11), "119999.11");
                SKGTEST("CONV:stringToDouble", SKGServices::stringToDouble("10")- 10, 0);
                SKGTEST("CONV:stringToDouble", SKGServices::stringToDouble("5.3")- 5.3, 0);
                SKGTEST("CONV:stringToDouble", SKGServices::stringToDouble("11111115.33")-11111115.33, 0);
                SKGTEST("CONV:stringToDouble", SKGServices::stringToDouble("25,000.00")-25000.00, 0);
                SKGTEST("CONV:stringToTime", SKGServices::timeToString(SKGServices::stringToTime("1970-07-16")), "1970-07-16 00:00:00");
                SKGTEST("CONV:stringToTime", SKGServices::timeToString(SKGServices::stringToTime("2008-04-20")), "2008-04-20 00:00:00");
                SKGTEST("CONV:stringToTime", SKGServices::dateToSqlString(SKGServices::stringToTime("1970-07-16")), "1970-07-16");
                SKGTEST("CONV:stringToTime", SKGServices::dateToSqlString(SKGServices::stringToTime("2008-04-20")), "2008-04-20");

                SKGTEST("CONV:SKGServices::getMicroTime", (SKGServices::getMicroTime() > 0), true);

                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("20080525","YYYYMMDD"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("2008-05-25","YYYY-MM-DD"), "2008-05-25");

                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("05/25/08","MM/DD/YY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("05/25/78","MM/DD/YY"), "1978-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("05-25-08","MM-DD-YY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("05-25-78","MM-DD-YY"), "1978-05-25");

                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("5/25/08","MM/DD/YY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("5/25/78","MM/DD/YY"), "1978-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("5-25-08","MM-DD-YY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("5-6-08","MM-DD-YY"), "2008-05-06");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("5-25-78","MM-DD-YY"), "1978-05-25");

                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("25/05/08","DD/MM/YY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("25/05/78","DD/MM/YY"), "1978-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("25-05-08","DD-MM-YY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("25-05-78","DD-MM-YY"), "1978-05-25");

                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("25/05/2008","DD/MM/YYYY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("25-05-2008","DD-MM-YYYY"), "2008-05-25");

                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("5/25/2008","MM/DD/YYYY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("5-25-2008","MM-DD-YYYY"), "2008-05-25");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("5-6-2008","MM-DD-YYYY"), "2008-05-06");

                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("3.21.01","MM-DD-YY"), "2001-03-21");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("1/ 1' 6","DD-MM-YY"), "2006-01-01");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("6/ 1/94","DD-MM-YY"), "1994-01-06");
                SKGTEST("STR:dateToSqlString", SKGServices::dateToSqlString("21/12'2001","DD-MM-YYYY"), "2001-12-21");


                {
                        QStringList dates;
                        dates << "19/08/2008";
                        SKGTEST("STR:getDateFormat", SKGServices::getDateFormat(dates), "DD-MM-YYYY");
                }
                {
                        QStringList dates;
                        dates << "20080819";
                        SKGTEST("STR:getDateFormat", SKGServices::getDateFormat(dates), "YYYYMMDD");
                }
                {
                        QStringList dates;
                        dates << "05/08/2008" << "19/08/2008";
                        SKGTEST("STR:getDateFormat", SKGServices::getDateFormat(dates), "DD-MM-YYYY");
                }
                {
                        QStringList dates;
                        dates << "19/ 1' 6";
                        SKGTEST("STR:getDateFormat", SKGServices::getDateFormat(dates), "DD-MM-YYYY");
                }
                {
                        QStringList dates;
                        dates << "21/12'2001";
                        SKGTEST("STR:getDateFormat", SKGServices::getDateFormat(dates), "DD-MM-YYYY");
                }
                {
                        QStringList dates;
                        dates << "6/ 1/94";
                        SKGTEST("STR:getDateFormat", SKGServices::getDateFormat(dates), "DD-MM-YY");
                }
                {
                        QStringList dates;
                        dates << "10.29.07";
                        SKGTEST("STR:getDateFormat", SKGServices::getDateFormat(dates), "MM-DD-YY");
                }
                {
                        QStringList dates;
                        dates << "10.05.07";
                        SKGTEST("STR:getDateFormat", SKGServices::getDateFormat(dates), "DD-MM-YY");
                }


                SKGTEST("STR:stringToCsv", SKGServices::stringToCsv("ABC"), "\"ABC\"");
                SKGTEST("STR:stringToCsv", SKGServices::stringToCsv("ABC;CDE"), "\"ABC;CDE\"");
                SKGTEST("STR:stringToCsv", SKGServices::stringToCsv("AB \"C\" DE"), "\"AB \"\"C\"\" DE\"");
                SKGTEST("STR:stringToCsv", SKGServices::stringToCsv("AB \"C\";DE"), "\"AB \"\"C\"\";DE\"");

                QStringList parameters=SKGServices::splitCSVLine(SKGServices::stringToCsv("Y")+';'+SKGServices::stringToCsv("A;B"));
                SKGTEST("STR:splitCSVLine count", parameters.count(), 2);
                SKGTEST("STR:splitCSVLine", parameters[0], "Y");
                SKGTEST("STR:splitCSVLine", parameters[1], "A;B");

                parameters=SKGServices::splitCSVLine("A;\"B;C\";D");
                SKGTEST("STR:splitCSVLine count", parameters.count(), 3);
                SKGTEST("STR:splitCSVLine", parameters[0], "A");
                SKGTEST("STR:splitCSVLine", parameters[1], "B;C");
                SKGTEST("STR:splitCSVLine", parameters[2], "D");

                parameters=SKGServices::splitCSVLine("30/05/2008;RETRAIT ESPECES AGENCE;                                ;      100,00;DEBIT;");
                SKGTEST("STR:splitCSVLine count", parameters.count(), 6);

                parameters=SKGServices::splitCSVLine("A|\"B\";\"C\"", '|', false);
                SKGTEST("STR:splitCSVLine count", parameters.count(), 2);
                SKGTEST("STR:splitCSVLine", parameters[0], "A");
                SKGTEST("STR:splitCSVLine", parameters[1], "\"B\";\"C\"");

                //Error
                SKGTESTERROR("SKGServices::executeSqliteOrder", SKGServices::executeSqliteOrder((const SKGDocument*) NULL, "", NULL), false);
	}

        //End test
        SKGENDTEST();
}
