/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGBANKPLUGIN_H
#define SKGBANKPLUGIN_H
/** @file
* This file is Skrooge plugin for bank management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skginterfaceplugin.h"
#include "ui_skgbankpluginwidget_pref.h"

#include <QObject>
#include <QVariantList>
#include <kgenericfactory.h>

class SKGMainPanel;

/**
 * This file is Skrooge plugin for bank management
 */
class SKGBankPlugin : public SKGInterfacePlugin
{
        Q_OBJECT
        Q_INTERFACES(SKGInterfacePlugin);

public:
        /**
         * Default Constructor
         */
        SKGBankPlugin(QObject* iParent, const QVariantList& iArg);

        /**
         * Default Destructor
         */
        virtual ~SKGBankPlugin();

        /**
         * Called to initialise the plugin
         * @param iParent the SKGMainPanel main panel parent
         * @param iDocument the SKGDocumentBank main document
         * @param iArgument the arguments
         */
        virtual void setupActions(SKGMainPanel* iParent, SKGDocument* iDocument, const QStringList& iArgument);

        /**
         * Must be modified to close properly the plugin.
         */
        virtual void close();

        /**
         * The dashboard widget of the plugin.
         * @return The dashboard widget of the plugin
         */
        virtual SKGWidget* getDashboardWidget();

        /**
         * The context widget of the plugin.
         * @return The context widget of the plugin
         */
        virtual SKGTabWidget* getWidget();

        /**
         * The preference widget of the plugin.
         * @return The preference widget of the plugin
         */
        virtual QWidget* getPreferenceWidget();

        /**
         * The preference skeleton of the plugin.
         * @return The preference skeleton of the plugin
         */
        virtual KConfigSkeleton* getPreferenceSkeleton();

        /**
         * The title of the plugin.
         * @return The title of the plugin
         */
        virtual QString title() const;

        /**
         * The icon of the plugin.
         * @return The icon of the plugin
         */
        virtual QString icon() const;

        /**
         * The statusTip of the plugin.
         * @return The toolTip of the plugin
         */
        virtual QString statusTip () const;

        /**
         * The toolTip of the plugin.
         * @return The toolTip of the plugin
         */
        virtual QString toolTip () const;

        /**
         * The tips list of the plugin.
         * @return The tips list of the plugin
         */
        virtual QStringList tips() const;

        /**
         * Must be implemented to set the position of the plugin.
         * @return integer value between 0 and 999 (default = 999)
         */
        virtual int getOrder() const;

        /**
         * Must be implemented to know if a plugin must be display in context chooser.
         * @return true of false (default = false)
         */
        virtual bool isInContext() const;

private:
        Q_DISABLE_COPY(SKGBankPlugin);
        SKGMainPanel *parent;
        SKGDocument* currentBankDocument;

        Ui::skgbankplugin_pref ui;
};

#endif // SKGDEBUGPLUGIN_H
