/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDASHBOARDPLUGINWIDGET_H
#define SKGDASHBOARDPLUGINWIDGET_H
/** @file
 * A dashboard for skrooge
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgdashboardpluginwidget_base.h"
#include "skgtabwidget.h"

#include <QGridLayout>


/**
 * A dashboard for skrooge
 */
class SKGDashboardPluginWidget : public SKGTabWidget
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGDashboardPluginWidget(SKGMainPanel* iParent, SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGDashboardPluginWidget();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

public slots:
        /**
        * Refresh the content.
         */
        virtual void refresh();

private slots:


private:
        Q_DISABLE_COPY(SKGDashboardPluginWidget);

        Ui::skgdashboardplugin_base ui;
        QGridLayout* gridLayout;
};

#endif // SKGDASHBOARDPLUGINWIDGET_H
