/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin to manage properties on objects.
 *
 * @author Stephane MANKOWSKI
 */
#include "skgpropertiesplugindockwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"
#include "skgnamedobject.h"
#include "skgobjectmodelbase.h"
#include "skgsortfilterproxymodel.h"
#include "skgtransactionmng.h"

SKGPropertiesPluginDockWidget::SKGPropertiesPluginDockWidget(SKGMainPanel* iParent, SKGDocument* iDocument)
                : SKGTabWidget(iParent, iDocument)
{
        SKGTRACEIN(1, "SKGPropertiesPluginDockWidget::SKGPropertiesPluginDockWidget");

        ui.setupUi(this);

        ui.kAdd->setIcon(KIcon("list-add"));
        ui.kRemove->setIcon(KIcon("list-remove"));

        //Add model
        SKGObjectModelBase* modelview = new SKGObjectModelBase(getDocument(), "parameters", "t_uuid_parent==t_uuid_parent ORDER BY t_uuid_parent, t_name", this);
        SKGSortFilterProxyModel* modelproxy = new SKGSortFilterProxyModel(this);
        modelproxy->setSourceModel(modelview);
        ui.kView->setModel(modelproxy);

        ui.kView->setWindowTitle(i18n("Properties"));
        ui.kView->setDefaultSaveParameters(getDocument(), "SKG_DEFAULT_PROPERTIES");

        connect(ui.kView->selectionModel(), SIGNAL(selectionChanged(QItemSelection,QItemSelection)), this, SLOT(onSelectionChanged()));

}

SKGPropertiesPluginDockWidget::~SKGPropertiesPluginDockWidget()
{
        SKGTRACEIN(1, "SKGPropertiesPluginDockWidget::~SKGPropertiesPluginDockWidget");
}

void SKGPropertiesPluginDockWidget::refresh()
{
        SKGTRACEIN(1, "SKGPropertiesPluginDockWidget::refresh");

        //Change filter
        SKGObjectModelBase* model=(SKGObjectModelBase*) ui.kView->model();
        QSortFilterProxyModel *proxyModel = qobject_cast<QSortFilterProxyModel *>(model);
        if (proxyModel) model=(SKGObjectModelBase*) proxyModel->sourceModel();

        if (model) {
                QString filter="t_uuid_parent IN (";

                SKGObjectBase::SKGListSKGObjectBase selection=getMainPanel()->getSelectedObjects();
                int nb=selection.count();
                if (nb) {
                        QString tableName;
                        for (int i=0; i<nb; ++i) {
                                if (i>0) filter+=',';
                                else tableName=selection.at(i).getRealTable();
                                filter+='\''+selection.at(i).getUniqueID()+'\'';
                        }

                        ui.kAdd->setEnabled(true);
                        ui.kRemove->setEnabled(false);
                        ui.kAttribute->setEnabled(true);
                        ui.kValue->setEnabled(true);

                        //Fill combo box
                        SKGMainPanel::fillComboWithDistinctValue(ui.kAttribute, getDocument(), "parameters", "t_name", "t_uuid_parent like '%-"+tableName+'\'');
                        SKGMainPanel::fillComboWithDistinctValue(ui.kValue, getDocument(), "parameters", "t_value", "t_uuid_parent like '%-"+tableName+'\'');

                } else {
                        filter+="'XXX'"; //Always false
                        ui.kAdd->setEnabled(false);
                        ui.kRemove->setEnabled(false);
                        ui.kAttribute->setEnabled(false);
                        ui.kValue->setEnabled(false);
                }
                filter+=") ORDER BY t_uuid_parent, t_name";

                ui.kView->saveSelection();

                model->setFilter(filter);
                model->refresh();

                ui.kView->resetSelection();
        }

        ui.kView->setState("");
        if (ui.kView->isAutoResized()) ui.kView->resizeColumnsToContents();
}

SKGObjectBase::SKGListSKGObjectBase SKGPropertiesPluginDockWidget::getSelectedObjects()
{
        return ui.kView->getSelectedObjects();
}

int SKGPropertiesPluginDockWidget::getNbSelectedObjects()
{
        return ui.kView->getNbSelectedObjects();
}

void SKGPropertiesPluginDockWidget::onSelectionChanged()
{
        SKGTRACEIN(10, "SKGPropertiesPluginDockWidget::onSelectionChanged");
        int nbSelected=getNbSelectedObjects();
        ui.kRemove->setEnabled(nbSelected>0);
        if (nbSelected>0) {
                SKGObjectBase::SKGListSKGObjectBase objs=getSelectedObjects();
                SKGObjectBase obj=objs.at(0);
                ui.kAttribute->setText(obj.getAttribute("t_name"));
                ui.kValue->setText(obj.getAttribute("t_value"));
        } else {
                ui.kAttribute->setText("");
                ui.kValue->setText("");
        }

        if (ui.kView->isAutoResized()) ui.kView->resizeColumnsToContents();
}

void SKGPropertiesPluginDockWidget::onFilterChanged()
{
        SKGTRACEIN(10, "SKGPropertiesPluginDockWidget::onFilterChanged");
        QRegExp regExp(ui.kFilterEdit->text(), Qt::CaseInsensitive);
        ((SKGSortFilterProxyModel*) ui.kView->model())->setFilterRegExp(regExp);
}

void SKGPropertiesPluginDockWidget::onAddProperty()
{
        SKGTRACEIN(10, "SKGPropertiesPluginDockWidget::onAddProperty");
        SKGError err;
        QStringList listUUID;
        //Scope for the transaction
        {
                QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));
                //Create properties
                SKGObjectBase::SKGListSKGObjectBase selection=getMainPanel()->getSelectedObjects();
                int nb=selection.count();
                SKGBEGINPROGRESSTRANSACTION(*getDocument(), i18n("Property creation"), err, nb);
                for (int i=0; err.isSucceeded() && i<nb; ++i) {
                        SKGNamedObject param(getDocument() , "parameters");
                        if (err.isSucceeded()) err = param.setName(ui.kAttribute->text());
                        if (err.isSucceeded()) err = param.setAttribute("t_value", ui.kValue->text());
                        if (err.isSucceeded()) err = param.setAttribute("t_uuid_parent", selection[i].getUniqueID());
                        if (err.isSucceeded()) err = param.save();

                        listUUID.push_back(param.getUniqueID());
                        if (err.isSucceeded()) err=getDocument()->stepForward(i+1);
                }
                QApplication::restoreOverrideCursor();
        }

        //status bar
        if (err.isSucceeded()) {
                err=SKGError(0, i18n("Property created"));
                ui.kView->selectObjects(listUUID, true);
        }
        getMainPanel()->displayErrorMessage(err);
}

void SKGPropertiesPluginDockWidget::onRemoveProperty()
{
        SKGError err;
        SKGTRACEINRC(10, "SKGPropertiesPluginDockWidget::onRemoveProperty",err);
        QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));
        SKGObjectBase::SKGListSKGObjectBase selection=getSelectedObjects();
        int nb=selection.count();
        SKGBEGINPROGRESSTRANSACTION(*getDocument(), i18n("Delete"), err, nb);
        for (int i=0; err.isSucceeded() && i<nb; ++i) {
                err=selection[i].remove();
                if (err.isSucceeded()) err=getDocument()->stepForward(i+1);
        }

        //status bar
        if (err.isSucceeded()) err=SKGError(0, i18n("Properties deleted."));
        else err.addError(ERR_FAIL, i18n("Delete failed"));
        QApplication::restoreOverrideCursor();

        //Display error
        getMainPanel()->displayErrorMessage(err);
}
#include "skgpropertiesplugindockwidget.moc"


