/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgscheduledboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgrecurrentoperationobject.h"

SKGScheduledBoardWidget::SKGScheduledBoardWidget (SKGDocument* iDocument )
                : SKGWidget (iDocument )
{
        SKGTRACEIN ( 10, "SKGScheduledBoardWidget::SKGScheduledBoardWidget" );

        ui.setupUi ( this );

        //Refresh
        connect ( ( const QObject* ) getDocument(), SIGNAL(tableModified(QString, int)), this, SLOT(dataModified(QString, int)), Qt::QueuedConnection );
        dataModified("", 0);
}

SKGScheduledBoardWidget::~SKGScheduledBoardWidget()
{
        SKGTRACEIN ( 10, "SKGScheduledBoardWidget::~SKGScheduledBoardWidget" );

}

void SKGScheduledBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
        SKGTRACEIN ( 10, "SKGScheduledBoardWidget::dataModified" );
        if (iTableName=="recurrentoperation" || iTableName.isEmpty()) {
                QString html;
                SKGObjectBase::SKGListSKGObjectBase objs;
                SKGError err=SKGObjectBase::getObjects(getDocument(), "v_recurrentoperation_display", "1=1 ORDER BY d_DUEDATE LIMIT 5", objs);
                if (err.isSucceeded()) {
                        html+="<html><body>";
                        int nb=objs.count();
                        for (int i=0; i<nb; ++i) {
                                SKGRecurrentOperationObject obj=objs.at(i);
                                html+=obj.getDisplayName()+"<br>";
                        }
                        html+="</body><html>";
                        ui.kLabel->setText(html);
                }
        }
}
#include "skgscheduledboardwidget.moc"
