/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for undoredo management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgundoredoplugindockwidget.h"
#include "skgtraces.h"
#include "skgobjectmodelbase.h"
#include "skgdocument.h"
#include "skgmainpanel.h"

#include <QHeaderView>
#include <QResizeEvent>

SKGUndoRedoPluginDockWidget::SKGUndoRedoPluginDockWidget(SKGDocument* iDocument)
                :SKGTabPage(iDocument)
{
        SKGTRACEIN(1, "SKGUndoRedoPluginDockWidget::SKGUndoRedoPluginDockWidget");

        ui.setupUi(this);

        SKGObjectModelBase* modelview = new SKGObjectModelBase(getDocument(), "doctransaction", "1=1 ORDER BY d_date DESC", this);
        ui.kTransactionList->setModel(modelview);
        ui.kTransactionList->header()->hide();

        ui.kTransactionList->setDefaultSaveParameters(getDocument(), "SKG_DEFAULT_UNDOREDO");

        connect(ui.kTransactionList, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(onUndoRedo(QModelIndex)));
        connect ( ( const QObject* ) getDocument(), SIGNAL(tableModified(QString, int)), this, SLOT(dataModified(QString, int)), Qt::QueuedConnection );
}

SKGUndoRedoPluginDockWidget::~SKGUndoRedoPluginDockWidget()
{
        SKGTRACEIN(1, "SKGUndoRedoPluginDockWidget::~SKGUndoRedoPluginDockWidget");
}

void SKGUndoRedoPluginDockWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
    SKGTRACEIN ( 10, "SKGUndoRedoPluginDockWidget::dataModified" );
    Q_UNUSED(iIdTransaction);
    Q_UNUSED(iTableName);
    ui.kTransactionList->resizeColumnsToContents();
}

void SKGUndoRedoPluginDockWidget::onUndoRedo(const QModelIndex & index)
{
        SKGTRACEIN(1, "SKGUndoRedoPluginDockWidget::onUndoRedo");
        QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));

        //Get Selection
        SKGError err;
        SKGDocument::UndoRedoMode mode;
        SKGObjectModelBase* model=(SKGObjectModelBase*) ui.kTransactionList->model();
        if (model) {
                SKGObjectBase obj=model->getObject(index);
                int id=obj.getID();
                int lastExecuted=-1;
                mode=(obj.getAttribute("t_mode")=="U" ? SKGDocument::UNDO : SKGDocument::REDO);
                do {
                        lastExecuted=getDocument()->getTransactionToProcess(mode);
                        err=getDocument()->undoRedoTransaction(mode);
                } while (err.isSucceeded() && lastExecuted!=id);
        }
        QApplication::restoreOverrideCursor();

        //status bar
        if (err.isSucceeded()) err=SKGError(0, mode==SKGDocument::UNDO ? i18nc("Message for successful user action","Undo successfully done.") : i18nc("Message for successful user action", "Redo successfully done."));
        else err.addError(ERR_FAIL, mode==SKGDocument::UNDO ? i18nc("Error message","Undo failed") : i18nc("Error message","Redo failed"));

        //Display error
        SKGMainPanel::getMainPanel()->displayErrorMessage(err);
}

void SKGUndoRedoPluginDockWidget::resizeEvent(QResizeEvent * /*event*/)
{
        /*
        QSize newSize=event->size ();

        //Compute icon size
        int s=qMax(qMin(newSize.width()/10,64),16);
        ui.kTransactionList->setIconSize(QSize(s, s));

        QWidget::resizeEvent(event);
        */
}
#include "skgundoredoplugindockwidget.moc"
