/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a plugin for delete operation.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdeleteplugin.h"
#include "skgtraces.h"
#include "skgerror.h"
#include "skgobjectbase.h"
#include "skgtransactionmng.h"
#include "skgmainpanel.h"

#include <QtGui/QWidget>

#include <kactioncollection.h>
#include <kstandardaction.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGDeletePluginFactory, registerPlugin<SKGDeletePlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGDeletePluginFactory("skg_delete", "skg_delete"))

SKGDeletePlugin::SKGDeletePlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGDeletePlugin::SKGDeletePlugin");
}

SKGDeletePlugin::~SKGDeletePlugin()
{
    SKGTRACEIN(10, "SKGDeletePlugin::~SKGDeletePlugin");
    currentDocument=NULL;
    deleteAction=NULL;
}

bool SKGDeletePlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGDeletePlugin::setupActions");
    Q_UNUSED(iArgument);

    currentDocument=iDocument;


    setComponentData( SKGDeletePluginFactory::componentData() );
    setXMLFile("skg_delete.rc");

    //Menu
    deleteAction = new KAction(KIcon("edit-delete"), i18nc("Verb, delete an item","Delete"), this);
    connect(deleteAction, SIGNAL(triggered(bool)), this, SLOT(actionDelete()));
    actionCollection()->addAction( QLatin1String("edit_delete"), deleteAction );
    deleteAction->setShortcut(Qt::Key_Delete);

    if (SKGMainPanel::getMainPanel()) SKGMainPanel::getMainPanel()->registedGlobalAction("edit_delete", deleteAction);
    return true;
}

void SKGDeletePlugin::refresh()
{
    SKGTRACEIN(10, "SKGDeletePlugin::refresh");

    if (deleteAction && SKGMainPanel::getMainPanel()) deleteAction->setEnabled(SKGMainPanel::getMainPanel()->getSelectedObjects().count()>0);
}

QString SKGDeletePlugin::title() const
{
    return i18nc("Verb, delete an item","Delete");
}

int SKGDeletePlugin::getOrder() const
{
    return 5;
}

void SKGDeletePlugin::close()
{
    SKGTRACEIN(10, "SKGDeletePlugin::close");
}

void SKGDeletePlugin::actionDelete()
{
    SKGError err;
    SKGTRACEINRC(10, "SKGDeletePlugin::actionDelete",err);

    QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));
    if (SKGMainPanel::getMainPanel() && currentDocument) {
        SKGObjectBase::SKGListSKGObjectBase selection=SKGMainPanel::getMainPanel()->getSelectedObjects();
        int nb=selection.count();
        SKGBEGINPROGRESSTRANSACTION(*currentDocument, i18nc("Verb, delete an item","Delete"), err, nb);
        for (int i=0; err.isSucceeded() && i<nb; ++i) {
            err=selection[i].remove();
            if (err.isSucceeded()) err=currentDocument->stepForward(i+1);
        }

        //status bar
        if (err.isSucceeded()) err=SKGError(0, i18nc("Successful message after an user action", "Objects deleted."));
        \
        else err.addError(ERR_FAIL, i18nc("Error message", "Delete failed. You are not authorized to delete an object used."));
    }
    QApplication::restoreOverrideCursor();

    //Display error
    if (SKGMainPanel::getMainPanel()) SKGMainPanel::getMainPanel()->displayErrorMessage(err);
}

#include "skgdeleteplugin.moc"
