/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A plugin to select all
 *
 * @author Stephane MANKOWSKI
 */
#include "skgselectallplugin.h"
#include "skgmainpanel.h"
#include "skgtreeview.h"
#include "skgtraces.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

#include <QAbstractItemView>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGSelectAllPluginFactory, registerPlugin<SKGSelectAllPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGSelectAllPluginFactory("skg_selectall", "skg_selectall"))

SKGSelectAllPlugin::SKGSelectAllPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGSelectAllPlugin::SKGSelectAllPlugin");
}

SKGSelectAllPlugin::~SKGSelectAllPlugin()
{
    SKGTRACEIN(10, "SKGSelectAllPlugin::~SKGSelectAllPlugin");
    currentDocument=NULL;
    selectAllAction=NULL;
}

bool SKGSelectAllPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGSelectAllPlugin::setupActions");
    Q_UNUSED(iArgument);

    currentDocument=iDocument;

    setComponentData( SKGSelectAllPluginFactory::componentData() );
    setXMLFile("skg_selectall.rc");

    //Menu
    selectAllAction=actionCollection()->addAction(KStandardAction::SelectAll, "edit_select_all", this, SLOT(actionSelectAll()));

    if (SKGMainPanel::getMainPanel()) SKGMainPanel::getMainPanel()->registedGlobalAction("edit_select_all", selectAllAction);

    return true;
}

void SKGSelectAllPlugin::refresh()
{
    SKGTRACEIN(10, "SKGSelectAllPlugin::refresh");
    if (selectAllAction) selectAllAction->setEnabled(false);
    if (SKGMainPanel::getMainPanel())
    {
        SKGTabPage* page=SKGMainPanel::getMainPanel()->currentPage();
        if (page)
        {
            QWidget* widget=page->mainWidget();
            QAbstractItemView* view=dynamic_cast<QAbstractItemView*>(widget);
            if (view && selectAllAction) selectAllAction->setEnabled(true);
        }
    }
}

void SKGSelectAllPlugin::close()
{
    SKGTRACEIN(10, "SKGSelectAllPlugin::close");
}

QString SKGSelectAllPlugin::title() const
{
    return i18nc("The title", "Select all");
}

QString SKGSelectAllPlugin::icon() const
{
    return "edit-select-all";
}

QString SKGSelectAllPlugin::toolTip () const
{
    return i18nc("The tool tip", "Select all");
}


int SKGSelectAllPlugin::getOrder() const
{
    return 6;
}

QStringList SKGSelectAllPlugin::tips() const
{
    QStringList output;
    return output;
}

bool SKGSelectAllPlugin::isInContext() const
{
    return false;
}

void SKGSelectAllPlugin::actionSelectAll()
{
    SKGTRACEIN(10, "SKGDeletePlugin::actionSelectAll");
    if (SKGMainPanel::getMainPanel())
    {
        SKGTabPage* page=SKGMainPanel::getMainPanel()->currentPage();
        if (page)
        {
            QWidget* widget=page->mainWidget();
            QAbstractItemView* view=dynamic_cast<QAbstractItemView*>(widget);
            if (view) view->selectAll();
        }
    }
}

#include "skgselectallplugin.moc"
