/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef FILESKROOGOID_H
#define FILESKROOGOID_H
/** @file
* This file is Plasma Applet for Tip of the Day Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/PopupApplet>
#include <Plasma/Label>
#include <Plasma/PushButton>

#include <KTipDatabase>

class QGraphicsLinearLayout;
/**
 * Class FileSkroogoid
 */
class FileSkroogoid : public Plasma::PopupApplet
{
    Q_OBJECT

public:
    /**
      * Default Constructor
      */
    FileSkroogoid( QObject *parent, const QVariantList &args );

    /**
      * Default Destructor
      */
    ~FileSkroogoid();

private:
    /**
      * QGraphicsLinearLayout layout for adding items
      */
    QGraphicsLinearLayout *m_layout;

    /**
    * Plasma Label that is used to display heading of skroogoid
    */
    Plasma::Label* heading;

    /**
    * Plasma Label that is used to display fetched result on to skroogoid
    */
    Plasma::Label* displayLabel;

    /**
    * Plasma PushButton for changing tips of the day
    */
    Plasma::PushButton* iconbutton;
  
    private Q_SLOTS:
    /**
    * function to change the tip of the day on button click
    */
      void iconClicked();
};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(fileskroogoid, FileSkroogoid)

#endif
