/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin to calculate
 *
 * @author Stephane MANKOWSKI
 */
#include "skgcalculatorplugin.h"
#include "skgcalculatorpluginwidget.h"
#include "skgcalculator_settings.h"
#include "skginterestboardwidget.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"
#include "skgaccountobject.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGCalculatorPluginFactory, registerPlugin<SKGCalculatorPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGCalculatorPluginFactory("skrooge_calculator", "skrooge_calculator"))

SKGCalculatorPlugin::SKGCalculatorPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGCalculatorPlugin::SKGCalculatorPlugin");
}

SKGCalculatorPlugin::~SKGCalculatorPlugin()
{
    SKGTRACEIN(10, "SKGCalculatorPlugin::~SKGCalculatorPlugin");
    currentBankDocument=NULL;
}

bool SKGCalculatorPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGCalculatorPlugin::setupActions");
    Q_UNUSED(iArgument);
    currentBankDocument=dynamic_cast<SKGDocumentBank*>(iDocument);
    if (currentBankDocument==NULL) return false;

    setComponentData( SKGCalculatorPluginFactory::componentData() );
    setXMLFile("skrooge_calculator.rc");

    //Create yours actions here
    return true;
}

void SKGCalculatorPlugin::refresh()
{
    SKGTRACEIN(10, "SKGCalculatorPlugin::refresh");
}

void SKGCalculatorPlugin::close()
{
    SKGTRACEIN(10, "SKGCalculatorPlugin::close");
}

int SKGCalculatorPlugin::getNbDashboardWidgets()
{
    return 1;
}

QString SKGCalculatorPlugin::getDashboardWidgetTitle(int iIndex)
{
    if (iIndex==0) return i18nc("Noun","Estimated interest");
    return "";
}

SKGWidget* SKGCalculatorPlugin::getDashboardWidget(int iIndex)
{
    if (iIndex==0) return new SKGInterestBoardWidget(currentBankDocument);
    return NULL;
}

SKGTabPage* SKGCalculatorPlugin::getWidget()
{
    SKGTRACEIN(10, "SKGCalculatorPlugin::getWidget");
    return new SKGCalculatorPluginWidget(currentBankDocument);
}

QWidget* SKGCalculatorPlugin::getPreferenceWidget()
{
    SKGTRACEIN(10, "SKGCalculatorPlugin::getPreferenceWidget");
    /*QWidget* widget=new QWidget();
    ui.setupUi(widget);*/

    return NULL;
}

KConfigSkeleton* SKGCalculatorPlugin::getPreferenceSkeleton()
{
    return skgcalculator_settings::self();
}

SKGError SKGCalculatorPlugin::savePreferences() const
{
    return SKGError();
}

QString SKGCalculatorPlugin::title() const
{
    return toolTip();
}

QString SKGCalculatorPlugin::icon() const
{
    return "accessories-calculator";
}

QString SKGCalculatorPlugin::toolTip () const
{
    return i18nc("A tool tip", "Simulations");
}

int SKGCalculatorPlugin::getOrder() const
{
    return 100;
}

QStringList SKGCalculatorPlugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>... you can use the calculator for many things</p>"));
    return output;
}

bool SKGCalculatorPlugin::isInContext() const
{
    return true;
}
QList< SKGInterfacePlugin::SKGAdvice > SKGCalculatorPlugin::advices() const
{
    QList< SKGInterfacePlugin::SKGAdvice > output;

    //Search investment accounts without interest rate
    SKGObjectBase::SKGListSKGObjectBase accounts;
    SKGObjectBase::getObjects(currentBankDocument, "account", "t_type='I' AND NOT EXISTS (SELECT 1 FROM interest WHERE interest.rd_account_id=account.id)", accounts);
    int nb=accounts.count();
    for (int i=0; i<nb; ++i)
    {
        SKGAccountObject account=accounts.at(i);
        SKGInterfacePlugin::SKGAdvice ad;
        ad.uuid="skgcalculatorplugin_nointerest_"+account.getName();
        ad.priority=3;
        ad.shortMessage=i18nc("Advice on making the best (short)", "No interest rate defined for account '%1'", account.getName());
        ad.longMessage=i18nc("Advice on making the best (long)", "Your investment account '%1' doesn't have interest rate defined", account.getName());
        ad.autoCorrection.push_back(i18nc("Advice on making the best (action)", "Open interest page"));
        output.push_back(ad);
    }
    return output;
}

SKGError SKGCalculatorPlugin::executeAdviceCorrection(const QString& iAdviceIdentifier, int iSolution) const
{
    if (currentBankDocument && iAdviceIdentifier.startsWith(QLatin1String("skgcalculatorplugin_nointerest_")))
    {
        //Get parameters
        QString account=iAdviceIdentifier.right(iAdviceIdentifier.length()-31);

        //Call operation plugin
        QDomDocument doc ( "SKGML" );
        doc.setContent ( currentBankDocument->getParameter ( "SKGCALCULATOR_DEFAULT_PARAMETERS" ) );
        QDomElement root = doc.documentElement();
        if ( root.isNull() )
        {
            root=doc.createElement ( "parameters" );
            doc.appendChild ( root );
        }

        root.setAttribute ( "currentPage", "0" );
        root.setAttribute ( "account", account );
        SKGMainPanel::getMainPanel()->openPage ( SKGMainPanel::getMainPanel()->getPluginByName ( "Skrooge calculator plugin" ), -1, doc.toString() );
        return SKGError();
    }

    return SKGInterfacePlugin::executeAdviceCorrection(iAdviceIdentifier, iSolution);
}
#include "skgcalculatorplugin.moc"
