/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file implements classes SKGTransactionMng.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "skgtransactionmng.h"
#include "skgdocument.h"
#include "skgerror.h"

SKGTransactionMng::SKGTransactionMng(SKGDocument* iDocument,
                                     const QString& iName,
                                     SKGError* iError,
                                     int iNbStep)
{
    m_parentDocument = iDocument;
    m_error = iError;
    if(m_parentDocument && m_error) {
        *m_error = m_parentDocument->beginTransaction(iName, iNbStep);
        m_errorInBeginTransaction = (m_error->isFailed());
    }

}

SKGTransactionMng::~SKGTransactionMng()
{
    if(m_parentDocument && m_error) {
        //close the transaction based on error
        if(!m_errorInBeginTransaction) {
            if(m_error->isSucceeded()) *m_error = m_parentDocument->endTransaction(true);
            else  m_parentDocument->endTransaction(false);
        }
        m_parentDocument = NULL;
        m_error = NULL;
    }
}

