/*
	skyeye_flash.c - skyeye general flash device file support functions
	Copyright (C) 2003 - 2005 Skyeye Develop Group
        for help please send mail to <skyeye-developer@lists.gro.clinux.org>
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 
*/

/*
 * 09/22/2005 	initial version
 *			walimis <wlm@student.dlut.edu.cn>
 */

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
//koodailar add for mingw 2005.12.18 ----------------------------------------
#ifdef __MINGW32__
#include "arch/arm/common/armdefs.h"
#include "device/skyeye_device.h"
#else
#include "armdefs.h"
#include "skyeye_device.h"
#endif
// end ----------------------------------------------------------------------


#include "skyeye_options.h"
#include "skyeye.h"
#include "skyeye_flash.h"


/* initialize the flash module set.
 * If you want to add a new flash simulation, just add a "flash_*_init" function to it.
 * */
static void
flash_init (struct device_module_set *mod_set)
{
	flash_intel_init (mod_set);
}
static int
flash_setup (struct device_desc *dev, void *option)
{
	struct flash_device *flash_dev;
	struct flash_option *flash_opt = (struct flash_option *) option;
	int ret = 0;

	flash_dev =
		(struct flash_device *) malloc (sizeof (struct flash_device));
	if (flash_dev == NULL)
		return 1;

	memset (flash_dev, 0, sizeof (flash_dev));

	/*
	   flash_dev->mod = flash_opt->mod;
	   printf ("flash_mod:%d\n", flash_dev->mod);
	   switch (flash_dev->mod)
	   {
	   case LCD_MOD_GTK:
	   flash_dev->flash_open = gtk_flash_open;
	   flash_dev->flash_close = gtk_flash_close;
	   flash_dev->flash_update = gtk_flash_update;
	   flash_dev->flash_read = gtk_flash_read;
	   flash_dev->flash_write = gtk_flash_write;
	   break;
	   case LCD_MOD_QT:
	   case LCD_MOD_X:
	   case LCD_MOD_SDL:
	   break;
	   }
	 */

	dev->dev = (void *) flash_dev;
	return ret;

}
static struct device_module_set flash_mod_set = {
	.name = "flash",
	.count = 0,
	.count_max = 0,
	.init = flash_init,
	.initialized = 0,
	.setup_module = flash_setup,
};

/* used by global device initialize function. 
 * */
void
flash_register ()
{
	if (register_device_module_set (&flash_mod_set))
		SKYEYE_ERR ("\"%s\" module set register error!\n",
			    flash_mod_set.name);
}
