/*
	skyeye_lcd.h - skyeye general lcd device file support functions
	Copyright (C) 2003 - 2005 Skyeye Develop Group
        for help please send mail to <skyeye-developer@lists.gro.clinux.org>
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 
*/

#ifndef __SKYEYE_LCD_H_
#define __SKYEYE_LCD_H_

//koodailar add for mingw 2005.12.18 ----------------------------------------
#ifdef __MINGW32__
#include "device/skyeye_device.h"
#else
#include "skyeye_device.h"
#endif
// end ----------------------------------------------------------------------


#define LCD_MOD_GTK   	0
#define LCD_MOD_QT	1
#define LCD_MOD_X   	2
#define LCD_MOD_SDL    	3

struct lcd_device
{
	int mod;

	int width;
	int height;
	int depth;

	void *state;

	u32 lcd_addr_begin;
	u32 lcd_addr_end;
	/* gtk or qt may use some private data. */
	void *priv;

	int (*lcd_open) (struct lcd_device * lcd_dev);
	int (*lcd_close) (struct lcd_device * lcd_dev);
	int (*lcd_update) (struct lcd_device * lcd_dev);
	int (*lcd_read) (struct lcd_device * lcd_dev, void *buf,
			 size_t count);
	int (*lcd_write) (struct lcd_device * lcd_dev, void *buf,
			  size_t count);
};

int gtk_lcd_update (struct lcd_device *lcd_dev);
int gtk_lcd_open (struct lcd_device *lcd_dev);
int gtk_lcd_close (struct lcd_device *lcd_dev);
int gtk_lcd_read (struct lcd_device *lcd_dev);
int gtk_lcd_write (struct lcd_device *lcd_dev);

#endif	/*__SKYEYE_LCD_H_*/
