*DECK QCDRD
      SUBROUTINE QCDRD (LUN, KPRINT, IPASS)
C***BEGIN PROLOGUE  QCDRD
C***PURPOSE  Quick check for DRD.
C***LIBRARY   SLATEC
C***KEYWORDS  QUICK CHECK
C***AUTHOR  Pexton, R. L., (LLNL)
C***DESCRIPTION
C
C            QUICK TEST FOR CARLSON INTEGRAL DRD
C
C***ROUTINES CALLED  D1MACH, DRD, NUMXER, XERCLR, XGETF, XSETF
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   890618  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   910708  Minor modifications in use of KPRINT.  (WRB)
C   930214  Added more digits to BLEM.  (WRB)
C***END PROLOGUE  QCDRD
      INTEGER KPRINT, IPASS, CONTRL, KONTRL, LUN, IER
      INTEGER IPASS1, IPASS2, IPASS3, IPASS4, NUMXER
      DOUBLE PRECISION BLEM, TRD, DRD, DIF, D1MACH
      EXTERNAL D1MACH, DRD, NUMXER, XERCLR, XGETF, XSETF
C***FIRST EXECUTABLE STATEMENT  QCDRD
      CALL XERCLR
      CALL XGETF(CONTRL)
      IF ( KPRINT .GE. 3 ) THEN
         KONTRL = +1
      ELSE
         KONTRL = 0
      ENDIF
      CALL XSETF(KONTRL)
C
C  FORCE ERROR 1
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,101)
  101 FORMAT(' DRD - FORCE ERROR 1 TO OCCUR')
      TRD = DRD(-1.0D0,-1.0D0,-1.0D0,IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 1 ) THEN
         IPASS1 = 1
      ELSE
         IPASS1 = 0
      ENDIF
      CALL XERCLR
C
C  FORCE ERROR 2
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,102)
  102 FORMAT(' DRD - FORCE ERROR 2 TO OCCUR')
      TRD = DRD(1.0D0,1.0D0,-1.0D0,IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 2 ) THEN
         IPASS2 = 1
      ELSE
         IPASS2 = 0
      ENDIF
      CALL XERCLR
C
C  FORCE ERROR 3
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,103)
  103 FORMAT(' DRD - FORCE ERROR 3 TO OCCUR')
      TRD = DRD(D1MACH(2),D1MACH(2),D1MACH(2),IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 3 ) THEN
         IPASS3 = 1
      ELSE
         IPASS3 = 0
      ENDIF
      CALL XERCLR
C
C  ARGUMENTS IN RANGE
C  BLEM=3 * LEMNISCATE CONSTANT B
C
      BLEM = 1.797210352103388311159883738420485817341D0
      TRD  = DRD(0.0D0,2.0D0,1.0D0,IER)
      CALL XERCLR
      DIF  = TRD - BLEM
      IF ( (ABS(DIF/BLEM).LT.1000.0D0*D1MACH(4)).AND.(IER.EQ.0) ) THEN
         IPASS4 = 1
      ELSE
         IPASS = 0
      ENDIF
      IPASS = MIN(IPASS1,IPASS2,IPASS3,IPASS4)
      IF ( KPRINT .LE. 0 ) THEN
         GO TO 999
      ELSEIF ( KPRINT .EQ. 1 ) THEN
         IF ( IPASS .EQ. 1 ) THEN
            GO TO 999
         ELSE
            WRITE (LUN,104)
  104       FORMAT(' DRD - FAILED')
            GO TO 999
         ENDIF
      ELSE
         IF ( IPASS .EQ. 1 ) THEN
            WRITE (LUN,105)
  105       FORMAT(' DRD - PASSED')
            GO TO 999
         ELSE
            WRITE (LUN,104)
            IF ( IPASS4 .EQ. 0 ) WRITE (LUN,106) BLEM, TRD, DIF
  106       FORMAT(' CORRECT ANSWER =', 1PD20.14 /
     *             'COMPUTED ANSWER =',   D20.14 /
     *             '     DIFFERENCE =',   D20.14 )
            GO TO 999
         ENDIF
      ENDIF
  999 CONTINUE
      CALL XSETF(CONTRL)
      RETURN
      END
