/*
 * The Sleuth Kit
 *
 * $Date: 2005/01/17 22:40:17 $
 *
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2003-2005 Brian Carrier.  All rights reserved
 * 
 * This file is part of mmtools
 *
 * mmtools is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the  
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 */

#ifndef _BSD_H
#define _BSD_H


typedef struct {
    uint8_t magic[4];
    uint8_t type[2];
    uint8_t sub_type[2];
    uint8_t type_name[16];

    uint8_t packname[16];

    uint8_t sec_size[4];
    uint8_t sec_per_tr[4];
    uint8_t tr_per_cyl[4];
    uint8_t cyl_per_unit[4];
    uint8_t sec_per_cyl[4];
    uint8_t sec_per_unit[4];

    uint8_t spare_per_tr[2];
    uint8_t spare_per_cyl[2];

    uint8_t alt_per_unit[4];

    uint8_t rpm[2];
    uint8_t interleave[2];
    uint8_t trackskew[2];
    uint8_t cylskew[2];
    uint8_t headswitch[4];
    uint8_t track_seek[4];
    uint8_t flags[4];

    uint8_t drivedata[20];

    uint8_t reserved1[20];

    uint8_t magic2[4];
    uint8_t checksum[2];

    uint8_t num_parts[2];
    uint8_t bootarea_size[4];
    uint8_t sb_size[4];

    struct {
	uint8_t size_sec[4];
	uint8_t start_sec[4];
	uint8_t frag_size[4];
	uint8_t fstype;
	uint8_t frag_per_block;
	uint8_t cyl_per_grp[2];
    } part[16];

    /* padding to make it a full 512 bytes */
    uint8_t reserved2[108];

} bsd_disklabel;

#define BSD_MAGIC	0x82564557
#define BSD_PART_OFFSET	1

#endif
