# Copyright 1997, 2000, 2001 Free Software Foundation, Inc. {{{

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
 
# serial 5 }}}

AC_PREREQ(2.52)

dnl The next few portions come from various Gtk/PyGtk scripts

# AM_CONDITIONAL(NAME, SHELL-CONDITION) dnl {{{
# -------------------------------------
# Define a conditional.
AC_DEFUN([AM_CONDITIONAL],
[ifelse([$1], [TRUE],  [AC_FATAL([$0: invalid condition: $1])],
        [$1], [FALSE], [AC_FATAL([$0: invalid condition: $1])])dnl
AC_SUBST([$1_TRUE])
AC_SUBST([$1_FALSE])
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi dnl }}}

AC_CONFIG_COMMANDS_PRE( dnl {{{
[if test -z "${$1_TRUE}" && test -z "${$1_FALSE}"; then
  AC_MSG_ERROR([conditional \"$1\" was never defined.
Usually this means the macro was only invoked conditionally.])
fi])])
dnl }}}

dnl Most of the next few compile/link portions come from the S-Lang library
dnl aclocal.m4 and have been cobbled a bit.  It is assumed that AC_SLGTK_INIT
dnl has been run prior to these macros.

AC_DEFUN(JD_INIT, dnl {{{
[
#These variable are initialized by JD init function
CONFIG_DIR=`pwd`
cd $srcdir
if test "`pwd`" != "$CONFIG_DIR"
then 
  AC_MSG_ERROR("This software does not support configuring from another directory.   See the INSTALL file")
fi
AC_SUBST(CONFIG_DIR)dnl
# Note: these will differ if one is a symbolic link
if test -f /usr/bin/dirname; then
  JD_Above_Dir=`dirname $CONFIG_DIR`
else
# system is a loser
  JD_Above_Dir=`cd ..;pwd`
fi
JD_Above_Dir2=`cd ..;pwd`
])
dnl }}}

AC_DEFUN(JD_SET_OBJ_SRC_DIR, dnl {{{
[
#---------------------------------------------------------------------------
# Set the source directory and object directory.   The makefile assumes an
# abcolute path name.  This is because src/Makefile cds to OBJDIR and compiles
# the src file which is in SRCDIR
#---------------------------------------------------------------------------
SRCDIR=$CONFIG_DIR
if test "$1" != "."
then
  if test -z "$1"
  then
    SRCDIR=$SRCDIR/src
  else
    SRCDIR=$SRCDIR/$1
  fi
fi

OBJDIR=$SRCDIR/"$ARCH"objs
ELFDIR=$SRCDIR/elf"$ARCH"objs
AC_SUBST(SRCDIR)dnl
AC_SUBST(OBJDIR)dnl
AC_SUBST(ELFDIR)dnl
])dnl}}}

RPATH=""
AC_SUBST(RPATH)dnl

AC_DEFUN(JD_INIT_RPATH, dnl {{{
[
case "$host_os" in
  *linux*|*solaris* )
    if test "X$GCC" = Xyes
    then
      if test "X$ac_R_nospace" = "Xno"
      then
        RPATH="-Wl,-R,"
      else
        RPATH="-Wl,-R"
      fi
    else
      if test "X$ac_R_nospace" = "Xno"
      then
        RPATH="-R "
      else
	RPATH="-R"
      fi
    fi
  ;;
  *osf*)
    if test "X$GCC" = Xyes
    then
      RPATH="-Wl,-rpath,"
    else
      RPATH="-rpath "
    fi
  ;;
esac
])dnl}}}

AC_DEFUN(JD_SET_RPATH, dnl{{{
[
if test "X$1" != "X"
then
  if test "X$RPATH" = "X"
  then 
    JD_INIT_RPATH
    if test "X$RPATH" != "X"
    then
      RPATH="$RPATH$1"
    fi
  else
    RPATH="$RPATH:$1"
  fi
fi
])dnl}}}

AC_DEFUN(JD_SIMPLE_LIB_DIR, dnl{{{
[
changequote(<<, >>)dnl
define(<<JD_UP_NAME>>, translit($1, [a-z], [A-Z]))dnl
changequote([, ])dnl
JD_UP_NAME[]_LIB_DIR=$JD_Above_Dir/$1/libsrc/"$ARCH"objs
JD_UP_NAME[]_INCLUDE=$JD_Above_Dir/$1/libsrc

if test ! -d "[$]JD_UP_NAME[]_INCLUDE"
then
   JD_UP_NAME[]_LIB_DIR=$JD_Above_Dir/$1/src/"$ARCH"objs
   JD_UP_NAME[]_INCLUDE=$JD_Above_Dir/$1/src
   if test ! -d "[$]JD_UP_NAME[]_INCLUDE"
   then
     echo ""
     echo WARNING------Unable to find the JD_UP_NAME directory
     dnl echo You may have to edit $CONFIG_DIR/src/Makefile.
     echo ""
   fi
fi

AC_SUBST(JD_UP_NAME[]_LIB_DIR)dnl
AC_SUBST(JD_UP_NAME[]_INCLUDE)dnl
undefine([JD_UP_NAME])dnl
])dnl}}}

AC_DEFUN(JD_FIND_GENERIC, dnl{{{
[
changequote(<<, >>)dnl
define(<<JD_UP_NAME>>, translit($1, [a-z], [A-Z]))dnl
changequote([, ])dnl
# Look for the JD_UP_NAME package
#JD_UP_NAME[]_INCLUDE=""
#JD_UP_NAME[]_LIB_DIR=""

# This list consists of "include,lib include,lib ..."
JD_Search_Dirs="$JD_Above_Dir2/$1/libsrc,$JD_Above_Dir2/$1/libsrc/"$ARCH"objs \
                $JD_Above_Dir/$1/libsrc,$JD_Above_Dir/$1/libsrc/"$ARCH"objs \
		$JD_Above_Dir2/$1/src,$JD_Above_Dir2/$1/src/"$ARCH"objs \
                $JD_Above_Dir/$1/src,$JD_Above_Dir/$1/src/"$ARCH"objs"

test "x$exec" = "xNONE" && exec="$ac_default_prefix"
test "x$exec_prefix" = "xNONE" && exec_prefix="$prefix"
JD_Search_Dirs="$JD_Search_Dirs \
                $includedir,$libdir \
		$prefix/include,$exec_prefix/lib \
		$HOME/include,$HOME/lib"

if test -n "$ARCH"
then
 JD_Search_Dirs="$JD_Search_Dirs $HOME/include,$HOME/$ARCH/lib"
 JD_Search_Dirs="$JD_Search_Dirs $HOME/include,$HOME/sys/$ARCH/lib"
fi

if test -n "$slangdir" ; then
 JD_Search_Dirs="$slangdir/include,$slangdir/lib $JD_Search_Dirs"
fi

# Now add the standard system includes.  The reason for doing this is that 
# the other directories may have a better chance of containing a more recent
# version.

test "x$exec" = "xNONE" && exec="$ac_default_prefix"
test "x$exec_prefix" = "xNONE" && exec_prefix="$prefix"
JD_Search_Dirs="$JD_Search_Dirs \
                /usr/local/include,/usr/local/lib \
		/usr/include,/usr/lib \
		/usr/include/$1,/usr/lib \
		/usr/include/$1,/usr/lib/$1"

echo looking for the JD_UP_NAME library

for include_and_lib in $JD_Search_Dirs
do
  # Yuk.  Is there a better way to set these variables??
  generic_include=`echo $include_and_lib | tr ',' ' ' | awk '{print [$]1}'`
  generic_lib=`echo $include_and_lib | tr ',' ' ' | awk '{print [$]2}'`
  echo Looking for $1.h in $generic_include
  echo and lib$1.a in $generic_lib
  if test -r $generic_include/$1.h && test -r $generic_lib/lib$1.a
  then
    echo Found it.
    JD_UP_NAME[]_LIB_DIR="$generic_lib"
    JD_UP_NAME[]_INCLUDE="$generic_include"
    break
  else
    if test -r $generic_include/$1.h && test -r $generic_lib/lib$1.so
    then
      echo Found it.
      JD_UP_NAME[]_LIB_DIR="$generic_lib"
      JD_UP_NAME[]_INCLUDE="$generic_include"
      break
    fi
  fi
done

if test -n "[$]JD_UP_NAME[]_LIB_DIR"
then
    jd_have_$1="yes"
else
    echo Unable to find the $JD_UP_NAME library.  
    dnl echo You may have to edit $CONFIG_DIR/src/Makefile.
    JD_UP_NAME[]_INCLUDE=$JD_Above_Dir/$1/src
    JD_UP_NAME[]_LIB_DIR=$JD_Above_Dir/$1/src/"$ARCH"objs
    jd_have_$1="no"
fi

JD_UP_NAME[]_INC="-I[$]JD_UP_NAME[]_INCLUDE"
JD_UP_NAME[]_LIB="-L[$]JD_UP_NAME[]_LIB_DIR"
JD_SET_RPATH([$]JD_UP_NAME[]_LIB_DIR)

# gcc under solaris is often not installed correctly.  Avoid specifying
# -I/usr/include.
if test "[$]JD_UP_NAME[]_INC" = "-I/usr/include"
then
    JD_UP_NAME[]_INC=""
fi

if test "[$]JD_UP_NAME[]_LIB" = "-L/usr/lib"
then
    JD_UP_NAME[]_LIB=""
    RPATH_[]JD_UP_NAME=""
fi

AC_SUBST(JD_UP_NAME[]_LIB)dnl
AC_SUBST(JD_UP_NAME[]_INC)dnl
AC_SUBST(JD_UP_NAME[]_LIB_DIR)dnl
AC_SUBST(JD_UP_NAME[]_INCLUDE)dnl
dnl AC_SUBST(RPATH_[]JD_UP_NAME)dnl
undefine([JD_UP_NAME])dnl
])dnl}}}

AC_DEFUN(JD_FIND_SLANG, dnl{{{
[
JD_FIND_GENERIC(slang)
])dnl}}}

AC_DEFUN(GCC_WARNINGS, dnl {{{
[
dnl This originated from JD_GCC_WARNINGS
AC_ARG_ENABLE(warnings,
	      [  --enable-warnings       turn on GCC compiler warnings],
	      [gcc_warnings=$enableval])
if test -n "$GCC" ; then
  CFLAGS="$CFLAGS -fno-strength-reduce -fno-strict-aliasing"
  if test -n "$gcc_warnings" ; then

  CFLAGS="$CFLAGS -Wall -W -pedantic -Winline -Wmissing-prototypes \
 -Wnested-externs -Wpointer-arith -Wcast-align -Wshadow -Wstrict-prototypes"
    # Now trim excess whitespace
    CFLAGS=`echo $CFLAGS`
  else
    # Always ensure that at least -Wall is specified for all GCC compiles
	case " $CFLAGS " in
	   *[\	\ ]-Wall[\	\ ]*) ;;
	   *) CFLAGS="$CFLAGS -Wall" ;;
	esac
  fi
fi
])dnl}}}

IEEE_CFLAGS=""
AC_DEFUN(JD_IEEE_CFLAGS, dnl{{{
[
case "$host_cpu" in
  *alpha* )
    if test "$GCC" = yes
    then
      IEEE_CFLAGS="-mieee"
    else
      IEEE_CFLAGS="-ieee_with_no_inexact"
    fi
    ;;
  * )
    IEEE_CFLAGS=""
esac
])dnl}}}

AC_DEFUN(JD_ANSI_CC, dnl{{{
[

AC_PROG_CC
AC_PROG_CPP
AC_PROG_GCC_TRADITIONAL
AC_ISC_POSIX
AC_AIX

dnl #This stuff came from Yorick config script
dnl
dnl # HPUX needs special stuff
dnl
AC_EGREP_CPP(yes,
[#ifdef hpux
  yes
#endif
], [
AC_DEFINE(_HPUX_SOURCE)
if test "$CC" = cc; then CC="cc -Ae"; fi
])dnl
dnl
dnl #Be sure we've found compiler that understands prototypes
dnl
AC_MSG_CHECKING(C compiler that understands ANSI prototypes)
AC_TRY_COMPILE([ ],[
 extern int silly (int);], [
 AC_MSG_RESULT($CC looks ok.  Good.)], [
 AC_MSG_RESULT($CC is not a good enough compiler)
 AC_MSG_ERROR(Set env variable CC to your ANSI compiler and rerun configure.)
 ])dnl
])dnl }}}

AC_DEFUN(JD_ELF_COMPILER, dnl{{{
[

dnl #-------------------------------------------------------------------------
dnl # Check for dynamic linker
dnl #-------------------------------------------------------------------------
DYNAMIC_LINK_LIB=""
AC_CHECK_HEADER(dlfcn.h,[
  AC_DEFINE(HAVE_DLFCN_H)
  AC_CHECK_LIB(dl,dlopen,[
    DYNAMIC_LINK_LIB="-ldl"
    AC_DEFINE(HAVE_DLOPEN)
   ],[
    AC_CHECK_FUNC(dlopen,AC_DEFINE(HAVE_DLOPEN))
    if test "$ac_cv_func_dlopen" != yes
    then
      AC_MSG_WARN(cannot perform dynamic linking)
    fi
   ])])
AC_SUBST(DYNAMIC_LINK_LIB)

ELFLIB="lib${PACKAGE_NAME}.so"
ELFLIB_MAJOR="\$(ELFLIB).\$(ELF_MAJOR_VERSION)"
ELFLIB_MAJOR_MINOR="\$(ELFLIB).\$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION)"

dnl # ---------------------------------------------------------------------
dnl # Find path to GCC, since rest of macro requires it (added by mnoble)
dnl # ---------------------------------------------------------------------

CC_PATH=`AS_DIRNAME([$CC])`
AC_PATH_PROG([GCC_PATH],[gcc],[gcc],[$PATH:$CC_PATH:/usr/local/bin])
AC_PATH_PROG([STRIP],[strip],[:],[$PATH:/bin:/usr/bin:/usr/ccs/bin:/usr/local/bin])

sh_ext=.so
gdktarget=x11

case "$host_os" in

  *linux* )
    DYNAMIC_LINK_FLAGS="-Wl,-export-dynamic"
    ELF_CC="$GCC_PATH"
    ELF_CFLAGS="\$(CFLAGS) -fPIC"
    ELF_LINK="$GCC_PATH -shared -Wl,-soname#"
    ELF_LINK_CMD="\$(ELF_LINK),\$(ELFLIB_MAJOR)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="$GCC_PATH \$(CFLAGS) -shared -fPIC"
    ;;

  *solaris* )
    if test "$GCC" = yes ; then
      DYNAMIC_LINK_FLAGS=""
      ELF_CC="$GCC_PATH"
      ELF_CFLAGS="\$(CFLAGS) -fPIC"
      ELF_LINK="$GCC_PATH -shared -Wl,-ztext -Wl,-h#"
      ELF_LINK_CMD="\$(ELF_LINK),\$(ELFLIB_MAJOR)"
      ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
      CC_SHARED="$GCC_PATH \$(CFLAGS) -G -fPIC"
    else
      DYNAMIC_LINK_FLAGS=""
      ELF_CC="cc"
      ELF_CFLAGS="-K PIC"
      ELF_LINK="cc -G -h#"
      ELF_LINK_CMD="\$(ELF_LINK)\$(ELFLIB_MAJOR)"
      ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
      CC_SHARED="cc \$(CFLAGS) -G -K PIC"
      LIBGCC=`$GCC_PATH --print-file-name libgcc.a`
      dnl HEAD/CFA solaris Gtk/etc libs have been built with GCC
      BINDIST_LIB_HACK="-L`AS_DIRNAME([$LIBGCC])` -lgcc"
    fi
    ;;

   # osr5 or unixware7 with current or late autoconf
  *sco3.2v5* | *unixware-5* | *sco-sysv5uw7*)
     if test "$GCC" = yes
     then
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="$GCC_PATH"
       ELF_CFLAGS="\$(CFLAGS) -fPIC"
       ELF_LINK="$GCC_PATH -shared -Wl,-h#"
       ELF_LINK_CMD="\$(ELF_LINK),\$(ELFLIB_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="$GCC_PATH \$(CFLAGS) -G -fPIC"
     else
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="cc"
       ELF_CFLAGS="-K pic"
       # ELF_LINK="ld -G -z text -h#"
       ELF_LINK="cc -G -z text -h#"
       ELF_LINK_CMD="\$(ELF_LINK)\$(ELFLIB_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="cc \$(CFLAGS) -G -K pic"
     fi
     ;;

  *irix6.5* )
     echo "Note: ELF compiler for host_os=$host_os may not be correct"
     echo "double-check: 'mode_t', 'pid_t' may be wrong!"
     if test "$GCC" = yes
     then
       # not tested
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="$GCC_PATH"
       ELF_CFLAGS="\$(CFLAGS) -fPIC"
       ELF_LINK="$GCC_PATH -shared -Wl,-h#"
       ELF_LINK_CMD="\$(ELF_LINK),\$(ELFLIB_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="$GCC_PATH \$(CFLAGS) -shared -fPIC"
     else
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="cc"
       ELF_CFLAGS="-K pic"     # default anyhow
       ELF_LINK="cc -shared -o #"
       ELF_LINK_CMD="\$(ELF_LINK)\$(ELFLIB_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="cc \$(CFLAGS) -shared -K pic"
     fi
     ;;

  *darwin* )

     sh_ext=.dylib
     DYNAMIC_LINK_FLAGS=""
     ELF_CC="cc"
     ELF_CFLAGS="\$(CFLAGS) -fno-common"
     ELF_LINK="cc -dynamiclib"
     dnl The Darwin linker didn't seem to like a compatibility version
     dnl (major version) of 0, so until SLgtk reaches 1.0 we omit it.
     dnl ELF_LINK_CMD="\$(ELF_LINK) -install_name \$(install_lib_dir)/\$(ELFLIB_MAJOR) -compatibility_version \$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION) -current_version \$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION)"
     ELF_LINK_CMD="\$(ELF_LINK) -install_name \$(install_lib_dir)/\$(ELFLIB_MAJOR) -current_version \$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION)"
     ELF_DEP_LIBS="$LDFLAGS \$(DL_LIB)"
     CC_SHARED="cc -bundle -flat_namespace -undefined suppress \$(CFLAGS) -fno-common"
     ELFLIB="lib${PACKAGE_NAME}.dylib"
     ELFLIB_MAJOR="lib${PACKAGE_NAME}.\$(ELF_MAJOR_VERSION).dylib"
     ELFLIB_MAJOR_MINOR="lib${PACKAGE_NAME}.\$(ELF_MAJOR_VERSION).\$(ELF_MINOR_VERSION).dylib"
     STRIP=:
     BINDIST_LIB_HACK="-lXext -lXinerama -lXrandr -lXrender"
     ;;

  *cygwin* )

    gdktarget=win32
    sh_ext=.dll
    ELF_CC="$CC"
    ELF_CFLAGS="\$(CFLAGS)"
    ELF_LINK="$CC -shared"
    ELF_LINK_CMD="\$(ELF_LINK)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="$CC \$(CFLAGS) -shared"
    ;;

  * )
    echo "Note: ELF compiler for host_os=$host_os may be wrong"
    ELF_CC="$CC"
    ELF_CFLAGS="\$(CFLAGS) -fPIC"
    ELF_LINK="$CC -shared"
    ELF_LINK_CMD="\$(ELF_LINK)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="$CC \$(CFLAGS) -shared -fPIC"
esac

AC_SUBST(ELF_CC)
AC_SUBST(ELF_CFLAGS)
AC_SUBST(ELF_LINK)
AC_SUBST(ELF_LINK_CMD)
AC_SUBST(ELF_DEP_LIBS)
AC_SUBST(DYNAMIC_LINK_FLAGS)
AC_SUBST(CC_SHARED)
AC_SUBST(ELFLIB)
AC_SUBST(ELFLIB_MAJOR)
AC_SUBST(ELFLIB_MAJOR_MINOR)
AC_SUBST(STRIP)
]) dnl }}}

AC_DEFUN(AC_CC_DEBUG_INFO, dnl {{{
[
AC_ARG_ENABLE(ccdebug,
	      [  --enable-ccdebug	  include -g debug info in ALL compiled C code],
	      [ccdebug=$enableval])

if test -n "$ccdebug" ; then
    cflags_has_dash_g=`echo $CFLAGS | grep -w "\-g"`
    if test -z "$cflags_has_dash_g" ; then
	CFLAGS="-g $CFLAGS"
    fi
    ELF_CFLAGS="-g $ELF_CFLAGS"
fi
]) dnl }}}

dnl The next few portions come from various SLang module autoconf scripts

AC_DEFUN(JD_UPPERCASE, dnl#{{{
[
changequote(<<, >>)dnl
define(<<$2>>, translit($1, [a-z], [A-Z]))dnl
changequote([, ])dnl
])
#}}}

AC_DEFUN(JD_WITH_LIBRARY, dnl#{{{
[
JD_UPPERCASE($1,JD_ARG1)
AC_ARG_WITH($1,
  [  --with-$1=DIR		Use DIR/lib and DIR/include for $1],
  [jd_with_$1_arg=$withval], [jd_with_$1_arg=no])
case "x$jd_with_$1_arg" in
xno)
  ;;
x)
  AC_MSG_ERROR(--with-$1 requres a value)
  ;;
*)
   JD_ARG1[]_INC=-I$jd_with_$1_arg/include
   JD_ARG1[]_LIB=-L$jd_with_$1_arg/lib
   JD_SET_RPATH($jd_with_$1_arg/lib)
  ;;
esac

AC_ARG_WITH($1lib,
  [  --with-$1lib=DIR		$1 library in DIR],
  [jd_with_$1lib_arg=$withval], [jd_with_$1lib_arg=no])
case "x$jd_with_$1lib_arg" in
xno)
  ;;
x)
  AC_MSG_ERROR(--with-$1lib requres a value)
  ;;
*)
   JD_ARG1[]_INC=-I$jd_with_$1lib_arg
   JD_ARG1[]_LIB=-L$jd_with_$1lib_arg
   JD_SET_RPATH($jd_with_$1lib_arg)
  ;;
esac

AC_ARG_WITH($1inc, 
  [  --with-$1inc=DIR		$1 include files in DIR],
  [jd_with_$1inc_arg=$withval], [jd_with_$1inc_arg=no])
case "x$jd_with_$1inc_arg" in
x)
  AC_MSG_ERROR(--with-$1inc requres a value)
  ;;
xno)
  ;;
*)
   JD_ARG1[]_INC=-I$jd_with_$1inc_arg
  ;;
esac
AC_SUBST(JD_ARG1[]_INC)
AC_SUBST(JD_ARG1[]_LIB)
])
dnl#}}}

AC_DEFUN(JD_SLANG_VERSION, dnl#{{{
[
 slang_h=$jd_slang_include_dir/slang.h
 AC_MSG_CHECKING(SLANG_VERSION in $slang_h)
slang_version=`grep "^#define  *SLANG_VERSION " $slang_h |
               awk '{ print [$]3 }'`
slang_major_version=`echo $slang_version |
 awk '{ print int([$]1/10000) }'`
slang_minor_version=`echo $slang_version $slang_major_version |
 awk '{ print int(([$]1 - [$]2*10000)/100) }'`
slang_patchlevel_version=`echo $slang_version $slang_major_version $slang_minor_version |
 awk '{ print ([$]1 - [$]2*10000 - [$]3*100) }'`

AC_MSG_RESULT($slang_major_version.$slang_minor_version.$slang_patchlevel_version)
AC_SUBST(slang_version)
AC_SUBST(slang_major_version)
AC_SUBST(slang_minor_version)
AC_SUBST(slang_patchlevel_version)
])
#}}}

AC_DEFUN(JD_SLANG_MODULE_INSTALL_DIR, dnl#{{{
[
  AC_REQUIRE([JD_SLANG_VERSION])
  if test "X$slang_major_version" = "X1"
  then
    MODULE_INSTALL_DIR="$libdir/slang/modules"
  else
    MODULE_INSTALL_DIR="$libdir/slang/v$slang_major_version/modules"
  fi
  SL_FILES_INSTALL_DIR=$datadir/slsh/local-packages
  AC_SUBST(MODULE_INSTALL_DIR)
  AC_SUBST(SL_FILES_INSTALL_DIR)
])
#}}}

dnl Section: Rest of file is a collection of hacks for SLgtk

AC_DEFUN(AC_SETUP_SLANG, dnl#{{{
[

test "x$prefix" = "xNONE" && prefix="$ac_default_prefix"
JD_WITH_LIBRARY(slang)

if test -z "$SLANG_INC" ; then
    SLANG_INC="-I$prefix/include"
    echo "S-Lang include directory not specified, defaulting to $SLANG_INC"
    AC_SUBST(SLANG_INC)
 fi
 if test -z "$SLANG_LIB" ; then
    SLANG_LIB="-L$prefix/lib"
    echo "S-Lang lib directory not specified, defaulting to $SLANG_LIB"
    JD_SET_RPATH($libdir)
    AC_SUBST(SLANG_LIB)
 fi

incdir=`echo $SLANG_INC | cut -c 3-`
if test -z "$incdir" ; then
   incdir=$prefix/include
fi
if ! test -f $incdir/slang.h  ; then
   AC_MSG_ERROR([could not find include/slang.h])
fi

jd_slang_include_dir=$incdir
JD_SLANG_VERSION

echo "SLang version is $slang_version"
required_slang_version_as_int=`echo $1 | tr '.' '0'`
if test -z "$slang_version" || test $slang_version -lt $required_slang_version_as_int ; then
	AC_MSG_ERROR([S-Lang $1 or greater is required for this software])
fi
SLANG_LIB_STATIC=`echo $SLANG_LIB| cut -c 3-`/libslang.a
AC_SUBST(SLANG_LIB_STATIC)
JD_SLANG_MODULE_INSTALL_DIR
])
#}}}

AC_DEFUN(AC_WITH_PKGCONFIG, dnl {{{
[
  AC_SUBST(pkgconfig)
  AC_ARG_WITH(pkgconfig,
	[
  --with-pkgconfig=FULLPATH	Specify full path to pkg-config utility, when
				it or Gtk, etc are installed in non-standard
				locations.  (Default: use $PATH from env)
	],
	[PKG_CONFIG=$withval/pkg-config],
	[ AC_PATH_PROG(PKG_CONFIG, pkg-config, no) ])
])dnl }}}

AC_DEFUN(AC_FIND_SLSH, dnl {{{
[
if test -n "$slangdir" && test -x $slangdir/bin/slsh ; then
 slsh=$slangdir/bin/slsh
else
  AC_PATH_PROG([slsh],[slsh],[],[/bin /usr/bin /usr/local/bin /opt/local/bin $PATH])
fi
if test -z "$slsh" ; then
   dnl default to using slsh bundled/built with SLIRP/SLgtk
   dnl (requires prior invocation of JD_INIT)
   slsh=$CONFIG_DIR/slsh
fi
AC_SUBST(slsh)
]) dnl }}}

AC_DEFUN(AC_GTK_HEADERS_ROOT, dnl {{{
[
GTK_HEADERS_ROOT=""
dirs_to_check="`echo $GTK_CFLAGS | sed 's/-I//g' ` /usr/include/gtk-2.0 /usr/local/include/gtk-2.0"
for d in $dirs_to_check ; do
    if test -f $d/gtk/gtk.h ; then
       GTK_HEADERS_ROOT=$d
       break
    fi
done

if test -z "$GTK_HEADERS_ROOT" ; then
   AC_MSG_ERROR([could not determine root of Gtk headers directory])
fi
AC_SUBST(GTK_HEADERS_ROOT)
]) dnl }}}

AC_DEFUN(AC_GLIB_HEADERS_ROOT, dnl {{{
[
GLIB_HEADERS_ROOT=""

for d in `echo $GTK_CFLAGS | sed 's/-I//g' ` ; do
    if test -f $d/glib.h ; then
       GLIB_HEADERS_ROOT=$d
       break
    fi
done
if test -z "$GLIB_HEADERS_ROOT" ; then
   AC_MSG_ERROR([could not determine root of GLib headers directory])
fi
AC_SUBST(GLIB_HEADERS_ROOT)
]) dnl }}}

AC_DEFUN(AC_PANGO_HEADERS_ROOT, dnl {{{
[
PANGO_HEADERS_ROOT=""

for d in `echo $GTK_CFLAGS | sed 's/-I//g' ` ; do
    if test -f $d/pango/pango.h ; then
       PANGO_HEADERS_ROOT=$d
       break
    fi
done
if test -z "$PANGO_HEADERS_ROOT" ; then
   AC_MSG_ERROR([could not determine root of Pango headers directory])
fi
AC_SUBST(PANGO_HEADERS_ROOT)
]) dnl }}}

AC_DEFUN(AC_GTKEXTRA_HEADERS_ROOT, dnl {{{
[
dnl   As of v0.20 selected portions GtkExtra are now bundled with SLgtk.
GTKEXTRA_HEADERS_ROOT=$CONFIG_DIR/src
build_gtkextra=true,
GTK_CFLAGS="$GTK_CFLAGS -I$GTKEXTRA_HEADERS_ROOT -DHAVE_GTKEXTRA"
AC_SUBST(build_gtkextra)
AC_SUBST(GTKEXTRA_HEADERS_ROOT)
]) dnl }}}

AC_DEFUN(AC_GTK_LIB_ROOT, dnl {{{
[

# These rules are getting stupid.  I really ought to 
# learn libtool and clean up my configure mechanism.

AC_ARG_ENABLE(rpath,
[  --disable-rpath         do not hardcode into module the runtime lib paths
                          from build (caller may instead use $LD_LIBRARY_PATH,
                          or equivalent, at runtime)],
     :, enable_rpath=yes)

if test $enable_rpath = "yes" ; then
   GTK_LIB_ROOT=""
   dirs="`echo $GTK_LIBS | sed 's/-L//g'` /usr/lib /usr/local/lib /usr/bin"
   for d in $dirs ; do
    if test -f $d/*gtk-${gdktarget}-2.0${sh_ext} ; then
       GTK_LIB_ROOT=$d
       break;
    fi
   done
   if test -z "$GTK_LIB_ROOT" ; then
	AC_MSG_ERROR([could not determine root of Gtk libraries directory
                  (try using --disable-rpath option to omit this test)])
   fi
   AC_SUBST(GTK_LIB_ROOT)
   JD_SET_RPATH($GTK_LIB_ROOT)
fi
]) dnl }}}

AC_DEFUN(AC_GET_DATE, dnl {{{
[
AC_PATH_PROG([DATE],[date],[],[/bin /usr/bin /usr/local/bin $PATH])
if test -n "$DATE" ; then
   date=`${DATE}`
else
   date=unknown
fi
AC_SUBST(date)
]) dnl }}}


AC_DEFUN(AC_SLGTK_INIT, dnl {{{
[

gtk_major_ver="gtk+-2.0"
AC_GET_DATE
AC_WITH_PKGCONFIG

if $PKG_CONFIG --exists $gtk_major_ver '<' 2.2 ; then
    have=`$PKG_CONFIG --modversion $gtk_major_ver`
    AC_MSG_ERROR([
    Gtk version 2.2 or higher is required.  You have Gtk ${have}.])
fi

AC_ARG_WITH(gtk-static,
	[
  --with-gtk-static=DIR		 Like $prefix, except pointing to a tree
   				 containing static libraries generated from
				 a Gtk distribution configured and built with
				 the --enable-static, --with-included-loaders,
				 and --disable-modules options.
				 (Default: $prefix, which may be quite wrong!)],
	[gtk_static_root=$withval],
	[gtk_static_root=$prefix])

if test "$GCC" = yes ; then
   static_link_flag="-Wl,-Bstatic"
else
   static_link_flag="-Bstatic"
fi

GTK_CFLAGS=`$PKG_CONFIG --cflags $gtk_major_ver`
if test -z "$GTK_CFLAGS" ; then
    AC_MSG_ERROR([could not find pkg-config info for $gtk_major_ver])
fi
GTK_LIBS=`$PKG_CONFIG --libs $gtk_major_ver`
GTK_LIBS_STATIC="$static_link_flag `PKG_CONFIG_PATH=$gtk_static_root/lib/pkgconfig; export PKG_CONFIG_PATH; $PKG_CONFIG --libs $gtk_major_ver` $BINDIST_LIB_HACK"
GDK_PIXBUF_CFLAGS=`$PKG_CONFIG --cflags gdk-pixbuf-2.0`
GDK_PIXBUF_LIBS=`$PKG_CONFIG --libs gdk-pixbuf-2.0`
AC_PATH_PROG(GDK_PIXBUF_QUERYLOADERS, gdk-pixbuf-query-loaders, true)

GTK_VERSION=`$PKG_CONFIG --modversion $gtk_major_ver`
GTK_BINARY_VERSION=`$PKG_CONFIG --variable=gtk_binary_version $gtk_major_ver`

AC_GTK_HEADERS_ROOT
AC_GLIB_HEADERS_ROOT
AC_PANGO_HEADERS_ROOT
AC_GTKEXTRA_HEADERS_ROOT
AC_GTK_LIB_ROOT

SLGTK_MAJOR_VERSION=`cat VERSION | cut -d. -f1`
SLGTK_MINOR_VERSION=`cat VERSION | cut -d. -f2`
SLGTK_MICRO_VERSION=`cat VERSION | cut -d. -f3`

ELF_MAJOR_VERSION=$SLGTK_MAJOR_VERSION
ELF_MINOR_VERSION=${SLGTK_MINOR_VERSION}.${SLGTK_MICRO_VERSION}

dnl The following two versions conform with the S-Lang modules convention
SLGTK_VERSION_STRING=${SLGTK_MAJOR_VERSION}.${SLGTK_MINOR_VERSION}.${SLGTK_MICRO_VERSION}
SLGTK_VERSION=`expr \( 10000 \* $SLGTK_MAJOR_VERSION \) + \( 100 \* $SLGTK_MINOR_VERSION \) + $SLGTK_MICRO_VERSION`

test "x$prefix" = "xNONE" && prefix="$ac_default_prefix"
SLGTK_DOC_DIR="$prefix/doc/slgtk"
AC_DEFINE_UNQUOTED(SLGTK_DOC_DIR,"$SLGTK_DOC_DIR")

if test -n "$SLGTK_DEVEL_BUILD" ; then
   SLGTK_DEVEL_BUILD=true
   gtk_src_root=/nfs/cxc/a1/opt/src/gtk
   glib_src_root=/nfs/cxc/a1/opt/src/glib
fi

AC_SUBST(gtk_static_root)
AC_SUBST(static_link_flag)
AC_SUBST(gtk_src_root)
AC_SUBST(glib_src_root)

AC_SUBST(GTK_CFLAGS)
AC_SUBST(GTK_LIBS)
AC_SUBST(GTK_LIBS_STATIC)
AC_SUBST(GTK_VERSION)
AC_SUBST(GDK_PIXBUF_CFLAGS)
AC_SUBST(GDK_PIXBUF_LIBS)
AC_SUBST(GTK_BINARY_VERSION)
AC_SUBST(ELF_MAJOR_VERSION)
AC_SUBST(ELF_MINOR_VERSION)

AC_SUBST(SLGTK_DOC_DIR)
AC_SUBST(SLGTK_DEVEL_BUILD)

AC_SUBST(SLGTK_VERSION)
AC_SUBST(SLGTK_VERSION_STRING)
AC_SUBST(SLGTK_MAJOR_VERSION)
AC_SUBST(SLGTK_MINOR_VERSION)
AC_SUBST(SLGTK_MICRO_VERSION)

AC_DEFINE_UNQUOTED(SLGTK_MAJOR_VERSION,$SLGTK_MAJOR_VERSION)
AC_DEFINE_UNQUOTED(SLGTK_MINOR_VERSION,$SLGTK_MINOR_VERSION)
AC_DEFINE_UNQUOTED(SLGTK_MICRO_VERSION,$SLGTK_MICRO_VERSION)
AC_DEFINE_UNQUOTED(SLGTK_VERSION,$SLGTK_VERSION)
AC_DEFINE_UNQUOTED(SLGTK_VERSION_STRING,"$SLGTK_VERSION_STRING")

GTK_MODULE_NAME=gtk-module.so
GTKX_MODULE_NAME=gtkextra-module.so
STATIC_MODULE_NAME=gtk-module-static.so
AC_SUBST(GTK_MODULE_NAME)
AC_SUBST(GTKX_MODULE_NAME)
AC_SUBST(STATIC_MODULE_NAME)
]) dnl }}}

AC_DEFUN(APPEND_TO_HEADER_LIST, dnl {{{
[
   THESE_HEADERS=""
   for entry in ` sed '/^#/d' $2 ` ; do
	THESE_HEADERS="${THESE_HEADERS} $1/$entry"
   done
   CODEG_HEADERS="$CODEG_HEADERS $THESE_HEADERS"
]) dnl }}}

AC_DEFUN(GENERATE_HEADERS_LIST, dnl {{{
[
APPEND_TO_HEADER_LIST( $GLIB_HEADERS_ROOT/gobject, src/gobject.lst)
APPEND_TO_HEADER_LIST( $GLIB_HEADERS_ROOT/glib, src/glib.lst)
APPEND_TO_HEADER_LIST( $GTK_HEADERS_ROOT/gdk, src/gdk.lst)
APPEND_TO_HEADER_LIST( $GTK_HEADERS_ROOT/gtk, src/gtk.lst)
APPEND_TO_HEADER_LIST( $GTK_HEADERS_ROOT/gdk-pixbuf, src/gdk_pixbuf.lst)
APPEND_TO_HEADER_LIST( $PANGO_HEADERS_ROOT/pango, src/pango.lst)
echo "GTK_HEADERS = $CODEG_HEADERS" >> src/Makefile

CODEG_HEADERS=""
if test -s "$GTKEXTRA_HEADERS_ROOT" ; then
   APPEND_TO_HEADER_LIST($GTKEXTRA_HEADERS_ROOT/gtkextra, src/gtkplot.lst)
fi
echo "GTKX_HEADERS = $CODEG_HEADERS" >> src/Makefile
]) dnl }}}
