%  vwprefs.sl: this file is part of the VWhere SLgtk guilet {{{
%
%  Copyright (C) 2003-2005 Massachusetts Institute of Technology
%  Copyright (C) 2002 Michael S. Noble <mnoble@space.mit.edu>
% 
%  }}}

% Defaults {{{
static variable default_fgcolor  = @gdk_red;	% These persist via ~/.vwhererc
static variable default_bgcolor  = @gdk_grey;
static variable default_fgstyle  = GTK_PLOT_CONNECT_NONE;
static variable default_bgstyle  = GTK_PLOT_CONNECT_NONE;
static variable default_sym      = GTK_PLOT_SYMBOL_CIRCLE;
static variable default_symstyle = GTK_PLOT_SYMBOL_FILLED;
static variable default_symsize  = 3;
static variable default_align	 = 0;

static variable default_combine = 0;
static variable default_incrfilt = 1;
static variable default_drawbg = 1;
static variable default_fullrange = 1;

static variable Filter_Prefs = NULL;

static variable vwhere_rc = getenv("HOME");
if (vwhere_rc == NULL) vwhere_rc = "";
vwhere_rc = path_concat(vwhere_rc, ".vwhererc");

private define load_defaults(vwd)
{
   if (stat_file(vwhere_rc) == NULL)
	return;

   ERROR_BLOCK { _clear_error(); _toggle_error_hook(); }

   echo_status(vwd, sprintf("Loading defaults from: %s",vwhere_rc));
   _toggle_error_hook();
   () = evalfile(vwhere_rc, vw_private_ns);
   _toggle_error_hook();
}

define set_gdkcolor(color_struct, pixel, red, green, blue)
{
   color_struct.red = red;
   color_struct.green = green;
   color_struct.blue = blue;
   color_struct.pixel = pixel;
}

private define copy_gdkcolor(c1, c2)
{
   set_gdkcolor(c2, c1.pixel, c1.red, c1.green, c1.blue);
}

private define write_gdkcolor(name, fp)
{
   eval(name + ";", vw_private_ns);
   variable color = ();
   variable nfields = _push_struct_field_values(color);
   _stk_reverse(nfields);
   color = __pop_args(nfields);
   variable line = sprintf("set_gdkcolor(%s, %d, %d, %d, %d);\n", name,
							__push_args(color));
   () = fputs(line, fp);
}

private define write_int(name, value, fp)
{
   () = fputs(sprintf("%s = %d;\n", name, value), fp);
}

private define save_defaults(pprefs, fprefs)
{
   copy_gdkcolor(pprefs.fgcolor.value, default_fgcolor);
   copy_gdkcolor(pprefs.bgcolor.value, default_bgcolor);

   variable symbol = pprefs.sym.value, style = pprefs.symstyle.value;
   % Default symbol of dot is too small, so turn it into filled circle
   if (symbol == GTK_PLOT_SYMBOL_DOT) {
      symbol = GTK_PLOT_SYMBOL_CIRCLE;
      style  = GTK_PLOT_SYMBOL_FILLED;
   }
   default_sym = symbol;
   default_symstyle = style;
   default_symsize = pprefs.symsize.value;
   default_fgstyle = pprefs.fgstyle.value;
   default_bgstyle = pprefs.bgstyle.value;
   default_align = pprefs.align.value;

   default_combine = fprefs.combine.value;
   default_incrfilt = fprefs.incrfilt.value;
   default_drawbg = fprefs.drawbg.value;
   default_fullrange = fprefs.fullrange.value;

   variable fp = fopen(vwhere_rc,"w+");
   if (fp == NULL) return;

   % Keep these 5 first, for compability with older vwhere versions
   write_gdkcolor("default_fgcolor", fp);
   write_gdkcolor("default_bgcolor", fp);
   write_int("default_sym", default_sym, fp);
   write_int("default_symstyle", default_symstyle, fp);
   write_int("default_symsize", default_symsize,fp);

   () = fputs("#ifeval _vwhere_version > 100205\n", fp);
   write_int("default_combine", default_combine, fp);
   write_int("default_fgstyle", default_fgstyle, fp);
   write_int("default_bgstyle", default_bgstyle, fp);
   write_int("default_incrfilt", default_incrfilt, fp);
   write_int("default_drawbg", default_drawbg, fp);
   write_int("default_fullrange", default_fullrange, fp);
   write_int("default_align", default_align, fp);
   () = fputs("#endif\n", fp);
}
% }}}

% Filter preferences {{{

private variable YesNo = [ "NO", "YES"];
private variable FilterPrefs = struct {

	combine,			% Boolean, determins how filters on
					% multiple plot panes are combined

	incrfilt,			% Indicates whether region sets from
					% existing plots will be applied as
					% filters when creating new plots

	drawbg,				% Should filtered points (background)
					% be drawn or not?  The former is
					% useful, the latter can be faster.

	fullrange			% Indicates whether plot axes should
					% reflect range of entire x/y vectors,
					% or just ranges of filtered vectors
};

define filter_prefs_new(vwd)
{
   variable fp = Filter_Prefs;
   if (fp == NULL) {

	load_defaults(vwd);

	% These preferences persist across multiple invocations w/in a process
	fp = @FilterPrefs;
	Filter_Prefs = fp;

	fp.combine = _pref_new("Combine filters from distinct plots by ",
				["INTERSECTION","UNION"], default_combine);

	fp.incrfilt = _pref_new("Apply filters incrementally to new plots?",
				YesNo, default_incrfilt);

	fp.drawbg = _pref_new("Draw background (filtered) points?",
				YesNo, default_drawbg);

	fp.fullrange = _pref_new("Retain full axes ranges when not drawing "+
				"background?", YesNo, default_fullrange);
   }

   if (vwd.veclen > 10000) {
	% smaller, less color: faster for visualizing plots with more points
	default_sym	 = GTK_PLOT_SYMBOL_DOT;
	default_symstyle = GTK_PLOT_SYMBOL_EMPTY;
	default_symsize  = 2;
   }

   _gtk_plot_set_symbol_defaults(default_sym, default_fgcolor,
					default_symsize, default_symstyle);
   return fp;
}
% }}}

% Plot Preferences  {{{

private variable PlotPrefs = struct {

	fgcolor,			% foreground (selected pts) sym color
	bgcolor,			% background (filtered pts) sym color

	fgstyle,			% foreground line style
	bgstyle,			% background line style

	sym,				% symbol type, size, style
	symstyle,
	symsize,

	tooltips,			% popup help
	apply_button,
	save_button,

	align,				% Indicates whether drawing routines
					% will align the fgnd and bkgd plots,
					% by using the same line style for
					% both, and overlaying fgnd onto bkgd
};

define plot_prefs_new()
{
   variable pp = @PlotPrefs;

   pp.fgcolor	= _pref_new_from_func("Foreground symbol color ",
		@default_fgcolor, &gdk_color_equal, &_color_button_new);
	   
   pp.bgcolor	= _pref_new_from_func("Background symbol color ",
		@default_bgcolor, &gdk_color_equal, &_color_button_new);

   pp.sym	= _pref_new("Symbol", _gtk_plot_symbols, default_sym);
   pp.symstyle	= _pref_new("Symbol style", _gtk_plot_symbolstyles,
   							default_symstyle);
   pp.symsize	= _pref_new("Symbol size", _gtk_plot_symbolsizes,
   							default_symsize);

   pp.align = _pref_new("Align background line to foreground?", YesNo,
   							default_align);

   pp.fgstyle = _pref_new("Foreground line style", _gtk_plot_linestyles,
	 						default_fgstyle);

   pp.bgstyle = _pref_new("Background line style", _gtk_plot_linestyles,
	 						default_bgstyle);
   return pp;
}
% }}}

% Reset, Cancel, and Sensitity methods {{{
private define resync_plot_prefs(prefs, revert)
{
   _pref_sync(prefs.align,revert);
   _pref_sync(prefs.sym,revert);
   _pref_sync(prefs.symsize,revert);
   _pref_sync(prefs.symstyle,revert);
   _pref_sync(prefs.fgcolor,revert);
   _pref_sync(prefs.bgcolor,revert);
}

private define resync_filter_prefs(prefs, revert)
{
   _pref_sync(prefs.combine,revert);
   _pref_sync(prefs.incrfilt,revert);
   _pref_sync(prefs.drawbg,revert);
   _pref_sync(prefs.fullrange,revert);
}

private define prefs_cancel(win,vwd)
{
   _pref_unset_callback_hook();
   resync_plot_prefs(vwd.filtd.prefs, 1);
   resync_filter_prefs(vwd.fprefs, 1);
   gtk_widget_destroy(win);
}

private define set_backgd_prefs_sensitivity(prefs,sensitive,set_color,set_align)
{
   if (prefs.align.value)
	% Prohibit changes to background line style when fg/bg are aligned
	gtk_widget_set_sensitive(prefs.bgstyle.widget,FALSE);
   else
	gtk_widget_set_sensitive(prefs.bgstyle.widget,sensitive);

   if (set_color)
	gtk_widget_set_sensitive(prefs.bgcolor.widget,sensitive);

   if (set_align)
	gtk_widget_set_sensitive(prefs.align.widget,sensitive);
}
% }}}

% Apply methods {{{
private define apply_linestyle(vwd, dataset, style, redraw_status)
{
   variable pp = vwd.filtd.prefs;		% grab plot preferences
   if (style.dirty) {

	gtk_plot_data_set_connector(dataset.widget,style.value);
	@redraw_status = 1;

	% When aligned, ensure background style matches foreground
	variable plotd = vwd.filtd.plotd;
	if (pp.align.value)
	   gtk_plot_data_set_connector(plotd.dsets[0].widget,style.value);
   }
   _pref_sync(style,0);
}

private define apply_align(vwd, redraw_status)
{
   variable pp = vwd.filtd.prefs;		% prefs for this plot pane
   if (has_background(vwd)) {

	if (pp.align.dirty) {

	   variable plotd = vwd.filtd.plotd;
	   _gtk_plot_remove(plotd,2);		%remove previous fg plot
	   _gtk_plot_remove(plotd,1);		%remove previous bg plot
	   () = (@vwd.point_drawer) (vwd, NULL, NULL);

	   % Allow bkgd line style to change when not aligned with fgnd
	   set_backgd_prefs_sensitivity(pp, not(pp.align.value), 0, 0);
	   @redraw_status = 1;
   	}
   }
   _pref_sync(pp.align,0);
}

private define prefs_save(win, vwd)
{
   variable pp = vwd.filtd.prefs, fp = vwd.fprefs;
   save_defaults(pp, fp);
   gtk_widget_set_sensitive(pp.save_button, FALSE);
}

private define prefs_apply(win, vwd)
{
   variable needs_redraw = 0, reset_symbol = 0;
   variable filtd = vwd.filtd, plotd = filtd.plotd;
   variable pp = filtd.prefs;

   % Change bkgnd style, iff bkgnd exists and not aligned with fgnd
   if (andelse {has_background(vwd)} {not(pp.align.value)})
	apply_linestyle(vwd, plotd.dsets[0], pp.bgstyle, &needs_redraw);

   apply_linestyle(vwd, plotd.dsets[-1], pp.fgstyle, &needs_redraw);

   if (orelse	{pp.symsize.dirty}
		{pp.symstyle.dirty} {pp.sym.dirty} {pp.fgcolor.dirty}) {

   	variable included_points = plotd.dsets[-1];
	_gtk_plot_set_symbol(included_points, pp.sym.value, pp.fgcolor.value,
				pp.symsize.value, pp.symstyle.value);
	needs_redraw = 1;
   }

   if (has_background(vwd)) {
   	variable excluded_points = plotd.dsets[0];
	if (orelse {pp.bgcolor.dirty} {pp.symsize.dirty}) {
	   _gtk_plot_set_symbol(excluded_points, pp.sym.value, pp.bgcolor.value,
	   			pp.symsize.value, pp.symstyle.value);
	   gtk_plot_data_set_line_attributes(excluded_points.widget,
			GTK_PLOT_LINE_SOLID, 0, 0, 1, pp.bgcolor.value);

	   needs_redraw = 1;
	}
   }

   apply_align(vwd, &needs_redraw);
   resync_plot_prefs(pp,0);
   resync_filter_prefs(vwd.fprefs, 0);

   if (needs_redraw)
	_gtk_plot_redraw(plotd);

   gtk_widget_set_sensitive(pp.apply_button, FALSE);
}

private define apply_popup_selection(vwd)
{
   variable plotd = vwd.filtd.plotd, needs_redraw = 0;
   variable pp = vwd.filtd.prefs;			% plot preferences

   apply_align(vwd,&needs_redraw);

   if (andelse {has_background(vwd)} {not(pp.align.value)})
	apply_linestyle(vwd,plotd.dsets[0],pp.bgstyle,&needs_redraw);
   else
	_pref_sync(pp.bgstyle,0);

   apply_linestyle(vwd,plotd.dsets[-1],pp.fgstyle,&needs_redraw);

   if (needs_redraw)
	_gtk_plot_redraw(plotd);
}
% }}}

% Widgets and windows {{{
define prefs_select_mini(vwd)
{
   variable unfiltered = not(has_background(vwd)), menu1, menu2, item;
   variable pp = vwd.filtd.prefs;		% current plot preferences

   variable popup = gtk_menu_new();
   () = g_signal_connect_swapped(popup,"unmap",&apply_popup_selection,vwd);

   item = gtk_menu_item_new_with_label("Foreground line style");
   gtk_menu_item_set_submenu(item, _pref_steal_menu(pp.fgstyle));
   gtk_menu_shell_append(popup,item);

   item = gtk_menu_item_new_with_label("Background line style");
   gtk_menu_item_set_submenu(item, _pref_steal_menu(pp.bgstyle));
   gtk_menu_shell_append(popup,item);
   if (unfiltered or pp.align.value) gtk_widget_set_sensitive(item,FALSE);

   item = gtk_menu_item_new_with_label("Align fore/background?");
   gtk_menu_item_set_submenu(item, _pref_steal_menu(pp.align));
   gtk_menu_shell_append(popup,item);
   if (unfiltered) gtk_widget_set_sensitive(item,FALSE);

   gtk_widget_show_all(popup);
   gtk_menu_popup(popup,1,gtk_get_current_event_time());
}

private define make_plot_prefs_pane(prefs, title, notebook)
{
   variable vbox = gtk_vbox_new(TRUE,5);
   gtk_container_add(vbox,prefs.fgstyle.widget);
   gtk_container_add(vbox,prefs.fgcolor.widget);
   gtk_container_add(vbox,prefs.bgstyle.widget);
   gtk_container_add(vbox,prefs.bgcolor.widget);
   gtk_container_add(vbox,prefs.align.widget);
   gtk_container_add(vbox,prefs.sym.widget);
   gtk_container_add(vbox,prefs.symstyle.widget);
   gtk_container_add(vbox,prefs.symsize.widget);
   gtk_notebook_append_page(notebook,vbox,gtk_label_new(title));
   if (_gtk_version >= 20400) pop;
}

private define prefs_switch(notebook, notebook_page_dummy, which, dialog, vwd)
{
   variable plot_prefs = vwd.filtd.prefs;
   if (which == 0)
	gtk_tooltips_enable(plot_prefs.tooltips);
   else
	gtk_tooltips_disable(plot_prefs.tooltips);
}

private define pref_modified(pref,  plot_prefs)
{
   if (pref.dirty) {
      gtk_widget_set_sensitive(plot_prefs.apply_button, TRUE);
      gtk_widget_set_sensitive(plot_prefs.save_button, TRUE);
   }
}

define prefs_select_full(vwd)
{
   variable win = gtk_dialog_new();
   gtk_window_set_title(win,"VWhere Preferences");
   gtk_container_set_border_width(win,10);
   gtk_window_resize(win,300,180);
   gtk_window_set_modal(win,TRUE);
   gtk_window_set_resizable(win,FALSE);

   variable pprefs = vwd.filtd.prefs;		% plot prefs
   variable fprefs = vwd.fprefs;		% filter prefs

   variable win_vbox = gtk_dialog_get_vbox(win);
   variable notebook = gtk_notebook_new();
   gtk_notebook_set_tab_pos(notebook,GTK_POS_TOP);
   gtk_box_pack_start(win_vbox,notebook,FALSE,FALSE,0);

   make_plot_prefs_pane(pprefs,"Plotting",notebook);
   _pref_set_callback_hook(&pref_modified, pprefs);
 
   variable vbox = gtk_vbox_new(TRUE,5);
   gtk_notebook_append_page(notebook,vbox,gtk_label_new("Filtering"));
   if (_gtk_version >= 20400) pop;
   () = g_signal_connect(notebook, "switch_page", &prefs_switch, win, vwd);

   gtk_box_pack_start(vbox,fprefs.combine.widget,FALSE,FALSE,0);
   gtk_box_pack_start(vbox,fprefs.incrfilt.widget,FALSE,FALSE,0);
   gtk_box_pack_start(vbox,fprefs.drawbg.widget,FALSE,FALSE,0);
   gtk_box_pack_start(vbox,fprefs.fullrange.widget,FALSE,FALSE,0);

   variable ttips = gtk_tooltips_new();
   variable b = gtk_dialog_add_button(win,"Apply",0);
   () = g_signal_connect_swapped(b,"clicked",&prefs_apply, win, vwd);
   gtk_tooltips_set_tip (ttips,b,"Apply preferences to current plot","");
   gtk_widget_set_sensitive(b, FALSE);
   pprefs.apply_button = b;

   b = gtk_dialog_add_button(win,"Save",1);
   () = g_signal_connect_swapped(b,"clicked",&prefs_save, win, vwd);
   gtk_tooltips_set_tip (ttips,b,"Set default preferences for new plots","");
   gtk_widget_set_sensitive(b, FALSE);
   pprefs.save_button = b;

   b = gtk_dialog_add_button(win,"Done", 2);
   () = g_signal_connect_swapped(b,"clicked",&prefs_cancel,win,vwd);
   gtk_tooltips_set_tip(ttips,b,"Exit, reverting any unsaved or "+
							"unapplied changes","");
   pprefs.tooltips = ttips;
   gtk_widget_show_all(win);
}
% }}}
