/* -*- mode: C; mode: fold; -*- */

/* SLgtk:  S-Lang bindings for GTK+ widget set
 *
 * Copyright (C) 2003 Massachusetts Institute of Technology 
 * Copyright (C) 2002 Michael S. Noble <mnoble@space.mit.edu>
 *
 * This software was partially developed by the MIT Center for Space
 * Research under contract SV1-61010 from the Smithsonian Institution.
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * the supporting documentation, and that the name of the Massachusetts
 * Institute of Technology not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  The Massachusetts Institute of Technology makes
 * no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 * 
 * THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE MASSACHUSETTS
 * INSTITUTE OF TECHNOLOGY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkwindow.h>
#include "module.h"

#ifdef SLGTK_STATIC_MODULE
static char statically_compiled[] = "SLGTK_STATIC_MODULE";
#endif

int usage_err(int expected_nargs, const char *usage_str)
{
   if (SLang_Num_Function_Args < expected_nargs) {
	char msg[257];
	int npop = SLstack_depth();
	if (npop > SLang_Num_Function_Args) npop = SLang_Num_Function_Args;
	SLdo_pop_n(npop);
	snprintf(msg,248,"Usage: %s",usage_str);
	SLang_verror(SL_USAGE_ERROR,msg);
	return -1;
   }
   return 0;
}

void error_terminate_main_loop(char* cause)
{
   GtkWidget *focus;
   GList *windows;
   const char* problem =
	"SLgtk Error: unrecoverable S-Lang error, quitting main loop\n";
   static unsigned char previously_reported;

   /* This routine s/b called when SLgtk detects a fatal S-Lang error,  */
   /* to bring down GUI windows and ensure the app does not hang.  Note */
   /* that this DOES NOT MEAN the app MUST exit, since gtk_main() calls */
   /* can be nested. */

   if (cause == NULL)
      cause = "unknown";

   if (gtk_main_level() == 0) {
	if (previously_reported == 0)
	   SLang_verror(SLang_get_error(),(char*)problem);
	previously_reported++;
	return;
   }

   fprintf(stderr, problem);
   fprintf(stderr,"Cause: %s\n",cause);
   fflush (stderr);

   SLang_restart(0);
   SLang_set_error(0);
   previously_reported = 0;

   windows = gtk_window_list_toplevels();
   /* !!! Unclear if g_list_foreach (windows,(GFunc)g_object_ref,NULL) */
   /* is needed here (as advocated by docs) since we should be exiting */

   while (windows) {
        focus = gtk_window_get_focus(GTK_WINDOW(windows->data));
	if (focus != NULL && GTK_WIDGET_HAS_FOCUS(focus)) {
	   gtk_object_destroy(GTK_OBJECT(windows->data));
	   break;
	}
	windows = windows->next;
   }

   g_list_free(windows);
   if (gtk_main_level() > 0)
      gtk_main_quit();
}


void free_malloced_string_array (char **strs, unsigned int n)
{
   unsigned int i;
   
   if (strs == NULL)
     return;

   for (i = 0; i < n; i++)
     {
	if (strs[i] != NULL)
	  SLfree (strs[i]);
	i++;
     }
   
   SLfree ((char *) strs);
}


int pop_key_val_pairs (unsigned int n, char ***keysp, char ***valsp)
{
   char **keys, **vals;
   unsigned int i;
   unsigned int buflen;

   *keysp = *valsp = NULL;

   buflen = (n+1) * sizeof (char *);

   keys = (char **) SLmalloc (buflen);
   if (keys == NULL)
     return -1;

   vals = (char **) SLmalloc (buflen);
   if (vals == NULL)
     return -1;
   
   memset ((char *) keys, 0, buflen);
   memset ((char *) vals, 0, buflen);

   i = n;
   while (i != 0)
     {
	char *keyval;
	char *equals;

	i--;
	if (-1 == SLang_pop_slstring (&keyval))
	  goto return_error;
	
	if (NULL == (equals = strchr (keyval, '=')))
	  equals = keyval + strlen (keyval);
	else 
	if (NULL == (keys[i] = SLmake_nstring (keyval, equals - keyval)))
	  {
	     SLang_free_slstring (keyval);
	     goto return_error;
	  }
	if (*equals) equals++;
	
	if (NULL == (vals[i] = SLmake_string (equals)))
	  {
	     SLang_free_slstring (keyval);
	     goto return_error;
	  }
	
	SLang_free_slstring (keyval);
     }
   
   *keysp = keys;
   *valsp = vals;
   return 0;

   return_error:
   free_malloced_string_array (keys, n);
   free_malloced_string_array (vals, n);
   return -1;
}

void patch_ftable (SLang_Intrin_Fun_Type *f, SLtype dummy, SLtype actual)
{
   while (f->name != NULL) {		/* Reset intrinsic function table */
					/* entries containing types that  */
	unsigned int i, nargs;		/* will be registered @runtime.   */
	SLtype	*args;			/* These types are given dummy    */
					/* SLtype ids @compile time, and  */
	nargs = f->num_args;		/* are then reset here once the   */
	args = f->arg_types;		/* new type has been registered.  */

	for (i = 0; i < nargs; i++) {
	    if (args[i] == dummy)
		args[i] = actual;
	}
	
	if (f->return_type == dummy) f->return_type = actual;
	f++;
   }
}
