static variable timer;
static variable count;
static variable window = NULL;

define timeout_test (label)
{
   count++;
   gtk_label_set_text (label, sprintf ("count: %d", count));
   return TRUE;
}

define start_timeout_test (widget, label)
{
  !if (timer)
	timer = gtk_timeout_add (100, &timeout_test, label);
}

define stop_timeout_test (widget, data)
{
   !if (timer)
 	return;
   gtk_timeout_remove (timer);
   timer = 0;
}

define destroy_timeout_test (widget, window)
{
   stop_timeout_test (NULL, NULL);
   @window = NULL;
}

define create_timeout(test)
{
  if (window == NULL) {

	timer = 0; count = 0;
	window = gtk_dialog_new ();
	gtk_window_set_title (window, "Timeout Test");
	gtk_container_set_border_width ( window, 0);
	() = g_signal_connect (window,"destroy",&destroy_timeout_test,&window);
	variable aarea =  gtk_dialog_get_action_area(window);

	variable label = gtk_label_new ("count: 0");
	gtk_misc_set_padding (label, 10, 10);
	gtk_box_pack_start (gtk_dialog_get_vbox(window), label, TRUE, TRUE, 0);

	variable button = gtk_button_new_with_label ("close");
	() = g_signal_connect_swapped(button,"clicked",
				      &gtk_widget_destroy, window);
	gtk_box_pack_start (aarea, button, TRUE, TRUE, 0);
	test.lower = button;

	button = gtk_button_new_with_label ("start");
	() = g_signal_connect (button, "clicked", &start_timeout_test, label);
	gtk_box_pack_start (aarea, button, TRUE, TRUE, 0);

	button = gtk_button_new_with_label ("stop");
	() = g_signal_connect (button, "clicked", &stop_timeout_test, NULL);
	gtk_box_pack_start (aarea, button, TRUE, TRUE, 0);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
