#!/usr/bin/env slsh
% -*- slang -*-

_auto_declare=1;
_debug_info = 1;

if (__argc < 2)
{
   () = fprintf (stderr,"Usage: %s *.defs \n",__argv[0]);
   exit (1);
}

preproc_activate();
require("slirpmaps");
require("slirputils");
SC.rcfile = "./slirprc-gtk.sl";

%-------------------------------------------------------------------------
%  Gtk .defs file processing functions
%-------------------------------------------------------------------------

define open_defs_block(fp) { return open_block(fp,'('); }

define start_arg_block(fp)
{
   !if (open_defs_block(fp)) 
      return 0;
  
   variable args = get_token(fp);
   if (args != "parameters") {
      backup(fp, strlen(args)+2);
      return 0;
   }
   return 1;
}

define start_fields_block(line,fp)
{
   !if (open_defs_block(fp))
      return 0;

   variable fields = get_token(fp);
   if (fields != "fields") {
      backup(fp, strlen(fields)+1);
      return 0;
   }
   return 1;
}

define start_values_block(fp)
{
   !if (open_defs_block(fp))
	malformed_error("Scheme definition block open");
   if (get_token(fp) != "values") 
	malformed_error("Scheme values token");
}

define more_attributes(fp)
{
   variable l,next_char;

   while (1) {
	eat_white(fp);
	next_char = get_char(fp);
	if (next_char == DEFS_COMMENT_CHAR)
	   () = get_line(fp,0);
	else
	   break;
   }

   if (next_char  == '\'')
	return 1;

   backup(fp, 1);
   return 0;
}

define close_defs_block(fp) { close_block(fp,')'); }

define skip_defs_block(fp)
{
   if (open_defs_block(fp)) {
	while (get_char(fp) != ')')
	   ;
	return 1;
   }
   return 0;
}

define extract_defs_value(fp)
{
   % !!! This is a simple and not terribly forgiving scheme
   variable val = strtrim(get_line(fp,0));
   return extract_element(val,3,'"');
}

define close_define_block(fp)	{ close_defs_block(fp); }
define close_arg_block(fp) 	{ close_defs_block(fp); }
define close_fields_block(fp)	{ close_defs_block(fp); }
define more_args(fp)		{ return more_attributes(fp); }
define more_defs_values(fp)	{ return more_attributes(fp); }

define extract_arg(fp)
{
   variable lparens = 1, arg = "";
   variable ch = get_char(fp);			% swallow open paren

   do {
   	ch = get_char(fp);

	switch(ch)
	   { case '(' : lparens++; }
	   { case ')' : lparens--; }

	arg = strcat(arg,char(ch));

   } while (lparens);

   return (arg[[:-2]]);
}

variable object_field_accessors = Assoc_Type[Any_Type,NULL];

object_field_accessors["GtkDialog"] = "GTK_DIALOG";
object_field_accessors["GtkSpinButton"] = "GTK_SPIN_BUTTON";
object_field_accessors["GtkFileSelection"] = "GTK_FILE_SELECTION";
object_field_accessors["GtkToggleButton"] = "GTK_TOGGLE_BUTTON";
object_field_accessors["GtkColorSelectionDialog"] = 
					"GTK_COLOR_SELECTION_DIALOG";
object_field_accessors["GtkFontSelectionDialog"] = 
					"GTK_FONT_SELECTION_DIALOG";
object_field_accessors["GdkVisual"] = "GDK_VISUAL";


() = printf("\n/* auto-generated by scandefs.sl: DO NOT EDIT! */\n");

define emit_object_field_accessor(object_name,field_type_and_name)
{
   % This function emits glue code (and intrinsic function table entries)
   % to allow access to the internal fields of selected GtkObject structures.
   % This portion of the generator is careful to emit code ONLY for those
   % fields for which #define macro usage statements like
   %
   %		GTK_<object_name(obj)-><field_name>
   %
   % appear with the Gtk test/sample code.  For example, testgtk.c shows that
   %
   %		GTK_DIALOG(obj)->vbox
   %		GTK_DIALOG(obj)->action_area
   %
   % are legal GTK statements (in the sense that they are not peering into
   % "private" GTK structure fields).  Since direct access to these structure
   % fields is ok (the implied contract being that the GTK library developers
   % are not going to change the field names on us) they have no corresponding
   %
   %		gtk_dialog_get_vbox()
   %		gtk_dialog_get_action_area()
   %
   % accessor functions.  However, since S-Lang (and Python, etc) cannot use
   % access these structure fields in like fashion, we emit code here which
   % achieves the same effect.
   %
   % To avoid multiple passes of the .defs file we emit to BOTH stdout AND 
   % stderr, and redirect each appropriately in the calling Makefile.

   variable cast_macro = object_field_accessors[object_name];
   if (cast_macro == NULL)
      return;			% no-op if object is not on selected list

   variable fields = strtok(field_type_and_name);
   variable name = str_delete_chars(fields[1],"\"");
   variable type = str_delete_chars(fields[0],"\"");
   variable funcname = sprintf("%s_get_%s",strlow(cast_macro),name);
   variable tmap = SC.types[type];

   () = fprintf(stderr,"MAKE_INTRINSIC_1(\"%s\", sl%s, SLANG_VOID_TYPE, O),\n",
							funcname, funcname);

   () = printf("\nstatic void sl%s (%s o)\n{\n   ",
					funcname, SLIRP_OPAQUE_TYPE_NAME);

   if (tmap.typeclass == TYPECL_OPAQUE)
	() = printf("(void) SLang_push_opaque(%s, %s (o->instance)->%s, 0);",
					tmap.aux, cast_macro, name);
   else
	() = printf("(void) SLang_push_%s( %s (o->instance)->%s);",
					tmap.mnemonic, cast_macro, name);
		
   () = printf("\n}\n\n");

}

%-------------------------------------------------------------------------
%  Main Loop
%-------------------------------------------------------------------------

slirp_initialize();

argc = 1;
while (argc < __argc) {

  file = __argv[argc];

  if (NULL == stat_file (file))
  {
	() = fprintf (stderr, "Unable to stat %s\n", file);
	exit (1);
  }

  fp = fopen(file,"r");
  if (fp == NULL)
	exit(1);

  while(1) {

   argno = 0;			% convention: arg lists ones-based, not zero
   objname = "";
   line = get_line(fp,1);

   switch(line) 
   	{case NULL: break;}
   	{case "": continue;}
	{if (line[0] == DEFS_COMMENT_CHAR) continue; }

   % Look for relevant "define blocks"
   % Does not try to be very intelligent - assumes input is well-formed

   fields = strchop(line,' ',0);
   switch (fields[0])

	{ case "(define-object" :

		% Determine the object name, and which Gtk/Gdk module its in
		objname = fields[1];
		line = get_line(fp,0);
		module = extract_element(strtrim(line),1,'"');

		do {
			line = get_line(fp,0);
	     		arg = extract_element(strtrim(line),0,'"');
		} while (not(is_substr(arg,"gtype-id")));


		% Look for Gtk widget fields that are public,
		% and emit a wrapper function for each
		if (start_fields_block(line,fp)) {
		   while (more_args(fp)) {
			   argno++;
			   arg = extract_arg(fp);
			   emit_object_field_accessor(module+objname,arg);
		   }
		   close_fields_block(fp);
		   close_define_block(fp);
		}
	}

	{ 
	   continue;			%don't care/line ignored
	}

   }

  argc++;

}

exit(0);
