private variable master = NULL;

private define change_grav(master, event, slave) % {{{
{
   if (event.keyval == GDK_1)
	_gtk_window_chain(master, slave, 1);
   else if (event.keyval == GDK_2)
	_gtk_window_chain(master, slave, 2);
   else if (event.keyval == GDK_3)
	_gtk_window_chain(master, slave, 3);
   else if (event.keyval == GDK_4)
	_gtk_window_chain(master, slave, 4);

   variable x, y;
   gtk_window_get_position(master, &x, &y);
   gtk_window_move(master, x, y);

   return FALSE;
} % }}}

public define create_chained(test) % {{{
{
   if (master ==  NULL) {

	master = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	gtk_window_set_title(master, "Chained Window Example: master");
	gtk_widget_set_size_request(master, 350, 50);
	() = g_signal_connect (master,"destroy",&gtk_widget_destroyed, &master);

	variable slave = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(slave, "Chained Window Example: slave");

	_gtk_window_chain(master, slave);

	() = g_signal_connect(master, "key_press_event", &change_grav, slave);

	variable label = gtk_label_new("\n"+
		"   Move the master window around and observe  \n"+
		"   how chained slave window follows. Slave may  \n"+
		"   also be moved alone, temporarily stretching  \n"+
		"   the chain.  To permanently break chain, press  \n"+
		"   SHIFT key while moving slave.  Master window  \n"+
		"   gravity may be changed to N/S/E/W by pressing  \n"+
		"   1/2/3/4 while master window has focus."+
		"\n");

	gtk_container_add(slave, label);

	variable button = gtk_button_new_with_label("Quit");
	() = g_signal_connect_swapped(button, "clicked",
						&gtk_widget_destroy, master);

	gtk_container_add(master, button);
	test.lower = button;
   }

   if (gtk_widget_visible(master))
	gtk_widget_destroy(master);
   else {
	gtk_widget_show_all(master);
	gtk_widget_show_all(slave);
   }
} % }}}
