      REAL function rzero(r)
c     Avoid output formatting issues between IEEE positive/negative zero
      real r
      if (r .EQ. 0.0) r = +0.0
      rzero = r
      end

      subroutine qsolve(a, b, c, solution)
c     Solve quadratic equation Ax^2 + Bx + C = 0, returning 2 complex roots
      real a, b, c
c      integer*4 z
      complex solution (                2                          )
      real discrm, v, w
    
      v = rzero( -b / (2*a) )
      discrm = b*b - 4*a*c

      if ( discrm .LT. 0 ) then
        w = rzero( sqrt(-discrm) / (2*a))
        solution(1) = CMPLX(v, w)
        solution(2) = CMPLX(v, -w)
      else
        w = rzero(sqrt(discrm) / (2*a))
        solution(1) = CMPLX(v+w)
        solution(2) = CMPLX(v-w)
      end if

      end

      double COMPLEX function dcmult(a, b)
c     Multiply two double-precision complex numbers
      double complex a, b
      dcmult = a * b
      if (dcmult .EQ. 0.0) dcmult = +0.0
      end

      complex function cmult(a, b)
c     Multiply two single-precision complex numbers
      complex a, b
      cmult = a * b
      if (cmult .EQ. 0.0) cmult = +0.0
      end

      complex function fcadd(a, b)
c     Add two single-precision complex numbers
      complex a, b
      fcadd = a + b
      if (fcadd .EQ. 0.0) fcadd = +0.0
      end

      subroutine ftnprint(message)
c     Simple echo, to exercise the C to FORTRAN path for strings
      character*(*) message
      print 10, message
   10 format(A)
      end

      subroutine strarr(arr)
c     slirp will ignore this, as string arrays are not supported yet
      character*(*) arr(5)
      do i=1,5
        call ftnprint(arr(i))
      enddo
      end

      subroutine sub_multi(a,b,c)
c     this routine acts like a function, and is annotated by the
c     interface file to be wrapped as such (i.e. c is "returned")
      real a, b, c
      c = a * b
      end

c     The remaining content is meant to exercise the parser
      function
     *
     *          rtest
c       random comment interspersed with continuation lines
     * (a)
      implicit none
      real rtest
      integer*2 a
      a = 1
      rtest = 0.0
      end

      double precision function imptest(k, d,h,b, m,t,z)
      implicit character*80 (a-c ,         d)
      implicit integer (e,g-h)
      implicit integer*2 (i,j         -m)
      implicit double precision (n      , o ,q-                 t      )
      imptest = 0.0
      end

        subroutine
     *          continuator
     *          (
     *    arg1,  arg2,                  
     *                  arg_3       , arg4
     *          )
        real * 4 arg1
        real*8 arg2
        character*80 arg_3
        integer*2 arg4
        arg1 = 33.33
        arg2 = 44.44
        arg_3 = 'hello'
        end

      subroutine mmult(a, b, c, nrows, ncols)
      integer i, row, col, nrows, ncols
c     Superfluous array indexing used here to exercise parser
      double precision a(nrows, ncols), b(ncols , 1:nrows )
      double precision c(1:nrows,1:nrows)
      do row=1,nrows
        do col=1,nrows
           c(row,col) = 0
           do i=1,ncols
                c(row,col) = c(row,col) + a(row,i) * b(i,col)
           enddo
        enddo
      enddo
      end
