set_import_module_path( strcat(".", ":", get_import_module_path()));

import("fsubs");
() = evalfile("../examples-common");

check_ignored("rzero");
_try(&imptest);			% emit usage statement to validate code
				% generated with implicitly typed args

_try(&mmult);			% emit usage to validate that FORTRAN
				% array dimensions are parsed correctly

check_ignored("strarr");	% passing of string arrays not supported yet

if (6 != sub_multi(3, 2))	% ensure that sub_multi is usable as a function
   print("ERROR: sub_multi was not properly wrapped/morphed to a function");

% Exercise multidimensional array transposition for FORTRAN calls
variable a = _reshape([1., 2,  3,  4,  5,  6],  [3,2]);
variable b = _reshape([60.,50, 40, 30, 20, 10], [2,3]);
variable c = Double_Type[3,3];

% FIXME: make result of mmult() an OUTPUT arg, and have nrows, ncols args
% transparently elided by DIM1, DIM2 annotations fabricated in slirpf2c
mmult(a,b,c,3,2);
if (array_neqs(c, a # b)) print("mmult failed, fortran transpose problem?");

exit(0);
