static variable event_watcher_enter_id = 0;
static variable event_watcher_leave_id = 0;

define event_watcher (object, signal_id, n_params, params, data)
{
  vmessage ("Watch: \"%s\" emitted for %s\n",
	   gtk_signal_name (signal_id),
	   gtk_type_name (_TYPE (object)));

  return TRUE;
}

define event_watcher_down ()
{
  if (event_watcher_enter_id)
    {
      variable signal_id;

      signal_id = gtk_signal_lookup ("enter_notify_event", GTK_TYPE_WIDGET);
      gtk_signal_remove_emission_hook (signal_id, event_watcher_enter_id);
      event_watcher_enter_id = 0;
      signal_id = gtk_signal_lookup ("leave_notify_event", GTK_TYPE_WIDGET);
      gtk_signal_remove_emission_hook (signal_id, event_watcher_leave_id);
      event_watcher_leave_id = 0;
    }
}

define
event_watcher_toggle ()
{
  if (event_watcher_enter_id)
    event_watcher_down ();
  else
    {
      guint signal_id;

      signal_id = gtk_signal_lookup ("enter_notify_event", GTK_TYPE_WIDGET);
      event_watcher_enter_id = gtk_signal_add_emission_hook (signal_id, event_watcher, NULL);
      signal_id = gtk_signal_lookup ("leave_notify_event", GTK_TYPE_WIDGET);
      event_watcher_leave_id = gtk_signal_add_emission_hook (signal_id, event_watcher, NULL);
    }
}

define
create_event_watcher ()
{
  variable button;

  if (!dialog_window) {

      dialog_window = gtk_dialog_new ();

      () = gtk_signal_connect (dialog_window, "destroy",
				&gtk_widget_destroyed, &dialog_window);

      () = gtk_signal_connect (dialog_window, "destroy",
			   &event_watcher_down, NULL);

      gtk_window_set_title ((dialog_window), "Event Watcher");
      gtk_container_set_border_width ( dialog_window, 0);
      gtk_widget_set_usize (dialog_window, 200, 110);

      button = gtk_toggle_button_new_with_label ("Activate Watch");
      () = gtk_signal_connect (button, "clicked", event_watcher_toggle, NULL);
      gtk_container_set_border_width ( button, 10);
      gtk_box_pack_start (gtk_dialog_get_vbox(dialog_window), 
			  button, TRUE, TRUE, 0);
      gtk_widget_show (button);

      button = gtk_button_new_with_label ("Close");
      () = gtk_signal_connect_object (button, "clicked",
				&gtk_widget_destroy, dialog_window);

      gtk_widget_set_flags (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (gtk_dialog_get_action_area(dialog_window),
			  button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);
    }

  if (gtk_widget_visible (dialog_window))
    gtk_widget_destroy (dialog_window);
  else
    gtk_widget_show (dialog_window);
}
