
% Simple tabbed notebook example in SLgtk (mnoble@space.mit.edu)
% (adaped from similar demo code in Gtk)

require("gtk");

private define rotate(button, cbdata) % {{{
{
   cbdata.tabpos = (cbdata.tabpos + 1) mod 4;
   gtk_notebook_set_tab_pos(cbdata.nb,cbdata.tabpos);
} % }}}

private define switch_page(notebook,nbpage,pagenum,data) % {{{
{
   vmessage("Notebook: page switched to %d",pagenum);
} % }}}

define tabs_example() % {{{
{
   variable win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(win, "Tabbed Notebook Example");
   () = g_signal_connect (win, "destroy", &gtk_main_quit);

   variable main_vbox = gtk_vbox_new(FALSE,10);
   gtk_container_add(win, main_vbox);

   variable pad_vbox = gtk_vbox_new(FALSE, 10);
   gtk_container_set_border_width(pad_vbox, 10);
   gtk_box_pack_start(main_vbox, pad_vbox, TRUE, TRUE, 0);

   variable nb = gtk_notebook_new();
   gtk_notebook_set_tab_pos(nb, GTK_POS_TOP);
   gtk_box_pack_start(pad_vbox, nb, TRUE, TRUE, 0);

   variable i, label, frame;
   for (i=1; i<6; i++) {
	frame = gtk_frame_new(sprintf("Page %d",i));
	gtk_container_set_border_width(frame,10);
	gtk_widget_set_usize( frame, 200, 150);
	label = gtk_label_new(sprintf("Page %d",i));
	gtk_container_add(frame,label);
	label = gtk_label_new(sprintf("Tab %d",i));
	gtk_notebook_append_page(nb, frame, label);
	if (_gtk_version >= 20400) pop;
   }

   variable separator = gtk_hseparator_new();
   gtk_box_pack_start(main_vbox, separator, FALSE, TRUE, 0);

   variable button_box = gtk_hbox_new(FALSE,10);
   gtk_container_set_border_width(button_box, 10);
   gtk_box_pack_start(main_vbox, button_box, FALSE, TRUE, 0);

   variable button = gtk_button_new_with_label("Quit");
   () = g_signal_connect_swapped(button,"clicked", &gtk_widget_destroy, win);
   gtk_box_pack_start(button_box, button, TRUE, TRUE, 0);

   button = gtk_button_new_with_label("Next");
   () = g_signal_connect_swapped(button,"clicked", &gtk_notebook_next_page, nb);
   gtk_box_pack_start(button_box, button, TRUE, TRUE, 0);

   button = gtk_button_new_with_label("Prev");
   () = g_signal_connect_swapped(button,"clicked", &gtk_notebook_prev_page, nb);
   gtk_box_pack_start(button_box, button, TRUE, TRUE, 0);

   () = g_signal_connect(nb, "switch_page", &switch_page, NULL);

   button = gtk_button_new_with_label("Rotate");
   variable callback_data = struct { nb, tabpos};
   callback_data.nb = nb;
   callback_data.tabpos = GTK_POS_TOP;
   () = g_signal_connect(button, "clicked",&rotate, callback_data);
   gtk_box_pack_start(button_box, button, TRUE, TRUE, 0);
   gtk_widget_set_flags(button, GTK_CAN_DEFAULT);
   gtk_widget_grab_default(button);

   gtk_widget_show_all (win);
   gtk_main();
} % }}}

% Defining slsh_main lets GUI be launched immediately when invoked via: {{{
%
%                       slsh tabs.sl
%
% The guilet may also be launched from S-Lang apps with dynamic linking via
%
%	require("tabs");
%	tabs_example;
%
% and variants.

define slsh_main()
{
   tabs_example;
} % }}}

provide("tabs");
