
setup;

% Test 1: by default all frames of an animation are read
file = "frames.gif";
dims = "Array_Type[15]";
im2 = gif_read(file);
if ("$im2"$ != dims)
   error("gif_read($file, 0) failed: should've returned 15 frames in $dims"$);

% Test 2: now selecting a single frame (the first)
dims = "UChar_Type[119,167]";
im = gif_read(file, 1);
if ("$im"$ != dims)
   error("gif_read($file) failed: should've returned 1 frame of $dims"$);

% Test 3: select one frame, near middle of animation
compare(im2[8], gif_read(file, 9));

% Test 4: compare that one frame to raw binary representation
bfile = "frame9.bin";
dims = [119,167];
nelems = int(prod(dims));
nbytes = fread(&im, UChar_Type, nelems, fopen(bfile, "rb"));
if (nbytes != nelems)
   error("Could not read $nelem bytes from $bfile, only $nbytes were read"$);

reshape(im, dims);
compare(im2[8], im);

% Test 5: select multiple frames, but not all
dims = "Array_Type[4]";
im3 = gif_read(file, [2, 5, 7, 11]);
if ("$im3"$ != dims)
   error("gif_read($file, [2,5,7,11]) failed: should've returned $dims"$);

compare(im2[1], im3[0]);
compare(im2[4], im3[1]);
compare(im2[6], im3[2]);
compare(im2[10], im3[3]);

% Test 6: write multiple frames (and read 'em back in for testing)
file = "testanim.gif";
() = remove(file);
gif_write(file, im3);
im4 = gif_read(file, 0);		% verify that 0 = "all frames"
im5 = gif_read(file; delay=&delays);

compare(im4[0], im3[0]);
compare(im4[1], im3[1]);
compare(im4[2], im3[2]);
compare(im4[3], im3[3]);

compare(im4[0], im5[0]);
compare(im4[1], im5[1]);
compare(im4[2], im5[2]);
compare(im4[3], im5[3]);

if (typeof(delays) != UShort_Type || delays != 500)
   error("gif_read($file; delay) fail: delay s/b ushort scalar value of 500"$);

% Test 7: write frames from a list of image arrays, with custom delay values
custom_delays = [2000, 200, 3000];
delays = NULL;
l = { im2[2], im2[8], im2[14] };

() = remove(file);
gif_write(file, l ; delay=custom_delays);

im4 = gif_read(file; delay=&delays);

compare(im4[0], l[0]);
compare(im4[1], l[1]);
compare(im4[2], l[2]);
if (any(delays != custom_delays))
   error("gif_read($file;delay) (list) failed: delay values read != written"$);

% Test 8: similar to last test, but now from an array of image arrays
delays = NULL;
a = Array_Type[3];
a[0] = im2[5]; a[1] = im2[11]; a[2] = im2[13];

() = remove(file);
gif_write(file, a ; delay=custom_delays);

im4 = gif_read(file; delay=&delays);
compare(im4[0], a[0]);
compare(im4[1], a[1]);
compare(im4[2], a[2]);

if (any(delays != custom_delays))
   error("gif_read($file;delay) (array) failed: delay values read != written"$);
