
static char *process_name = "";

static void find_file_in_path (void)
{
   char *result, *pathlist = NULL, *filename = NULL;

   if (SLang_Num_Function_Args == 2 &&
	 			SLang_pop_slstring(&filename) == 0 &&
				SLang_pop_slstring(&pathlist) == 0) 
   {
	result = SLpath_find_file_in_path(pathlist, filename);
	(void) SLang_push_malloced_string(result);
   }
   else
	SLang_verror(SL_USAGE_ERROR,"string = find_file_in_path(path, file)");

   SLang_free_slstring(pathlist);
   SLang_free_slstring(filename);
}

static SLang_Intrin_Fun_Type ext_Funcs [] =
{
   MAKE_INTRINSIC_0("__find_file_in_path", find_file_in_path, SLANG_VOID_TYPE),
   SLANG_END_INTRIN_FUN_TABLE
};

static SLang_Intrin_Var_Type ext_Vars [] =
{
   MAKE_VARIABLE("__process_name", &process_name, SLANG_STRING_TYPE, 1),
   SLANG_END_INTRIN_VAR_TABLE
};

SLANG_MODULE(findfile);
int init_slshext_module_ns(char *ns_name)
{
   SLang_NameSpace_Type *ns = NULL;

   if (ns_name != NULL) {
	ns = SLns_create_namespace (ns_name);
	if (ns == NULL) return -1;
   }

   if (	-1 == SLns_add_intrin_fun_table (ns, ext_Funcs, (char*)"__findfile__"))
	return -1;

   if (-1 == SLns_add_intrin_var_table (ns, ext_Vars, NULL))
	return -1;

   return 0;
}

static const char *slirpdb_sl = "slirpdb.sl";

static int strip_args(int argc, char **argv)
{
   int arg = 2, i, strip;

   /* The options trimmed here need not be first in the option list,   */
   /* but are intercepted here so as to be applied to all loaded files */
   while (arg < argc) {

	strip = 0;

	if (!strcmp (argv[arg], "-v")) {
	   (void) SLang_load_file_verbose (1);
	   Verbose_Loading = 1;
	   strip = 1;
	   
	}
	else if (!strcmp (argv[arg], "-sldb")) {

	   char *file = SLpath_find_file_in_path(SLSH_PATH, (char*)slirpdb_sl);

	   if (file == NULL) {
		fprintf (stderr, "%s: file not found\n", slirpdb_sl);
		return -1;
	   }

	   argv[1] = file;
	   strip = 1;
	}

	if (strip) {
	   for (i = arg; i < argc - 1; i++) {
		argv[i] = argv[i+1];
		argv[i+1] = NULL;
	   }
	   argc--;
	}
	else
	   arg++;
   }
   return argc;
}


#ifdef main
#undef main
#endif

int main (int argc, char **argv)
{
   process_name = argv[0];

   if (argc > 2)
	argc = strip_args(argc, argv);

   return real_main(argc, argv);
}
