/*
 This file is part of slPIM.
 
 Copyright (c) 2001 John J. Ruthe <phaust@users.sourceforge.net>

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc., 675
 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef _SLPIM_CURSES_H
#define _SLPIM_CURSES_H

extern char *slpim_SCREEN_message, *slpim_string_top, *slpim_string_bot;
extern int slpim_SCREEN_mtype;

extern int NORM_COLOR, CURSORBAR_COLOR, STATUS_COLOR, MESSAGE_I_COLOR,
		MESSAGE_W_COLOR, MESSAGE_E_COLOR, AB_HEAD_COLOR, INPUT_COLOR;
		
extern char *slpim_input_read(char *prompt, char *deflt);
extern int slpim_input_yesno(char *prompt, int deflt);
extern void slpim_update_top_line(void);
extern void slpim_update_bot_line(void);
extern void slpim_write_message(char *mess, int mtype);
extern void slpim_draw_message(void);
extern void slpim_screen_refresh(void);
extern void slpim_screen_init(void);
extern void slpim_screen_finish(void);
extern int slpim_getkey(void);

#endif

