-- See the Copyright notice at the end of this file.
--
class XML_DTD_ATTRIBUTE

insert
	RECYCLABLE
		rename default as any_default
		end

creation {XML_DTD_ELEMENT}
	make

feature {XML_DTD_ELEMENT} -- validation
	is_valid (attributes: DICTIONARY[STRING, STRING]): BOOLEAN is
		local
			value: STRING
		do
			value := attributes.reference_at(name)
			if value = Void then
				Result := is_implied
			else
				Result := list = Void or else list.has(value)
			end
		end

	default: STRING

feature {XML_DTD_ELEMENT} -- building
	name: STRING

	list_value (value: STRING) is
		do
			if list = Void then
				create {HASHED_SET[STRING]} list.make
			end
			list.add(value)
		end

	cdata is
		do
			check
				list = Void
			end
		end

	id is
		do
			check
				list = Void
			end
		end

	idref is
		do
			check
				list = Void
			end
		end

	idrefs is
		do
			check
				list = Void
			end
		end

	nmtoken is
		do
			check
				list = Void
			end
		end

	nmtokens is
		do
			check
				list = Void
			end
		end

	entity is
		do
			check
				list = Void
			end
		end

	entities is
		do
			check
				list = Void
			end
		end

	notation is
		do
			check
				list = Void
			end
		end

	required is
		do
			is_required := True
		end

	implied is
		do
			is_required := False
		end

	fixed (value: like default) is
		do
			check
				list.is_empty
			end
			is_required := True
			if list = Void then
				create {HASHED_SET[STRING]} list.make
			end
			list.add(value)
			default := value
		end

	default_value (value: like default) is
		do
			is_required := False
			check
				list.has(value)
			end
			default := value
		end

feature {}
	list: SET[STRING]

	is_required: BOOLEAN

	is_implied: BOOLEAN is
		do
			Result := not is_required
		end

feature {XML_DTD_ELEMENT}
	make (a_name: like name) is
		require
			not a_name.is_empty
		do
			name := a_name
			implied
		ensure
			name = a_name
			is_implied
		end

feature {WEAK_ARRAY}
	recycle is
		do
			-- nothing
		end

invariant
	not name.is_empty

end -- class XML_DTD_ATTRIBUTE
--
-- ------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- This file is part of the SmartEiffel standard library.
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
-- documentation files (the "Software"), to deal in the Software without restriction, including without
-- limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
-- the Software, and to permit persons to whom the Software is furnished to do so, subject to the following
-- conditions:
--
-- The above copyright notice and this permission notice shall be included in all copies or substantial
-- portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
-- LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO
-- EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
-- AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
-- OR OTHER DEALINGS IN THE SOFTWARE.
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------
