-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
deferred class AUX_JLP8_BASIC_ARRAY[E]

insert
	ANY

feature {ANY}
	make (nb: INTEGER) is
		deferred
		end

	init (first, last: INTEGER) is
		local
			a_item: E; i: INTEGER
		do
			from
				i := first
			until
				i > last
			loop
				put(a_item, i)
				i := i + 1
			end
		end

	capacity: INTEGER is
		deferred
		end

	put (v: E; i: INTEGER) is
		deferred
		end

	force (v: E; i: INTEGER) is
		do
			if i < capacity then
				put(v, i)
			else
				resize(i + 1)
				put(v, i)
			end
		end

	item (i: INTEGER): E is
		deferred
		end

	resize (new_size: INTEGER) is
		deferred
		end

	valid_index (i: INTEGER): BOOLEAN is
		do
		end

end -- class AUX_JLP8_BASIC_ARRAY
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
