-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class INTERNAL_LOCAL
	--
	-- An object of this class holds a special local variable that is internally generated when simplifying some
	-- code. Such variables don't need to be initialized.
	--

	--|*** TODO: it looks like "anchored" does not work well (e.g. test_inspect19 failed). Surely a case of
	--|using current_or_twin_init where appropriate?

inherit
	NON_WRITTEN_EXPRESSION
		redefine written_declaration_type_mark
		end

creation {INTERNAL_LOCAL_LIST}
	anchored, typed

feature {ANY}
	start_position: POSITION

	side_effect_free (type: TYPE): BOOLEAN is
		do
			Result := True
		end

	use_current (type: TYPE): BOOLEAN is
		do
			-- Result := False
		end

	safety_check (type: TYPE) is
		do
			-- nothing
		end

	accept (visitor: INTERNAL_LOCAL_VISITOR) is
		do
			visitor.visit_internal_local(Current)
		end

	non_void_no_dispatch_type (type: TYPE): TYPE is
		do
			if base_type /= Void then
				Result := base_type
			else
				Result := anchor_expression.non_void_no_dispatch_type(type)
			end
		end

	written_declaration_type_mark: TYPE_MARK is
		do
			if base_type /= Void then
				Result := base_type.canonical_type_mark
			else
				Result := anchor_expression.declaration_type.canonical_type_mark
			end
		end

feature {ANY}
	is_writable: BOOLEAN is True

	resolve_in (type: TYPE): TYPE is
		do
			if base_type /= Void then
				Result := base_type
			else
				Result := anchor_expression.resolve_in(type)
			end
		end

	declaration_type: TYPE is
		do
			if base_type /= Void then
				Result := base_type
			else
				Result := anchor_expression.declaration_type
			end
		end

	collect (type: TYPE): TYPE is
		do
			if base_type /= Void then
				Result := base_type
			else
				Result := anchor_expression.collect(type)
			end
		end

	adapt_for (type: TYPE): like Current is
		do
			Result := Current
		end

	is_static: BOOLEAN is False

	compile_to_c (type: TYPE) is
		do
			cpp.print_local(name.to_string)
		end

	mapping_c_target (type, formal_target_type: TYPE) is
		do
			standard_mapping_c_target(type, formal_target_type)
		end

	mapping_c_arg (type: TYPE) is
		do
			compile_to_c(type)
		end

	simplify (type: TYPE): EXPRESSION is
		do
			Result := Current
		end

feature {ANY} -- For `compile_to_jvm':
	compile_to_jvm (type: TYPE) is
		do
			not_yet_implemented
		end

	compile_target_to_jvm (type: TYPE) is
		do
			standard_compile_target_to_jvm(type)
		end

	jvm_branch_if_false (type: TYPE): INTEGER is
		do
			compile_to_jvm(type)
			Result := code_attribute.opcode_ifeq
		end

	jvm_branch_if_true (type: TYPE): INTEGER is
		do
			compile_to_jvm(type)
			Result := code_attribute.opcode_ifne
		end

	jvm_assign, jvm_assign_creation (type: TYPE) is
		do
			not_yet_implemented
		end

feature {INTERNAL_LOCAL_LIST}
	c_declare (type: TYPE; volatile_flag: BOOLEAN) is
			-- Generate the C code for the declaration part. The `volatile_flag' indicate that an extra
			-- volatile C keyword must be generated because we are in the case of a routine with a rescue
			-- clause.
		local
			static_tm: TYPE_MARK
		do
			static_tm := declaration_type.canonical_type_mark
			if volatile_flag then
				if static_tm.is_kernel_expanded then
					cpp.pending_c_function_body.append(once "volatile ")
				end
			end
			static_tm.c_type_for_result_in(cpp.pending_c_function_body)
			cpp.pending_c_function_body.extend(' ')
			cpp.print_local(name.to_string)
			cpp.pending_c_function_body.append(once "; ")
			if tag /= Void then
				cpp.pending_c_function_body.append(once " /* ")
				cpp.pending_c_function_body.append(tag)
				cpp.pending_c_function_body.append(once " */ ")
			end
			if anchor_expression /= Void then
				cpp.put_position_comment(anchor_expression.start_position)
			else
				cpp.put_position_comment(start_position)
			end
			cpp.pending_c_function_body.extend('%N')
		end

feature {}
	anchored (a_name: like name; a_anchor_expression: like anchor_expression; position: like start_position; a_tag: like tag) is
		require
			a_name /= Void
			a_anchor_expression /= Void
		do
			name := a_name
			anchor_expression := a_anchor_expression
			start_position := position
			tag := a_tag
		ensure
			name = a_name
			anchor_expression = a_anchor_expression
			start_position = position
			tag = a_tag
		end

	typed (a_name: like name; a_base_type: like base_type; position: like start_position; a_tag: like tag) is
		require
			a_name /= Void
			a_base_type /= Void
		do
			name := a_name
			base_type := a_base_type
			start_position := position
			tag := a_tag
		ensure
			name = a_name
			base_type = a_base_type
			start_position = position
			tag = a_tag
		end

	name: HASHED_STRING
			-- The variable name.

	anchor_expression: EXPRESSION
			-- The expression that will be affected to this variable; hence, it determines its type.

	base_type: TYPE
			-- The local type, if it is statically known.

	tag: STRING
			-- Some random comment about this variable; may be inserted in the generated C code.

invariant
	name /= Void
	anchor_expression /= Void /= (base_type /= Void)

end -- class INTERNAL_LOCAL
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2006: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
