-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class PRECURSOR_INSTRUCTION
	--
	-- Handling of the `Precursor' procedure call.
	--

inherit
	INSTRUCTION
	PRECURSOR_CALL
	
creation {ANY}
	make

feature {ANY}
	end_mark_comment: BOOLEAN is False

	specialize_2 (type: TYPE): like Current is
			--|*** Duplicate code in PRECURSOR_INSTRUCTION / PRECURSOR_EXPRESSION
		local
			af: like specialized_anonymous_feature; arg: like arguments
		do
			af := specialized_anonymous_feature.specialize_2(type)
			if arguments /= Void then
				arg := arguments.specialize_2(type, specialized_anonymous_feature, type, True)
				check
					specialized_anonymous_feature.arguments.count = arg.count
				end
			end
			Result := current_or_twin_init(af, arg)
		end

	simplify (type: TYPE): like Current is
			--|*** Duplicate code in PRECURSOR_INSTRUCTION / PRECURSOR_EXPRESSION
		local
			af: like specialized_anonymous_feature; arg: like arguments
		do
			af := specialized_anonymous_feature.simplify(type)
			if arguments /= Void then
				arg := arguments.simplify(type)
			end
			Result := current_or_twin_init(af, arg)
		end

	accept (visitor: PRECURSOR_INSTRUCTION_VISITOR) is
		do
			visitor.visit_precursor_instruction(Current)
		end

	collect (t: TYPE) is
		do
			--|*** Attention ici on fait simple : si le Precursor s'appelle
			--| lui-même, la liaison dynamique est suivie (-> rappel de la
			--| fonction redéfinie).
			--| Le choix contraire (qui consiste à dire qu'il s'agit d'un double
			--| héritage + redéfinition => suivre "la bonne branche") est très
			--| complexe à implanter, est-ce utile ?
			specialized_anonymous_feature.collect_precursor(t, specialized_parent)
			if arguments /= Void then
				arguments.simple_collect(t, specialized_anonymous_feature.arguments)
			end
		end

	side_effect_free (type: TYPE): BOOLEAN is
		do
		end

	pretty (indent_level: INTEGER) is
		do
			pretty_printer.set_indent_level(indent_level)
			pretty_(indent_level)
			if pretty_printer.semi_colon_flag then
				pretty_printer.put_character(';')
			end
		end

end -- class PRECURSOR_INSTRUCTION
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
