-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries.
-- See the Copyright notice at the end of this file.
--
class AGENT_EQUAL
	--
	-- To define the equality of two agents
	--
insert
	GLOBALS

create {AGENT_CREATION}
	make

feature {}
	capture_list: FAST_ARRAY[EXPRESSION]
	delayed_call: CALL
	delayed_proc_call: PROC_CALL

	compute_mold_id (type: TYPE) is
		local
			i: INTEGER; expression: EXPRESSION
			fs: FEATURE_STAMP; rf: RUN_FEATURE
		do
			mold_id.copy(once "agent_eq")
			from
				i := capture_list.lower
			until
				i > capture_list.upper
			loop
				expression := capture_list.item(i)
				if expression.is_void then
					mold_id.extend('V')
				else
					mold_id.extend('C')
					expression.resolve_in(type).id.append_in(mold_id)
				end
				i := i + 1
			end
			if delayed_proc_call /= Void then
				expression := delayed_proc_call.target
				fs := delayed_proc_call.feature_stamp
			else
				expression := delayed_call.target
				fs := delayed_call.feature_stamp
			end
			rf := fs.run_feature_for(expression.resolve_in(type))
			mold_id.extend('_')
			rf.mapping_name_in(mold_id)
		end

feature {AGENT_CREATION}
	mold_id: STRING

	set_capture_list (a_capture_list: like capture_list) is
		do
			capture_list := a_capture_list
		ensure
			capture_list = a_capture_list
		end

	set_call (dc: like delayed_call; dpc: like delayed_proc_call) is
		do
			delayed_call := dc
			delayed_proc_call := dpc
		end

	c_define_type (type: TYPE) is
			-- An alias type just to allow simple type casts
		local
			i: INTEGER; expression: EXPRESSION
		do
			compute_mold_id(type)
			if not type_generated.has(mold_id) then
				cpp.out_h_buffer.copy(once "typedef struct _se_")
				cpp.out_h_buffer.append(mold_id)
				cpp.out_h_buffer.append(once " se_")
				cpp.out_h_buffer.append(mold_id)
				cpp.out_h_buffer.append(once ";%Nstruct _se_")
				cpp.out_h_buffer.append(mold_id)
				cpp.out_h_buffer.append(once "{Tid id;%Nint creation_mold_id;%N")
				cpp.out_h_buffer.append(once "void*afp;%N")
				if not gc_handler.is_off then
					cpp.out_h_buffer.append(once "void*gc_mark_agent_mold;%N")
				end
				cpp.out_h_buffer.append(once "void*eq;%N")
				from
					i := capture_list.lower
				until
					i > capture_list.upper
				loop
					expression := capture_list.item(i)
					if expression.is_void then
						cpp.out_h_buffer.append(once "T0*")
					else
						expression.resolve_in(type).canonical_type_mark.c_type_for_result_in(cpp.out_h_buffer)
					end
					cpp.out_h_buffer.append(once " c")
					i.append_in(cpp.out_h_buffer)
					cpp.out_h_buffer.extend(';')
					i := i + 1
				end
				cpp.out_h_buffer.append(once "};%N")
				cpp.write_out_h_buffer
				type_generated.add(mold_id.twin)
			end
		ensure
			was_generated: type_generated.has(mold_id)
		end

	c_define_function (type: TYPE) is
		local
			i: INTEGER; expression: EXPRESSION; t: TYPE
		do
			compute_mold_id(type)
			if not function_generated.has(mold_id) then
				cpp.prepare_c_function
				cpp.pending_c_function_signature.append(once "/*agent equality*/int eq_")
				cpp.pending_c_function_signature.append(mold_id)
				cpp.pending_c_function_signature.append(once "(se_agent*u1, se_agent*u2)")

				cpp.pending_c_function_body.append(once "int R=1;%Nse_")
				cpp.pending_c_function_body.append(mold_id)
				cpp.pending_c_function_body.append(once "*a1=(se_")
				cpp.pending_c_function_body.append(mold_id)
				cpp.pending_c_function_body.append(once "*)u1;%Nse_")
				cpp.pending_c_function_body.append(mold_id)
				cpp.pending_c_function_body.append(once "*a2=(se_")
				cpp.pending_c_function_body.append(mold_id)
				cpp.pending_c_function_body.append(once "*)u2;%N")
				from
					i := capture_list.lower
				until
					i > capture_list.upper
				loop
					expression := capture_list.item(i)
					if not expression.is_void then
						t := expression.resolve_in(type)
						cpp.pending_c_function_body.append(once "R&=")
						if t.is_user_expanded and then t.canonical_type_mark.need_c_struct then
							cpp.pending_c_function_body.append(once "se_cmpT")
							t.id.append_in(cpp.pending_c_function_body)
							cpp.pending_c_function_body.append(once "(a1->c")
							i.append_in(cpp.pending_c_function_body)
							cpp.pending_c_function_body.append(once ",a2->c")
							i.append_in(cpp.pending_c_function_body)
							cpp.pending_c_function_body.extend(')')
						else
							cpp.pending_c_function_body.append(once "a1->c")
							i.append_in(cpp.pending_c_function_body)
							cpp.pending_c_function_body.append(once "==a2->c")
							i.append_in(cpp.pending_c_function_body)
						end
						cpp.pending_c_function_body.append(once ";%N")
					end
					i := i + 1
				end
				cpp.pending_c_function_body.append(once "return R;%N")
				cpp.dump_pending_c_function(True)
				function_generated.add(mold_id.twin)
			end
		ensure
			was_generated: function_generated.has(mold_id)
		end

feature {}
	function_generated: HASHED_SET[STRING] is
		once
			create Result.make
		end

	type_generated: HASHED_SET[STRING] is
		once
			create Result.make
		end

	make is
		do
			create mold_id.make_empty
		end

invariant
	mold_id /= Void
	not string_aliaser.registered_one(mold_id)

end -- class AGENT_EQUAL
--
-- ------------------------------------------------------------------------------------------------------------------------------
-- Copyright notice below. Please read.
--
-- SmartEiffel is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License,
-- as published by the Free Software Foundation; either version 2, or (at your option) any later version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have
-- received a copy of the GNU General Public License along with SmartEiffel; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.       - University of Nancy 1 - FRANCE
-- Copyright(C) 2003-2004: INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne - University of Nancy 2 - FRANCE
--
-- Authors: Dominique COLNET, Philippe RIBET, Cyril ADRIAN, Vincent CROIZIER, Frederic MERIZEN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
-- ------------------------------------------------------------------------------------------------------------------------------
