/***************************************************************************
    smb4kauthinfo.cpp  -  This class provides a container for the 
    authentication data that is passed and taken by the password reader.
                             -------------------
    begin                : Sa Feb 28 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qregexp.h>
 
// application specific includes
#include "smb4kauthinfo.h"

Smb4KAuthInfo::Smb4KAuthInfo( const QString &wg, const QString &h, const QString &s, const QString &u, const QString &p ) : m_workgroup(wg), m_host(h), m_share(s), m_user(u), m_password(p)
{
}


Smb4KAuthInfo::Smb4KAuthInfo( const Smb4KAuthInfo &i ) : m_workgroup( i.workgroup() ), m_host( i.host() ), m_share( i.share() ), m_user( i.user() ), m_password( i.password() )
{
}


Smb4KAuthInfo::~Smb4KAuthInfo()
{
}


void Smb4KAuthInfo::setUser( const QString &user )
{
  m_user = user;
}


void Smb4KAuthInfo::setPassword( const QString &passwd )
{
  m_password = passwd;
}


void Smb4KAuthInfo::setShare( const QString &share )
{
  m_share = share;
}


QString Smb4KAuthInfo::maskedPassword() const
{
  QString p = m_password.stripWhiteSpace();
  
  // Replace special characters.
  p.replace( "\\", "\\\\" );
  p.replace( "'", "\\'" );
  p.replace( "$", "\\$" );
  p.replace( "#", "\\#" );
  p.replace( "\"", "\\\"" );
  p.replace( "&", "\\&" );
  p.replace( ";", "\\;" );
  p.replace( "<", "\\<" );
  p.replace( ">", "\\>" );
  p.replace( "|", "\\|" );
  p.replace( "?", "\\?" );
  p.replace( "(", "\\(" );
  p.replace( ")", "\\)" );
  p.replace( "[", "\\[" );
  p.replace( "]", "\\]" );
  p.replace( "{", "\\{" );
  p.replace( "}", "\\}" );
  p.replace( "'", "\\'" );
  p.replace( "`", "\\`" );
  p.replace( "*", "\\*" );
  p.replace( "", "\\" );
  p.replace( "%", "\\%" );
  
  return p;
}
