/***************************************************************************
                          smb4kcore  -  description
                             -------------------
    begin                : Do Apr 8 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KCORE_H
#define SMB4KCORE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>

// application specific includes
#include "smb4kscanner.h"
#include "smb4kmounter.h"
#include "smb4kpasswdreader.h"
#include "smb4kfileio.h"
#include "smb4kipfinder.h"
#include "smb4kbookmarkhandler.h"
#include "smb4kprint.h"
#include "smb4kshellio.h"


/**
 * This is the top-level core class. It inherits all other core classes 
 * except the containers.
 */

class Smb4KCore : public QObject
{
  Q_OBJECT
  
  public:
    /**
     * The constructor.
     */
    Smb4KCore( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KCore();
    /**
     * Returns the state the scanner is in.
     */
    int scannerState() { return m_scanner_state; }
    /**
     * Returns TRUE, if the scanner is running, otherwise FALSE.
     */
    bool scannerIsRunning() { return m_scanner_running; }
    /**
     * Returns the state the mounter is in.
     */
    int mounterState() { return m_mounter_state; }
    /**
     * Returns TRUE, if the mounter is running, otherwise FALSE.
     */
    bool mounterIsRunning() { return m_mounter_running; }
    /**
     * Returns the state the IP finder is in.
     */
    int ipFinderState() { return m_ipfinder_state; }
    /**
     * Returns TRUE, if the IP finder is running, otherwise FALSE.
     */
    bool ipFinderIsRunning() { return m_ipfinder_running; }
    /**
     * Returns the state the print object is in.
     */
    int printState() { return m_print_state; }
    /**
     * Returns TRUE, if the print object is running, otherwise FALSE.
     */
    bool printIsRunning() { return m_print_running; }
    /**
     * Returns TRUE if one of the core classes is doing something.
     */
    bool isRunning();
    /**
     * Returns the current state the core class is in.
     */
    int currentState() { return m_current_state; }
    /**
     * Returns a pointer to the scanner object.
     */
    Smb4KScanner *scanner() { return m_scanner; }
    /**
     * Returns a pointer to the mounter object.
     */
    Smb4KMounter *mounter() { return m_mounter; }
    /**
     * Returns a pointer to the bookmark handler object.
     */
    Smb4KBookmarkHandler *bookmarkHandler() { return m_bookmarkHandler; }
    /**
     * Returns a pointer to the file IO object.
     */
    Smb4KFileIO *fileIO() { return m_fileIO; }
    /**
     * Returns a pointer to the IP finder object.
     */
    Smb4KIPFinder *ipFinder() { return m_finder; }
    /**
     * Returns a pointer to the password reader object.
     */
    Smb4KPasswdReader *passwdReader() { return m_reader; }
    /**
     * Returns a pointer to the printer handler object.
     */
    Smb4KPrint *print() { return m_print; }
    /**
     * Returns the pointer ti the shell IO object.
     */
    Smb4KShellIO *shellIO() { return m_shellIO; }
    /**
     * Reads the options for the core classes.
     */
    void readOptions();
    /**
     * Aborts any action of the core.
     */
    void abort();
    /**
     * Opens the given URL. This function is used to run
     * Konqueror.
     */
    void open( const QString &url );
    
  signals:
    /**
     * This signal is emitted, if one of the core objects
     * starts or stops running.
     */
    void runStateChanged();
    
  protected slots:
    /**
     * This slot is called, if the scanner is running. 
     */
    void slotScannerIsRunning( int state, bool on );
    /**
     * This slot is called, if the mounter is running.
     */
    void slotMounterIsRunning( int state, bool on );
    /**
     * This slot is called, if the mounter is running.
     */
    void slotIPFinderIsRunning( int state, bool on );
    /**
     * This slot is called, if the printer handler is running.
     */
    void slotPrinterHandlerIsRunning( int state, bool on );
    /**
     * This slot is called if an error in the core classes
     * occurred.
     */
    void slotShowErrorMessage( int error_code, const QString &error_message = QString::null );
  
  private:
    /**
     * The scanner object.
     */
    Smb4KScanner *m_scanner;
    /**
     * The mounter object.
     */
    Smb4KMounter *m_mounter;
    /**
     * The bookmark handler object.
     */
    Smb4KBookmarkHandler *m_bookmarkHandler;
    /**
     * The FileIO object.
     */
    Smb4KFileIO *m_fileIO;
    /**
     * The IP finder object.
     */
    Smb4KIPFinder *m_finder;
    /**
     * The password reader object.
     */
    Smb4KPasswdReader *m_reader;
    /**
     * The printer handler object.
     */
    Smb4KPrint *m_print;
    /**
     * The shell IO object.
     */
    Smb4KShellIO *m_shellIO;
    /**
     * The state the sanner is in.
     */
    int m_scanner_state;
    /**
     * Is TRUE when the scanner is running, otherwise it is FALSE.
     */
    bool m_scanner_running;
    /**
     * The state the mounter is in.
     */
    int m_mounter_state;
    /**
     * Is TRUE when the mounter is running, otherwise it is FALSE.
     */
    bool m_mounter_running;
    /**
     * The state the IP finder is in.
     */
    int m_ipfinder_state;
    /**
     * Is TRUE when the IP finder is running, otherwise it is FALSE.
     */
    bool m_ipfinder_running;
    /**
     * Holds the current state.
     */
    int m_current_state;
    /**
     * This function is used to set the current state of the core.
     */
    void setCurrentState( int state );
    /**
     * The state the printer handler is in.
     */
    int m_print_state;
    /**
     * Is TRUE when the printer handler is running, otherwise it is FALSE.
     */
    bool m_print_running;
    /**
     * The advanced options for smbclient.
     */
    QString m_advancedSMBOptions;
};
 
#endif
